/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class StringLiteral {
    public static final String BACK_QUOTE = "``";
    public static final String DOUBLE_QUOTE = "\"\"";
    public static final String U_DOUBLE_QUOTE = "U&\"\"";
    public static final String U_SINGLE_QUOTE = "U&''";
    public static final String E_SINGLE_QUOTE = "E''";
    public static final String N_SINGLE_QUOTE = "N''";
    public static final String Q_SINGLE_QUOTE = "Q''";
    public static final String SINGLE_QUOTE = "''";
    public static final String BRACE = "{}";
    public static final String DOLLAR = "$$";
    public static final String BRACKET = "[]";
    private static final Map<String, String> literals = new HashMap<String, String>(Arrays.stream(Preset.values()).collect(Collectors.toMap(Preset::getKey, Preset::getRegex)));

    public static String get(String key) {
        return literals.get(key);
    }

    private static enum Preset {
        BACK_QUOTE("``", "((`[^`]*($|`))+)"),
        DOUBLE_QUOTE("\"\"", "((\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*(\"|$))+)"),
        BRACKET("[]", "((\\[[^\\]]*($|\\]))(\\][^\\]]*($|\\]))*)"),
        BRACE("{}", "((\\{[^\\}]*($|\\}))+)"),
        SINGLE_QUOTE("''", "(('[^'\\\\]*(?:\\\\.[^'\\\\]*)*('|$))+)"),
        N_SINGLE_QUOTE("N''", "((N'[^'\\\\]*(?:\\\\.[^'\\\\]*)*('|$))+)"),
        Q_SINGLE_QUOTE("Q''", "(?i)" + String.join((CharSequence)"|", "((n?q'\\{(?:(?!\\}'|\\\\).)*\\}')+)", "((n?q'\\[(?:(?!\\]'|\\\\).)*\\]')+)", "((n?q'<(?:(?!>'|\\\\).)*>')+)", "((n?q'\\((?:(?!\\)'|\\\\).)*\\)')+)")),
        E_SINGLE_QUOTE("E''", "((E'[^'\\\\]*(?:\\\\.[^'\\\\]*)*('|$))+)"),
        U_SINGLE_QUOTE("U&''", "((U&'[^'\\\\]*(?:\\\\.[^'\\\\]*)*('|$))+)"),
        U_DOUBLE_QUOTE("U&\"\"", "((U&\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*(\"|$))+)"),
        DOLLAR("$$", "((?<tag>\\$\\w*\\$)[\\s\\S]*?(?:\\k<tag>|$))");

        public final String key;
        public final String regex;

        private Preset(String key, String regex) {
            this.key = key;
            this.regex = regex;
        }

        public String getKey() {
            return this.key;
        }

        public String getRegex() {
            return this.regex;
        }
    }
}

