/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational;

import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class InExpression
extends ASTNodeAccessImpl
implements Expression,
SupportsOldOracleJoinSyntax {
    private Expression leftExpression;
    private boolean not = false;
    private Expression rightExpression;
    private int oldOracleJoinSyntax = 0;

    public InExpression() {
    }

    public InExpression(Expression leftExpression, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    @Override
    public void setOldOracleJoinSyntax(int oldOracleJoinSyntax) {
        this.oldOracleJoinSyntax = oldOracleJoinSyntax;
        if (oldOracleJoinSyntax < 0 || oldOracleJoinSyntax > 1) {
            throw new IllegalArgumentException("unexpected join type for oracle found with IN (type=" + oldOracleJoinSyntax + ")");
        }
    }

    @Override
    public int getOldOracleJoinSyntax() {
        return this.oldOracleJoinSyntax;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public InExpression withLeftExpression(Expression expression) {
        this.setLeftExpression(expression);
        return this;
    }

    public final void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean b) {
        this.not = b;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    private String getLeftExpressionString() {
        return this.leftExpression + (this.oldOracleJoinSyntax == 1 ? "(+)" : "");
    }

    public String toString() {
        StringBuilder statementBuilder = new StringBuilder();
        statementBuilder.append(this.getLeftExpressionString());
        statementBuilder.append(" ");
        if (this.not) {
            statementBuilder.append("NOT ");
        }
        statementBuilder.append("IN ");
        statementBuilder.append(this.rightExpression);
        return statementBuilder.toString();
    }

    @Override
    public int getOraclePriorPosition() {
        return 0;
    }

    @Override
    public void setOraclePriorPosition(int priorPosition) {
        if (priorPosition != 0) {
            throw new IllegalArgumentException("unexpected prior for oracle found");
        }
    }

    public InExpression withRightExpression(Expression rightExpression) {
        this.setRightExpression(rightExpression);
        return this;
    }

    @Override
    public InExpression withOldOracleJoinSyntax(int oldOracleJoinSyntax) {
        this.setOldOracleJoinSyntax(oldOracleJoinSyntax);
        return this;
    }

    @Override
    public InExpression withOraclePriorPosition(int priorPosition) {
        this.setOraclePriorPosition(priorPosition);
        return this;
    }

    public InExpression withNot(boolean not) {
        this.setNot(not);
        return this;
    }

    public <E extends Expression> E getLeftExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getLeftExpression()));
    }

    public <E extends Expression> E getRightExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getRightExpression()));
    }
}

