/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryEntry;
import com.datical.liquibase.ext.sqlgenerator.DatabaseChangeLogHistoryColumns;
import com.datical.liquibase.ext.sqlgenerator.InsertDatabaseChangeLogHistoryGenerator;
import com.datical.liquibase.ext.statement.SelectFromDatabaseChangeLogHistoryStatement;
import com.datical.liquibase.ext.util.JsonMinifyUtil;
import com.datical.liquibase.ext.util.ProSnakeYamlUtil;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.mdc.MdcManager;
import liquibase.logging.mdc.MdcObject;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.serializer.core.yaml.YamlSerializer;
import liquibase.snapshot.SnapshotControl;
import liquibase.statement.SqlStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.util.ValueHandlerUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class DbclHistoryCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"dbclHistory"};
    public static final String[] ALIAS_COMMAND_NAME = new String[]{"databaseChangelogHistory"};
    public static final CommandArgumentDefinition<Boolean> VERBOSE_ARG;
    public static final CommandArgumentDefinition<Format> FORMAT_ARG;
    private static final JsonMinifyUtil minify;

    private Yaml setupSnakeYaml() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setSplitLines(false);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        YamlSerializer.LiquibaseRepresenter liquibaseRepresenter = new YamlSerializer.LiquibaseRepresenter(dumperOptions);
        SafeConstructor constructor = new SafeConstructor(YamlParser.createLoaderOptions());
        liquibaseRepresenter.addClassTag(DatabaseChangeLogHistoryEntry.class, Tag.MAP);
        return new Yaml((BaseConstructor)constructor, (Representer)liquibaseRepresenter, dumperOptions, (Resolver)new YamlSerializer.LiquibaseResolver());
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME, ALIAS_COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("List all rows from the Liquibase Pro 'DATABASECHANGELOGHISTORY' tracking table."));
        if (commandDefinition.is(ALIAS_COMMAND_NAME)) {
            commandDefinition.setHidden(true);
        }
    }

    public List<Class<?>> requiredDependencies() {
        return Collections.singletonList(Database.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        if (!DatabaseChangelogHistoryConfiguration.isHistoryEnabled()) {
            Scope.getCurrentScope().getUI().sendMessage("WARNING: The DATABASECHANGELOGHISTORY feature is not currently enabled. Please set your Pro License key, and set '--dbclhistory-enabled=true' on CLI or via Environment variable, etc. Then try 'liquibase dbcl-history' command again.");
            return;
        }
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        Boolean verbose = (Boolean)commandScope.getArgumentValue(VERBOSE_ARG);
        Format format = (Format)((Object)commandScope.getArgumentValue(FORMAT_ARG));
        if (InsertDatabaseChangeLogHistoryGenerator.getDatabaseChangeLogHistoryTable(new SnapshotControl(database, false, new Class[]{Table.class, Column.class}), database) == null) {
            Scope.getCurrentScope().getUI().sendMessage("WARNING: The " + DatabaseChangelogHistoryConfiguration.getTableName(database) + " table does not currently exist. Please set your Pro License key, and set '--dbclhistory-enabled=true' on CLI or via Environment variable, etc and then run an update or rollback command. Then try 'liquibase dbcl-history' command again.");
            return;
        }
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        SelectFromDatabaseChangeLogHistoryStatement selectStatement = new SelectFromDatabaseChangeLogHistoryStatement(verbose);
        List resultSet = executor.queryForList((SqlStatement)selectStatement);
        List<DatabaseChangeLogHistoryEntry> entries = DatabaseChangeLogHistoryColumns.fromResultSet(resultSet, verbose);
        MdcManager mdcManager = Scope.getCurrentScope().getMdcManager();
        try (MdcObject mdcDbclHistory = mdcManager.put("dbclHistory", entries);){
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Loaded " + entries.size() + " database changelog history entries.");
        }
        Yaml yaml = this.setupSnakeYaml();
        String dump = yaml.dump(entries);
        dump = ProSnakeYamlUtil.removeClassTypeMarksFromSerializedJson(dump);
        dump = dump.replaceAll("\"iinterface\":", "\"interface\":");
        if (Format.JSON.equals((Object)format)) {
            dump = minify.minify(dump);
        }
        dump = dump + System.lineSeparator();
        resultsBuilder.getOutputStream().write(dump.getBytes());
    }

    static {
        minify = new JsonMinifyUtil();
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME, ALIAS_COMMAND_NAME});
        VERBOSE_ARG = builder.argument("verbose", Boolean.class).description("Set to 'true' to output all data from '" + DatabaseChangeLogHistoryColumns.EXECUTEDSQL.getColumnName() + "' and '" + DatabaseChangeLogHistoryColumns.EXTENSIONS.getColumnName() + "' columns").defaultValue((Object)false).build();
        FORMAT_ARG = builder.argument("format", Format.class).description("Sets the output method to '" + (Object)((Object)Format.JSON) + "' or '" + (Object)((Object)Format.JSON_PRETTY) + "'").defaultValue((Object)Format.JSON).setValueHandler(entry -> (Format)ValueHandlerUtil.getEnum(Format.class, (Object)entry, (String)"format")).build();
    }

    private static enum Format {
        JSON,
        JSON_PRETTY;

    }
}

