/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.visitor.DatabaseChangelogHistoryChangeExecListener;
import com.datical.liquibase.ext.checks.snapshot.DatabaseSnapshotHelper;
import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.DropAllCommandStep;
import liquibase.database.Database;
import liquibase.snapshot.SnapshotControl;

@CommandOverride(override=DropAllCommandStep.class)
public class ProDropAllCommandStep
extends DropAllCommandStep {
    public static final CommandArgumentDefinition<Boolean> DROP_DBCL_HISTORY;

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Boolean shouldDrop = (Boolean)commandScope.getArgumentValue(DROP_DBCL_HISTORY);
        if (DatabaseChangelogHistoryConfiguration.isHistoryEnabled() && Boolean.FALSE.equals(shouldDrop)) {
            HashMap<String, Serializable> scopeValues = new HashMap<String, Serializable>();
            scopeValues.put("completeSql", new AtomicReference());
            scopeValues.put("shouldDropHistoryTable", shouldDrop);
            Scope.child(scopeValues, () -> {
                Database database = (Database)commandScope.getDependency(Database.class);
                try {
                    super.run(resultsBuilder);
                    new DatabaseChangelogHistoryChangeExecListener().logEvent(null, database, "success", commandScope);
                }
                catch (Exception e) {
                    new DatabaseChangelogHistoryChangeExecListener().logEvent(null, database, "fail", commandScope);
                    throw e;
                }
            });
        } else {
            Scope.child(Collections.singletonMap("shouldDropHistoryTable", shouldDrop), () -> super.run(resultsBuilder));
        }
    }

    public SnapshotControl getSnapshotControl(CommandScope commandScope, Database database) {
        Boolean shouldDrop = (Boolean)commandScope.getArgumentValue(DROP_DBCL_HISTORY);
        if (DatabaseChangelogHistoryConfiguration.isHistoryEnabled() && Boolean.FALSE.equals(shouldDrop)) {
            return DatabaseSnapshotHelper.createSnapshotControlExcludingTables(database, Collections.singletonList(DatabaseChangelogHistoryConfiguration.getTableName(database)));
        }
        return super.getSnapshotControl(commandScope, database);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        DROP_DBCL_HISTORY = builder.argument("dropDbclhistory", Boolean.class).description(ProStringUtil.markWithPro("If true, the database changelog history table will be dropped")).defaultValue((Object)false).build();
    }
}

