/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.command.init.InitCopyCommandStep;
import com.datical.liquibase.ext.copy.ProjectCopier;
import com.datical.liquibase.ext.copy.ProjectCopierFactory;
import com.datical.liquibase.ext.init.InitProjectUtil;
import com.datical.liquibase.ext.init.InteractivePromptingValueProvider;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;

public class InitProjectCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "project"};
    private static final String[] ALIAS = new String[]{"init", "project-new"};
    public static final CommandArgumentDefinition<String> INIT_PROJECT_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> INIT_CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_DEFAULTS_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_PROJECT_GUIDE_ARG;
    public static final CommandArgumentDefinition<Boolean> INIT_PROJECT_RECURSIVE_ARG;
    public static final CommandArgumentDefinition<Boolean> INIT_PROJECT_KEEP_TEMP_FILES_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<Boolean> COPY_EXAMPLE_FLOW_FILES;
    public static final CommandArgumentDefinition<Boolean> COPY_EXAMPLE_CHECKS_PACKAGE_FILE;
    public static final String SHOULD_BACKUP_DEFAULTS_FILE_ARG = "shouldBackupDefaultsFile";
    public static final String USED_H2_KEY = "usedH2";

    private boolean isProjectGuideOn(String projectGuide) {
        return projectGuide.equalsIgnoreCase("on");
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum enumToPrompt, InteractivePromptingValueProvider interactivePromptingValueProvider) {
        this.doPrompt(configuredValue, commandArgumentDefinition, commandScope, enumToPrompt, interactivePromptingValueProvider, null);
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum enumToPrompt, InteractivePromptingValueProvider interactivePromptingValueProvider, Object currentValue) {
        if (configuredValue.wasDefaultValueUsed()) {
            Object prompt = enumToPrompt.interactiveCommandLineValueGetter.prompt(new RuleParameter(enumToPrompt), null, currentValue);
            if (!((String)configuredValue.getValue()).equals(prompt)) {
                interactivePromptingValueProvider.addValue(commandScope.getCompleteConfigPrefix() + "." + commandArgumentDefinition.getName(), prompt);
            }
        }
    }

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        String projectGuide;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        ConfiguredValue projectGuideConfig = commandScope.getConfiguredValue(INIT_PROJECT_GUIDE_ARG);
        HashMap<String, Boolean> scopeValues = new HashMap<String, Boolean>();
        if (!projectGuideConfig.wasDefaultValueUsed() && this.isProjectGuideOn(projectGuide = (String)projectGuideConfig.getValue())) {
            scopeValues.put(GlobalConfiguration.HEADLESS.getKey(), false);
        }
        try {
            LiquibaseConfiguration lbConf = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            Optional<ConfigurationValueProvider> providerOpt = lbConf.getProviders().stream().filter(vp -> vp instanceof DefaultsFileValueProvider).findFirst();
            providerOpt.ifPresent(arg_0 -> ((LiquibaseConfiguration)lbConf).unregisterProvider(arg_0));
            Scope.child(scopeValues, () -> this.internalRun(resultsBuilder));
            providerOpt.ifPresent(arg_0 -> ((LiquibaseConfiguration)lbConf).registerProvider(arg_0));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void internalRun(CommandResultsBuilder resultsBuilder) throws Exception {
        String message;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        ConfiguredValue defaultsFileConfig = commandScope.getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
        ConfiguredValue formatConfig = commandScope.getConfiguredValue(INIT_FORMAT_ARG);
        ConfiguredValue changelogFileConfig = commandScope.getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
        ConfiguredValue projectDirConfig = commandScope.getConfiguredValue(INIT_PROJECT_DIR_ARG);
        ConfiguredValue urlConfig = commandScope.getConfiguredValue(URL_ARG);
        ConfiguredValue usernameConfig = commandScope.getConfiguredValue(USERNAME_ARG);
        ConfiguredValue passwordConfig = commandScope.getConfiguredValue(PASSWORD_ARG);
        String projectGuide = (String)commandScope.getConfiguredValue(INIT_PROJECT_GUIDE_ARG).getValue();
        boolean skippedChangelogFileCreation = false;
        boolean skippedDefaultsFileCreation = false;
        String inputProjectDir = (String)projectDirConfig.getValue();
        String projectDir = (String)projectDirConfig.getValue();
        ProjectCopier projectCopier = ((ProjectCopierFactory)Scope.getCurrentScope().getSingleton(ProjectCopierFactory.class)).getProjectCopier(projectDir);
        this.checkForS3Jar(projectCopier);
        if (this.shouldPrompt((ConfiguredValue<String>)defaultsFileConfig, (ConfiguredValue<String>)formatConfig, (ConfiguredValue<String>)changelogFileConfig, (ConfiguredValue<String>)projectDirConfig, (ConfiguredValue<String>)urlConfig, (ConfiguredValue<String>)usernameConfig, (ConfiguredValue<String>)passwordConfig, projectGuide)) {
            String response = (String)Scope.getCurrentScope().getUI().prompt("Setup new liquibase.properties, flowfile, and sample changelog? Enter (Y)es with defaults, yes with (C)ustomization, or (N)o.", (Object)"Y", (input, type) -> {
                List<String> permissibleEntries = Arrays.asList("y", "yes", "n", "no", "c", "custom", "customize");
                if (input == null || permissibleEntries.stream().noneMatch(pe -> pe.equalsIgnoreCase(input))) {
                    throw new IllegalArgumentException();
                }
                return input;
            }, String.class);
            if (response.toLowerCase().startsWith("c")) {
                String message2;
                InteractivePromptingValueProvider interactivePromptingValueProvider = new InteractivePromptingValueProvider();
                ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).registerProvider((ConfigurationValueProvider)interactivePromptingValueProvider);
                this.doPrompt((ConfiguredValue<String>)projectDirConfig, INIT_PROJECT_DIR_ARG, commandScope, DynamicRuleParameterEnum.PROJECT_DIR, interactivePromptingValueProvider);
                projectDirConfig = commandScope.getConfiguredValue(INIT_PROJECT_DIR_ARG);
                projectDir = (String)projectDirConfig.getValue();
                projectCopier = ((ProjectCopierFactory)Scope.getCurrentScope().getSingleton(ProjectCopierFactory.class)).getProjectCopier(projectDir);
                String latestChangelogFilename = this.findLatestChangelogFilename((ConfiguredValue<String>)projectDirConfig);
                this.doPrompt((ConfiguredValue<String>)changelogFileConfig, INIT_CHANGELOG_FILE_ARG, commandScope, DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME, interactivePromptingValueProvider, latestChangelogFilename);
                changelogFileConfig = commandScope.getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
                skippedChangelogFileCreation = this.isSkipped((ConfiguredValue<String>)changelogFileConfig);
                if (skippedChangelogFileCreation) {
                    message2 = "No changelog file will be created. Specify a valid changelog file on the CLI, via Environment variable, or in your defaults file. ";
                    Scope.getCurrentScope().getUI().sendMessage(InitProjectCommandStep.addGettingStarted(message2));
                } else if (InitProjectUtil.determineFormatType((String)changelogFileConfig.getValue(), null) == null) {
                    this.doPrompt((ConfiguredValue<String>)formatConfig, INIT_FORMAT_ARG, commandScope, DynamicRuleParameterEnum.FILETYPE, interactivePromptingValueProvider);
                }
                this.doPrompt((ConfiguredValue<String>)defaultsFileConfig, INIT_DEFAULTS_FILE_ARG, commandScope, DynamicRuleParameterEnum.DEFAULTS_FILENAME, interactivePromptingValueProvider);
                defaultsFileConfig = commandScope.getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
                skippedDefaultsFileCreation = this.isSkipped((ConfiguredValue<String>)defaultsFileConfig);
                if (skippedDefaultsFileCreation) {
                    message2 = "No defaults file will be created. Specify a valid defaults file on the CLI, via Environment variable, or pass all required properties on the CLI, via Environment variables. ";
                    Scope.getCurrentScope().getUI().sendMessage(InitProjectCommandStep.addGettingStarted(message2));
                } else {
                    this.doPrompt((ConfiguredValue<String>)urlConfig, URL_ARG, commandScope, DynamicRuleParameterEnum.JDBC_URL, interactivePromptingValueProvider);
                    this.doPrompt((ConfiguredValue<String>)usernameConfig, USERNAME_ARG, commandScope, DynamicRuleParameterEnum.USERNAME, interactivePromptingValueProvider);
                    this.doPrompt((ConfiguredValue<String>)passwordConfig, PASSWORD_ARG, commandScope, DynamicRuleParameterEnum.PASSWORD, interactivePromptingValueProvider);
                }
                formatConfig = commandScope.getConfiguredValue(INIT_FORMAT_ARG);
                urlConfig = commandScope.getConfiguredValue(URL_ARG);
                usernameConfig = commandScope.getConfiguredValue(USERNAME_ARG);
                passwordConfig = commandScope.getConfiguredValue(PASSWORD_ARG);
                if (!skippedChangelogFileCreation || !skippedDefaultsFileCreation) {
                    message2 = String.format("Setting up new Liquibase project in '%s'...", InitProjectCommandStep.fullPathToProjectDir(projectCopier, (ConfiguredValue<String>)projectDirConfig));
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(message2);
                    Scope.getCurrentScope().getUI().sendMessage(message2);
                }
            } else if (response.toLowerCase().startsWith("y")) {
                message = String.format("Setting up new Liquibase project in '%s'...", InitProjectCommandStep.fullPathToProjectDir(projectCopier, (ConfiguredValue<String>)projectDirConfig));
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(message);
                Scope.getCurrentScope().getUI().sendMessage(message);
            } else if (response.toLowerCase().startsWith("n")) {
                String message3 = "No files created. Set 'liquibase.command.init.project.projectGuide=off' in your defaults file or set LIQUIBASE_COMMAND_INIT_PROJECT_PROJECT_GUIDE=off as an environment variable to not be asked again. Getting Started and project setup available anytime, run \"liquibase init project --help\" for information.";
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(message3);
                Scope.getCurrentScope().getUI().sendMessage(message3);
                return;
            }
        }
        File projectDirFile = projectCopier.createWorkingStorage(projectDir, (Boolean)commandScope.getConfiguredValue(INIT_PROJECT_KEEP_TEMP_FILES_ARG).getValue());
        InitProjectUtil.validateProjectDirectory(projectDirFile);
        InitProjectUtil.createProjectDirectory(projectDirFile);
        if (!skippedChangelogFileCreation || !skippedDefaultsFileCreation) {
            InitProjectUtil.FileCreationResultEnum changelogFileCreationResult = InitProjectUtil.FileCreationResultEnum.skipped_changelog_step;
            String format = null;
            if (!skippedChangelogFileCreation) {
                String changelogFilePath = (String)changelogFileConfig.getValue();
                InitProjectUtil.validateChangelogFilePath(changelogFilePath);
                if (formatConfig.wasDefaultValueUsed() && (format = InitProjectUtil.determineFormatType(changelogFilePath, (String)formatConfig.getValue())) == null) {
                    String message4 = "Unable to determine format for the changelog file '" + changelogFilePath + "'";
                    throw new CommandExecutionException(message4);
                }
                if (format == null) {
                    format = (String)commandScope.getConfiguredValue(INIT_FORMAT_ARG).getValue();
                }
                if (!changelogFilePath.contains("." + format)) {
                    changelogFilePath = changelogFilePath + "." + format;
                }
                changelogFileCreationResult = InitProjectUtil.copyExampleChangelog(format, projectDirFile, changelogFilePath, (ConfiguredValue<String>)changelogFileConfig);
                if (projectDir.endsWith("/")) {
                    resultsBuilder.addResult(INIT_CHANGELOG_FILE_ARG.getName(), (Object)(projectDir + changelogFilePath));
                } else {
                    resultsBuilder.addResult(INIT_CHANGELOG_FILE_ARG.getName(), (Object)(projectDir + "/" + changelogFilePath));
                }
            }
            boolean usedH2 = this.createDefaultsFile(resultsBuilder, (ConfiguredValue<String>)defaultsFileConfig, (ConfiguredValue<String>)changelogFileConfig, (ConfiguredValue<String>)urlConfig, (ConfiguredValue<String>)usernameConfig, (ConfiguredValue<String>)passwordConfig, skippedDefaultsFileCreation, projectDir, projectCopier, projectDirFile, changelogFileCreationResult, format);
            if (((Boolean)commandScope.getArgumentValue(COPY_EXAMPLE_FLOW_FILES)).booleanValue()) {
                InitProjectUtil.copyExampleFlowFiles(format, projectDirFile);
            }
            if (((Boolean)commandScope.getArgumentValue(COPY_EXAMPLE_CHECKS_PACKAGE_FILE)).booleanValue()) {
                InitProjectUtil.copyChecksPackageFile(format, projectDirFile);
            }
            Scope.getCurrentScope().getUI().sendMessage("");
            resultsBuilder.addResult(USED_H2_KEY, (Object)usedH2);
            InitProjectCommandStep.outputEndInstructions(projectDirConfig.wasDefaultValueUsed(), (ConfiguredValue<String>)defaultsFileConfig, projectDir, usedH2);
        } else {
            message = InitProjectCommandStep.addGettingStarted(" ");
            Scope.getCurrentScope().getLog(InitProjectCommandStep.class).info(message);
            Scope.getCurrentScope().getUI().sendMessage(message);
        }
        this.runInitCopyCommand(inputProjectDir, projectDir, projectCopier, projectDirFile);
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    private boolean shouldPrompt(ConfiguredValue<String> defaultsFileConfig, ConfiguredValue<String> formatConfig, ConfiguredValue<String> changelogFileConfig, ConfiguredValue<String> projectDirConfig, ConfiguredValue<String> urlConfig, ConfiguredValue<String> usernameConfig, ConfiguredValue<String> passwordConfig, String projectGuide) {
        return this.isProjectGuideOn(projectGuide) && (projectDirConfig.wasDefaultValueUsed() || changelogFileConfig.wasDefaultValueUsed() || formatConfig.wasDefaultValueUsed() || defaultsFileConfig.wasDefaultValueUsed() || urlConfig.wasDefaultValueUsed() || usernameConfig.wasDefaultValueUsed() || passwordConfig.wasDefaultValueUsed());
    }

    private void checkForS3Jar(ProjectCopier projectCopier) {
        if (projectCopier == null) {
            throw new UnexpectedLiquibaseException("The AWS S3 extension JAR is not available on the classpath");
        }
    }

    private void runInitCopyCommand(String inputProjectDir, String projectDir, ProjectCopier projectCopier, File projectDirFile) throws CommandExecutionException {
        if (projectCopier.isRemote()) {
            CommandScope copyCommand = new CommandScope(new String[]{"init", "copy"});
            copyCommand.addArgumentValue(InitCopyCommandStep.INIT_COPY_SOURCE_DIR_ARG, (Object)projectDirFile.getAbsolutePath());
            if (!projectDir.equals(inputProjectDir)) {
                copyCommand.addArgumentValue(InitCopyCommandStep.INIT_COPY_TARGET_DIR_ARG, (Object)projectDir);
            } else {
                copyCommand.addArgumentValue(InitCopyCommandStep.INIT_COPY_TARGET_DIR_ARG, (Object)inputProjectDir);
            }
            copyCommand.addArgumentValue(InitCopyCommandStep.INIT_COPY_PROJECT_COPIER_ARG, (Object)projectCopier);
            copyCommand.execute();
        }
    }

    private boolean createDefaultsFile(CommandResultsBuilder resultsBuilder, ConfiguredValue<String> defaultsFileConfig, ConfiguredValue<String> changelogFileConfig, ConfiguredValue<String> urlConfig, ConfiguredValue<String> usernameConfig, ConfiguredValue<String> passwordConfig, boolean skippedDefaultsFileCreation, String projectDir, ProjectCopier projectCopier, File projectDirFile, InitProjectUtil.FileCreationResultEnum changelogFileCreationResult, String format) throws CommandExecutionException, IOException {
        if (!skippedDefaultsFileCreation) {
            boolean newDefaultsFile = false;
            File defaultsFile = new File(projectDirFile, (String)defaultsFileConfig.getValue());
            if (!defaultsFile.exists()) {
                if (changelogFileCreationResult == InitProjectUtil.FileCreationResultEnum.skipped_changelog_step || changelogFileCreationResult == InitProjectUtil.FileCreationResultEnum.already_existed) {
                    Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator());
                }
                defaultsFile = projectCopier.isRemote() ? InitProjectUtil.copyExampleProperties(format, projectDirFile.getAbsolutePath(), (String)defaultsFileConfig.getValue()) : InitProjectUtil.copyExampleProperties(format, projectDir, (String)defaultsFileConfig.getValue());
                newDefaultsFile = true;
            }
            Boolean shouldBackupDefaultsFile = (Boolean)Scope.getCurrentScope().get(SHOULD_BACKUP_DEFAULTS_FILE_ARG, Boolean.class);
            InitProjectUtil.updateDefaultsFile(defaultsFile, newDefaultsFile, format, changelogFileConfig, urlConfig, usernameConfig, passwordConfig, changelogFileCreationResult, shouldBackupDefaultsFile, resultsBuilder);
            resultsBuilder.addResult(INIT_DEFAULTS_FILE_ARG.getName(), (Object)defaultsFile);
            return InitProjectUtil.wasH2Used(urlConfig, usernameConfig, passwordConfig);
        }
        return false;
    }

    public static void outputEndInstructions(boolean wasDefaultProjectDirValueUsed, ConfiguredValue<String> defaultsFileConfig, String projectDir, boolean usedH2) {
        String message = "To use the new project files";
        if (!wasDefaultProjectDirValueUsed) {
            message = message + String.format(", please cd into '%s',", projectDir);
        }
        message = message + " make sure your database is active and accessible";
        String updateCommand = "liquibase update" + (defaultsFileConfig.wasDefaultValueUsed() || ((String)defaultsFileConfig.getValue()).equals(INIT_DEFAULTS_FILE_ARG.getDefaultValue()) ? "" : " --defaults-file=" + (String)defaultsFileConfig.getValue());
        message = usedH2 ? message + " by opening a new terminal window to run \"liquibase init start-h2\", and then return to this terminal window to run \"" + updateCommand + "\" command." : message + " and run \"" + updateCommand + "\".";
        message = InitProjectCommandStep.addGettingStarted(message);
        Scope.getCurrentScope().getLog(InitProjectCommandStep.class).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
    }

    private static String fullPathToProjectDir(ProjectCopier projectCopier, ConfiguredValue<String> projectDirConfig) {
        if (projectCopier.isRemote()) {
            return (String)projectDirConfig.getValue();
        }
        return new File((String)projectDirConfig.getValue()).getAbsolutePath();
    }

    private static String addGettingStarted(String message) {
        message = message + "\nFor more details, visit the Getting Started Guide at https://docs.liquibase.com/start/home.html";
        return message;
    }

    private boolean isSkipped(ConfiguredValue<String> promptedValue) {
        return ((String)promptedValue.getValue()).equalsIgnoreCase("s");
    }

    private String findLatestChangelogFilename(ConfiguredValue<String> projectDirConfig) {
        try {
            File[] changeLogsInProjectDir = InitProjectUtil.findChangeLogsInProjectDir(new File((String)projectDirConfig.getValue()));
            if (changeLogsInProjectDir != null && changeLogsInProjectDir.length > 0) {
                Arrays.sort(changeLogsInProjectDir, (c1, c2) -> Long.compare(c2.lastModified(), c1.lastModified()));
                return changeLogsInProjectDir[0].getName();
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Failed to find an existing changelog file in the specified project directory, using default instead", (Throwable)e);
        }
        return null;
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Creates the directory and files needed to run Liquibase commands. Run without any flags on the CLI, or set via Environment variable, etc. will launch an interactive guide to walk users through setting up the necessary project's default and changelog files. This guide can be turned off by setting the 'liquibase.command.init.project.projectGuide=off'");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
        commandDefinition.addAlias(ALIAS);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        INIT_PROJECT_DIR_ARG = builder.argument("projectDir", String.class).description("Relative or fully qualified path to the directory where the project files will be created").defaultValue((Object)((String)DynamicRuleParameterEnum.PROJECT_DIR.defaultValue)).build();
        INIT_FORMAT_ARG = builder.argument("format", String.class).description("Format of the project changelog sql|xml|json|yaml|yml").defaultValue((Object)DynamicRuleParameterEnum.FILETYPE.defaultValue.toString()).build();
        INIT_DEFAULTS_FILE_ARG = builder.argument("projectDefaultsFile", String.class).description(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDescription()).defaultValue(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDefaultValue()).build();
        INIT_PROJECT_GUIDE_ARG = builder.argument("projectGuide", String.class).description("Allow interactive prompts for init project").defaultValue((Object)"on").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String projectGuideString = String.valueOf(input);
            if (!projectGuideString.equalsIgnoreCase("on") && !projectGuideString.equalsIgnoreCase("off")) {
                String messageString = "\nWARNING: The projectGuide parameter must be set to either 'on' or 'off'.  (Blank defaults to 'on')";
                throw new IllegalArgumentException(messageString);
            }
            return projectGuideString;
        }).build();
        INIT_PROJECT_RECURSIVE_ARG = builder.argument("recursive", Boolean.class).description("For remote project locations, recursive copy all project files to the remote location").defaultValue((Object)false).hidden().build();
        INIT_PROJECT_KEEP_TEMP_FILES_ARG = builder.argument("keepTempFiles", Boolean.class).description("For remote project locations, do not delete temporary project files").defaultValue((Object)false).build();
        INIT_CHANGELOG_FILE_ARG = builder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to the changelog file").defaultValue((Object)((String)DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME.defaultValue)).build();
        URL_ARG = builder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL").defaultValue((Object)((String)DynamicRuleParameterEnum.JDBC_URL.defaultValue)).build();
        USERNAME_ARG = builder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").defaultValue((Object)((String)DynamicRuleParameterEnum.USERNAME.defaultValue)).build();
        PASSWORD_ARG = builder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").defaultValue((Object)((String)DynamicRuleParameterEnum.PASSWORD.defaultValue)).setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        COPY_EXAMPLE_FLOW_FILES = builder.argument("copyExampleFlowFiles", Boolean.class).defaultValue((Object)true).hidden().build();
        COPY_EXAMPLE_CHECKS_PACKAGE_FILE = builder.argument("copyExampleChecksPackageFile", Boolean.class).defaultValue((Object)true).hidden().build();
    }

    public static enum FileTypeEnum {
        sql,
        xml,
        json,
        yml,
        yaml;

    }
}

