/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.config.LiquibaseFlowConfiguration;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import com.datical.liquibase.ext.flow.provider.AbstractFlowGlobalArgsValueProvider;
import com.datical.liquibase.ext.flow.provider.ActionDefaultsFileValueProvider;
import com.datical.liquibase.ext.flow.provider.ActionGlobalArgsValueProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.StartH2CommandStep;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.ProvidedValue;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.LogUtil;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class LiquibaseCommandAction
extends Action {
    private String command;
    private static final String CMD_ARGS = "cmdArgs";
    private static final String GLOBAL_ARGS = "globalArgs";
    private Map<String, Object> cmdArgs = new HashMap<String, Object>();
    private Map<String, Object> globalArgs = new HashMap<String, Object>();
    private Map<String, Object> parentVariables = new HashMap<String, Object>();
    private static final Set<String[]> forbiddenCommandNames = Collections.singleton(StartH2CommandStep.COMMAND_NAME);
    public static final Map<String, OutputStream> OPENED_OUTPUT_STREAMS = new HashMap<String, OutputStream>();
    private static final String[] forbiddenGlobalArgs = new String[]{"CLASSPATH", "SEARCHPATH", "PROMPT_FOR_NON_LOCAL_DATABASE", "INCLUDE_SYSTEM_CLASSPATH", "LOG_LEVEL", "LOG_CHANNELS", "LOG_FILE", "SHOULD_RUN", "ARGUMENT_CONVERTER", "MONITOR_PERFORMANCE", "SHOW_BANNER"};

    @Override
    public String getType() {
        return "liquibase";
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Map<String, Object> getCmdArgs() {
        return this.cmdArgs;
    }

    public void setCmdArgs(Map<String, Object> cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    public Map<String, Object> getGlobalArgs() {
        return this.globalArgs;
    }

    public void setGlobalArgs(Map<String, Object> globalArgs) {
        this.globalArgs = globalArgs;
    }

    public Map<String, Object> getParentVariables() {
        return this.parentVariables;
    }

    public void setParentVariables(Map<String, Object> parentVariables) {
        this.parentVariables = FlowVariableExpander.expandVariables(parentVariables, parentVariables);
    }

    @Override
    public Action fromAction(Map<String, Object> actionMap, Map<String, Object> variables) {
        LiquibaseCommandAction liquibaseCommandAction = new LiquibaseCommandAction();
        liquibaseCommandAction.setCommand((String)actionMap.get("command"));
        liquibaseCommandAction.setCmdArgs(FlowVariableExpander.expandVariables((Map)actionMap.get(CMD_ARGS), variables));
        Map<String, Object> expandedUserMetadata = FlowVariableExpander.expandVariables((Map)actionMap.get("userMetadata"), variables);
        this.addUserMetadata(expandedUserMetadata, liquibaseCommandAction);
        Map<String, Object> expandedVariables = FlowVariableExpander.expandVariables((Map)actionMap.get(GLOBAL_ARGS), variables);
        expandedVariables = FlowVariableExpander.execShellCommandsToExpand(expandedVariables);
        liquibaseCommandAction.setGlobalArgs(expandedVariables);
        liquibaseCommandAction.setParentVariables(variables);
        return liquibaseCommandAction;
    }

    @Override
    public void execute(CommandResultsBuilder resultsBuilder) throws CommandExecutionException {
        Scope.getCurrentScope().getLog(LiquibaseCommandAction.class).info("Executing command '" + this.command + "'");
        CommandScope actionCommandScope = this.createActionCommandScope(resultsBuilder);
        LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        Level originalLogLevel = liquibaseLogger.getLevel();
        ActionGlobalArgsValueProvider flowValueProvider = new ActionGlobalArgsValueProvider(this.globalArgs);
        ActionDefaultsFileValueProvider actionDefaultsFileValueProvider = this.getActionDefaultsFileValueProvider(flowValueProvider);
        try {
            liquibaseConfiguration.registerProvider((ConfigurationValueProvider)flowValueProvider);
            if (actionDefaultsFileValueProvider != null) {
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)actionDefaultsFileValueProvider);
            }
            this.handleOutputStream(resultsBuilder, actionCommandScope);
            HashMap<String, Map<String, Object>> scopedValues = new HashMap<String, Map<String, Object>>();
            scopedValues.put("flowFileInheritedVariables", this.getParentVariables());
            Scope.child(scopedValues, () -> {
                CommandResults results = actionCommandScope.execute();
                if (resultsBuilder != null && results.getResult("statusCode") != null) {
                    resultsBuilder.addResult("statusCode:" + this.getCommand().toLowerCase(), results.getResult("statusCode"));
                }
            });
            String commandName = StringUtil.join((String[])actionCommandScope.getCommand().getName(), (String)" ");
            Scope.getCurrentScope().getUI().sendMessage("Liquibase command '" + commandName + "' was executed successfully.");
        }
        catch (Exception e) {
            throw new CommandExecutionException((Throwable)e);
        }
        finally {
            flowValueProvider.removeHandler();
            liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)flowValueProvider);
            if (actionDefaultsFileValueProvider != null) {
                liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)actionDefaultsFileValueProvider);
            }
            liquibaseLogger.setLevel(originalLogLevel);
            LogUtil.setPersistedMdcKeysToEmptyString();
        }
    }

    private ActionDefaultsFileValueProvider getActionDefaultsFileValueProvider(ActionGlobalArgsValueProvider flowValueProvider) throws CommandExecutionException {
        ProvidedValue defaultsFileProvidedValue = flowValueProvider.getProvidedValue(new String[]{LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getKey()});
        if (defaultsFileProvidedValue == null) {
            return null;
        }
        Object defaultsFile = defaultsFileProvidedValue.getValue();
        try {
            if (defaultsFile != null) {
                PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
                Resource resource = pathHandlerFactory.getResource((String)defaultsFile);
                return new ActionDefaultsFileValueProvider(resource.openInputStream(), "Defaults file specified in flow file");
            }
        }
        catch (IOException e) {
            throw new CommandExecutionException((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(String flowFileArg) throws CommandExecutionException {
        LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        ActionDefaultsFileValueProvider actionDefaultsFileValueProvider = null;
        ActionGlobalArgsValueProvider flowValueProvider = null;
        try {
            if (StringUtil.isEmpty((String)this.getCommand())) {
                throw new CommandValidationException("Command cannot be empty.");
            }
            StringBuilder builder = new StringBuilder();
            if (this.globalArgs != null) {
                this.checkForForbiddenGlobals(builder);
                flowValueProvider = new ActionGlobalArgsValueProvider(this.globalArgs);
                actionDefaultsFileValueProvider = this.getActionDefaultsFileValueProvider(flowValueProvider);
                if (actionDefaultsFileValueProvider != null) {
                    liquibaseConfiguration.registerProvider((ConfigurationValueProvider)actionDefaultsFileValueProvider);
                }
            }
            if (this.cmdArgs != null) {
                this.checkForUnexpandedVariables(this.cmdArgs, "command", builder);
            }
            if (this.globalArgs != null) {
                this.checkForUnexpandedVariables(this.globalArgs, "global", builder);
            }
            if (builder.length() > 0) {
                throw new CommandValidationException(builder.toString());
            }
            CommandScope commandScope = this.createActionCommandScope(null);
            this.checkForForbiddenCommand(commandScope);
            this.checkForCircularReference(flowFileArg, commandScope);
            HashMap<String, Map<String, Object>> scopedValues = new HashMap<String, Map<String, Object>>();
            scopedValues.put("flowFileInheritedVariables", this.getParentVariables());
            try {
                Scope.child(scopedValues, () -> ((CommandScope)commandScope).validate());
            }
            catch (Exception e) {
                throw new CommandValidationException(e.getMessage(), (Throwable)e);
            }
            if (flowValueProvider != null) {
                flowValueProvider.removeHandler();
            }
            if (actionDefaultsFileValueProvider == null) return;
        }
        catch (Throwable throwable) {
            if (flowValueProvider != null) {
                flowValueProvider.removeHandler();
            }
            if (actionDefaultsFileValueProvider == null) throw throwable;
            liquibaseConfiguration.unregisterProvider(actionDefaultsFileValueProvider);
            throw throwable;
        }
        liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)actionDefaultsFileValueProvider);
    }

    private void checkForCircularReference(String flowFileArg, CommandScope commandScope) throws CommandValidationException {
        String actionFlowFileArg;
        if (flowFileArg == null) {
            return;
        }
        if (Arrays.equals(commandScope.getCommand().getName(), FlowCommandStep.COMMAND_NAME) && flowFileArg.equals(actionFlowFileArg = (String)commandScope.getArgumentValue(FlowCommandStep.FLOW_FILE))) {
            throw new CommandValidationException("Circular references between flow files are not allowed.");
        }
    }

    private void checkForForbiddenCommand(CommandScope commandScope) throws CommandValidationException {
        CommandDefinition forbiddenCommand = commandScope.getCommand();
        if (forbiddenCommandNames.contains(forbiddenCommand.getName())) {
            throw new CommandValidationException("Command " + StringUtil.join((String[])forbiddenCommand.getName(), (String)" ") + " is not allowed in flow files.");
        }
    }

    public String toString() {
        if (((Boolean)LiquibaseFlowConfiguration.FLOW_VERBOSE_TO_STRING.getCurrentValue()).booleanValue()) {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
        return String.format("'%s' %s", this.getType(), this.command);
    }

    private void handleOutputStream(CommandResultsBuilder resultsBuilder, CommandScope actionCommandScope) {
        OutputStream outputStream = this.getOutputStream(resultsBuilder);
        if (outputStream != null) {
            actionCommandScope.setOutput(outputStream);
        } else if (resultsBuilder != null) {
            actionCommandScope.setOutput(resultsBuilder.getOutputStream());
        }
    }

    private void checkForUnexpandedVariables(Map<String, Object> args, String type, StringBuilder builder) {
        HashMap<String, String> unexpandedVariables = new HashMap<String, String>();
        args.forEach((k, v) -> {
            String value = String.valueOf(v);
            if (value.contains("${") && value.contains("}")) {
                unexpandedVariables.put((String)k, value);
            }
        });
        if (!unexpandedVariables.isEmpty()) {
            builder.append(System.lineSeparator());
            builder.append(String.format("The following %s arguments for the command '%s' were not resolved:%n", type, this.getCommand()));
            unexpandedVariables.forEach((k, v) -> builder.append(String.format("    %s : %s%n", k, v)));
        }
    }

    private void checkForForbiddenGlobals(StringBuilder builder) {
        ArrayList allThatMatched = new ArrayList();
        this.globalArgs.forEach((k, v) -> {
            List matched = Arrays.stream(forbiddenGlobalArgs).filter(forbidden -> forbidden.equalsIgnoreCase((String)k)).collect(Collectors.toList());
            allThatMatched.addAll(matched);
        });
        if (!allThatMatched.isEmpty()) {
            Scope.getCurrentScope().getUI().sendMessage("");
            String message = String.format("The following global arguments cannot be set within the flow file.%nThey must be set in the flow command, such as 'liquibase --the-global-arg=<somevalue> flow'.", new Object[0]);
            builder.append(System.lineSeparator());
            builder.append(message);
            builder.append(System.lineSeparator());
            for (String s : allThatMatched) {
                builder.append(String.format("    %s%n", s));
            }
        }
    }

    private OutputStream getOutputStream(CommandResultsBuilder resultsBuilder) {
        ConfiguredValue currentConfiguredValue = LiquibaseCommandLineConfiguration.OUTPUT_FILE.getCurrentConfiguredValue();
        ProvidedValue providedValue = currentConfiguredValue.getProvidedValue();
        if (providedValue.getProvider() instanceof AbstractFlowGlobalArgsValueProvider) {
            OutputStream outputStream;
            block5: {
                String outputFile = String.valueOf(providedValue.getValue());
                outputStream = null;
                try {
                    if (outputFile == null) break block5;
                    OutputStream cachedOutputStream = OPENED_OUTPUT_STREAMS.get(outputFile);
                    if (cachedOutputStream == null) {
                        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
                        outputStream = pathHandlerFactory.openResourceOutputStream(outputFile, new OpenOptions().setCreateIfNeeded(true));
                        OPENED_OUTPUT_STREAMS.put(outputFile, outputStream);
                        break block5;
                    }
                    return cachedOutputStream;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return outputStream;
        }
        if (resultsBuilder != null) {
            return resultsBuilder.getOutputStream();
        }
        return null;
    }

    private CommandScope createActionCommandScope(CommandResultsBuilder resultsBuilder) throws CommandExecutionException {
        String[] commandName = LiquibaseCommandAction.getActualCommandName(this.getCommand());
        CommandScope actionCommandScope = new CommandScope(commandName);
        if (this.cmdArgs != null) {
            for (Map.Entry<String, Object> entry : this.cmdArgs.entrySet()) {
                String argValue = this.getArgValue(actionCommandScope, entry);
                if (!StringUtil.isNotEmpty((String)argValue) || argValue.equals("null")) continue;
                actionCommandScope.addArgumentValue(entry.getKey(), (Object)argValue);
            }
        }
        if (resultsBuilder != null) {
            actionCommandScope.setOutput(resultsBuilder.getOutputStream());
        }
        return actionCommandScope;
    }

    public static String[] getActualCommandName(String command) throws CommandExecutionException {
        CommandFactory commandFactory = (CommandFactory)Scope.getCurrentScope().getSingleton(CommandFactory.class);
        Object[] pipelineName = StringUtil.toCamelCase((String)command).split(" ");
        SortedSet commands = commandFactory.getCommands(false);
        List actualDef = commands.stream().filter(arg_0 -> LiquibaseCommandAction.lambda$getActualCommandName$5((String[])pipelineName, arg_0)).collect(Collectors.toList());
        if (actualDef.isEmpty()) {
            throw new CommandExecutionException("Unable to locate command " + Arrays.toString(pipelineName));
        }
        return ((CommandDefinition)actualDef.get(0)).getName();
    }

    private String getArgValue(CommandScope actionCommandScope, Map.Entry<String, Object> entry) throws CommandExecutionException {
        String argValue = (String)ObjectUtil.convert((Object)entry.getValue(), String.class);
        if (argValue.startsWith("`") && argValue.endsWith("`")) {
            AtomicReference<String> reference = new AtomicReference<String>(argValue);
            HashMap<String, Object> scopedValues = new HashMap<String, Object>();
            scopedValues.put(FlowCommandStep.FLOW_SHELL_INTERPRETER.getName(), actionCommandScope.getArgumentValue(FlowCommandStep.FLOW_SHELL_INTERPRETER));
            try {
                Scope.child(scopedValues, () -> reference.set(FlowVariableExpander.shellExec(((String)reference.get()).replace("`", ""))));
            }
            catch (Exception e) {
                throw new CommandExecutionException((Throwable)e);
            }
            argValue = reference.get();
        }
        return argValue;
    }

    private static /* synthetic */ boolean lambda$getActualCommandName$5(String[] pipelineName, CommandDefinition commandDefinition) {
        String[] commandDefNames = commandDefinition.getName();
        boolean allNamePartsMatch = true;
        for (int i = 0; i < commandDefNames.length; ++i) {
            String commandDefName = commandDefNames[i];
            if (pipelineName.length > i) {
                if (!allNamePartsMatch) continue;
                allNamePartsMatch = commandDefName.equalsIgnoreCase(pipelineName[i]);
                continue;
            }
            allNamePartsMatch = false;
        }
        return allNamePartsMatch;
    }
}

