/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.repackaged.com.github.mustachejava.Mustache;
import liquibase.repackaged.com.github.mustachejava.SafeMustacheFactory;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.util.StreamUtil;

public abstract class AbstractReport {
    private final String name;
    private final String path;

    protected AbstractReport(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void generateReport() throws LiquibaseException {
        try {
            this.writeFileContents(this.getReportString());
        }
        catch (Exception e) {
            throw new LiquibaseException("Could not generate report!", (Throwable)e);
        }
    }

    public void writeFileContents(String contents) throws IOException {
        String maybeRelativePath = this.getPathWithSuffix();
        boolean resourceCreated = !ResourceUtil.getResource(maybeRelativePath).exists();
        try (OutputStream outputStream = this.createResourceIfNeeded(maybeRelativePath);){
            outputStream.write(contents.getBytes((String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
        }
        String fullyQualifiedPath = ProStringUtil.stripUriPrefix(ResourceUtil.getResource(maybeRelativePath).getUri());
        String message = resourceCreated ? String.format("Report file '%s' was created", fullyQualifiedPath) : String.format("Report file '%s' was updated", fullyQualifiedPath);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
    }

    private OutputStream createResourceIfNeeded(String path) throws IOException {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        return pathHandlerFactory.openResourceOutputStream(path, new OpenOptions().setTruncate(true).setCreateIfNeeded(true));
    }

    public String getPathWithSuffix() {
        String reportPath = this.getPath();
        if (reportPath.endsWith("/")) {
            reportPath = reportPath.substring(0, reportPath.length() - 1);
        }
        if (reportPath.toLowerCase().endsWith(".html")) {
            return reportPath;
        }
        String fullPath = this.getName().toLowerCase().endsWith(".html") ? String.format("%s/%s", reportPath, this.getName()) : String.format("%s/%s.%s", reportPath, this.getName(), "html");
        return fullPath;
    }

    public String getReportString() throws IOException {
        HashSet<String> allowedTemplates = new HashSet<String>();
        allowedTemplates.add(this.getTemplateName());
        SafeMustacheFactory mf = new SafeMustacheFactory(allowedTemplates, this.getTemplateResourceRoot());
        Mustache mustache = mf.compile(this.getTemplateName());
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, this.getReportParameters()).flush();
        if (stringWriter.toString() != null) {
            return this.replacePlaceholders(stringWriter.toString());
        }
        return null;
    }

    private String replacePlaceholders(String html) {
        String sharedDriftUpdateStylingPlaceholder = "/* custom styling placeholder 6dd1d8be-a0e8-4074-977f-cea8a2497156 */";
        String sharedDriftUpdateScriptPlaceholder = "// custom script placeholder 55394330-f5e0-40b3-a840-8862c7e1683b";
        String sharedHeaderImage = "<!-- header image placeholder 9288b8b9-dc31-4cdc-a806-330e1a147637 -->";
        if (html.contains("/* custom styling placeholder 6dd1d8be-a0e8-4074-977f-cea8a2497156 */")) {
            html = this.replacePlaceholder(html, "/* custom styling placeholder 6dd1d8be-a0e8-4074-977f-cea8a2497156 */", "liquibase/html/shared-drift-update-styling.css");
        }
        if (html.contains("// custom script placeholder 55394330-f5e0-40b3-a840-8862c7e1683b")) {
            html = this.replacePlaceholder(html, "// custom script placeholder 55394330-f5e0-40b3-a840-8862c7e1683b", "liquibase/html/shared-drift-update-script.js");
        }
        if (html.contains("<!-- header image placeholder 9288b8b9-dc31-4cdc-a806-330e1a147637 -->")) {
            html = this.replacePlaceholder(html, "<!-- header image placeholder 9288b8b9-dc31-4cdc-a806-330e1a147637 -->", "liquibase/html/liquibase-header-img-snippet.html");
        }
        return html;
    }

    private String replacePlaceholder(String html, String placeholderText, String replacementFilepath) {
        try {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream footerStream = classloader.getResourceAsStream(replacementFilepath);
            html = html.replace(placeholderText, StreamUtil.readStreamAsString((InputStream)footerStream, (String)StandardCharsets.UTF_8.toString()));
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to load " + replacementFilepath + " for the generated report.", (Throwable)e);
        }
        return html;
    }

    protected abstract Object getReportParameters();

    protected abstract String getTemplateName();

    protected abstract String getTemplateResourceRoot();

    public abstract String getReportTypeName();
}

