/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.annotation.Rule;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.LiquibaseRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.license.pro.LicenseTier;
import liquibase.logging.Logger;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

@Rule
public abstract class AbstractLiquibaseRule
implements LiquibaseRule {
    private final UUID id = UUID.nameUUIDFromBytes(StringUtil.getBytesWithEncoding((String)this.getClass().getName()));
    private static final ConcurrentHashMap<AbstractSQLChange, String> sqlContentsCache = new ConcurrentHashMap();
    private final Map<ChangeSet, LiquibaseRuleResult> results = new LinkedHashMap<ChangeSet, LiquibaseRuleResult>();
    private final Map<DatabaseObject, LiquibaseRuleResult> databaseResults = new LinkedHashMap<DatabaseObject, LiquibaseRuleResult>();
    public static final int MAX_SHORT_NAME_LENGTH = 64;

    @Override
    public final UUID getId() {
        return this.id;
    }

    @Override
    public SeverityEnum getSeverity() {
        return SeverityEnum.INFO;
    }

    @Override
    public Map<ChangeSet, LiquibaseRuleResult> getResults() {
        return this.results;
    }

    @Override
    public Map<DatabaseObject, LiquibaseRuleResult> getDatabaseResults() {
        return this.databaseResults;
    }

    private boolean putResult(ChangeSet changeSet, LiquibaseRuleResult result) {
        Objects.requireNonNull(result);
        this.results.put(changeSet, result);
        return !this.results.get(changeSet).hasRuleSucceeded();
    }

    private boolean putResult(DatabaseObject databaseObject, LiquibaseRuleResult result) {
        Objects.requireNonNull(result);
        this.databaseResults.put(databaseObject, result);
        return !this.databaseResults.get(databaseObject).hasRuleSucceeded();
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        if (this.getScope().contains((Object)ScopeEnum.DATABASE) && this.getScope().size() == 1) {
            return Collections.emptyList();
        }
        return SupportedChangesetFormats.ALL;
    }

    public boolean putResultSuccessful(ChangeSet changeSet, boolean didRuleExecute, AbstractConfigurableRule configuredRule) {
        return this.putResultSuccessful(changeSet, didRuleExecute, configuredRule, false);
    }

    public boolean putResultSuccessful(ChangeSet changeSet, boolean didRuleExecute, AbstractConfigurableRule configuredRule, boolean isRollback) {
        if (didRuleExecute) {
            List<RuleIteration> ruleIterations = this.results.containsKey(changeSet) ? this.results.get(changeSet).getExecutions() : null;
            RuleIteration originalRuleIteration = ruleIterations != null && !ruleIterations.isEmpty() ? this.results.get(changeSet).getExecutions().get(0) : null;
            RuleIteration ruleIteration = AbstractLiquibaseRule.createRuleIteration(originalRuleIteration, isRollback);
            return this.putResult(changeSet, new LiquibaseRuleResult(this, configuredRule, ruleIteration));
        }
        return this.putResult(changeSet, new LiquibaseRuleResult(this));
    }

    public boolean putResultSuccessful(DatabaseObject databaseObject, boolean didRuleExecute, AbstractConfigurableRule configuredRule) {
        if (didRuleExecute) {
            List<RuleIteration> ruleIterations = this.databaseResults.containsKey(databaseObject) ? this.databaseResults.get(databaseObject).getExecutions() : null;
            RuleIteration originalRuleIteration = ruleIterations != null && !ruleIterations.isEmpty() ? this.databaseResults.get(databaseObject).getExecutions().get(0) : null;
            RuleIteration ruleIteration = AbstractLiquibaseRule.createRuleIteration(originalRuleIteration, false);
            return this.putResult(databaseObject, new LiquibaseRuleResult(this, configuredRule, ruleIteration));
        }
        return this.putResult(databaseObject, new LiquibaseRuleResult(this));
    }

    private static RuleIteration createRuleIteration(RuleIteration originalRuleIteration, boolean isRollback) {
        RuleIteration ruleIteration = originalRuleIteration != null && originalRuleIteration.getFailureReason() == RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE ? originalRuleIteration : new RuleIteration(true, isRollback);
        return ruleIteration;
    }

    public boolean putResultUnsuccessful(ChangeSet changeSet, String message, boolean isRollback, AbstractConfigurableRule configuredRule) {
        return this.putResultUnsuccessful(changeSet, message, configuredRule, isRollback);
    }

    public boolean putResultUnsuccessful(ChangeSet changeSet, String message, AbstractConfigurableRule configuredRule) {
        return this.putResultUnsuccessful(changeSet, message, configuredRule, false);
    }

    public boolean putResultUnsuccessful(ChangeSet changeSet, String message, AbstractConfigurableRule configuredRule, boolean isRollback) {
        return this.putResult(changeSet, new LiquibaseRuleResult(this, configuredRule, new RuleIteration(false, isRollback, message)));
    }

    public boolean putResultUnsuccessful(DatabaseObject databaseObject, String message, AbstractConfigurableRule configuredRule) {
        return this.putResult(databaseObject, new LiquibaseRuleResult(this, configuredRule, new RuleIteration(false, message)));
    }

    public void addFailureRuleIteration(ChangeSet changeSet, String message, AbstractConfigurableRule configuredRule) {
        this.addFailureRuleIteration(changeSet, message, configuredRule, false);
    }

    public void addFailureRuleIteration(ChangeSet changeSet, String message, AbstractConfigurableRule configuredRule, boolean isRollback) {
        this.addFailureRuleIteration(changeSet, new RuleIteration(false, isRollback, message), configuredRule);
    }

    public void addFailureRuleIteration(ChangeSet changeSet, Map<String, String> checkRuleResults, String message, AbstractConfigurableRule configuredRule, boolean isValidChain, boolean isRollback) {
        this.addFailureRuleIteration(changeSet, new RuleIteration(false, isRollback, checkRuleResults, isValidChain, message), configuredRule);
    }

    public void addFailureRuleIteration(DatabaseObject databaseObject, Map<String, String> checkRuleResults, String message, AbstractConfigurableRule configuredRule, boolean isValidChain) {
        this.addFailureRuleIteration(databaseObject, new RuleIteration(false, false, checkRuleResults, isValidChain, message), configuredRule);
    }

    public void addFailureRuleIteration(DatabaseObject databaseObject, String message, AbstractConfigurableRule configuredRule) {
        this.addFailureRuleIteration(databaseObject, new RuleIteration(false, message), configuredRule);
    }

    public void addFailureRuleIteration(ChangeSet changeSet, String message, RuleIteration.FailureReason failureReason, AbstractConfigurableRule configuredRule) {
        this.addFailureRuleIteration(changeSet, new RuleIteration(failureReason, message), configuredRule);
    }

    public void addFailureRuleIteration(ChangeSet changeSet, String message, RuleIteration.FailureReason failureReason, AbstractConfigurableRule configuredRule, boolean isRollback) {
        this.addFailureRuleIteration(changeSet, new RuleIteration(failureReason, isRollback, message), configuredRule);
    }

    public void addFailureRuleIteration(DatabaseObject databaseObject, String message, RuleIteration.FailureReason failureReason, AbstractConfigurableRule configuredRule) {
        this.addFailureRuleIteration(databaseObject, new RuleIteration(failureReason, message), configuredRule);
    }

    public void addNonApplicableRuleIteration(DatabaseObject databaseObject, String message, RuleIteration.FailureReason failureReason, AbstractConfigurableRule configuredRule) {
        this.addFailureRuleIteration(databaseObject, new RuleIteration(true, failureReason, false, message), configuredRule);
    }

    public void addNonApplicableRuleIteration(ChangeSet changeSet, String message, RuleIteration.FailureReason failureReason, AbstractConfigurableRule configuredRule) {
        this.addFailureRuleIteration(changeSet, new RuleIteration(true, failureReason, false, message), configuredRule);
    }

    private void addFailureRuleIteration(ChangeSet changeSet, RuleIteration ruleIteration, AbstractConfigurableRule configuredRule) {
        if (this.results.containsKey(changeSet)) {
            this.results.get(changeSet).getExecutions().add(ruleIteration);
        } else {
            this.results.put(changeSet, new LiquibaseRuleResult(this, configuredRule, ruleIteration));
        }
    }

    private void addFailureRuleIteration(DatabaseObject databaseObject, RuleIteration ruleIteration, AbstractConfigurableRule configuredRule) {
        if (this.databaseResults.containsKey(databaseObject)) {
            this.databaseResults.get(databaseObject).getExecutions().add(ruleIteration);
        } else {
            this.databaseResults.put(databaseObject, new LiquibaseRuleResult(this, configuredRule, ruleIteration));
        }
    }

    public boolean returnAtEndOfRule(ChangeSet changeSet, AbstractConfigurableRule instance) {
        return this.returnAtEndOfRule(changeSet, instance, false);
    }

    public boolean returnAtEndOfRule(ChangeSet changeSet, AbstractConfigurableRule instance, boolean isRollback) {
        if (this.getResults().isEmpty()) {
            return this.putResultSuccessful(changeSet, true, instance, isRollback);
        }
        if (!this.getResults().containsKey(changeSet)) {
            return this.putResultSuccessful(changeSet, true, instance, isRollback);
        }
        if (this.getResults().get(changeSet).hasRuleSucceeded()) {
            return this.putResultSuccessful(changeSet, true, instance, isRollback);
        }
        return !this.getResults().get(changeSet).hasRuleSucceeded();
    }

    public boolean returnAtEndOfRule(DatabaseObject databaseObject, AbstractConfigurableRule instance) {
        if (this.getDatabaseResults().isEmpty()) {
            return this.putResultSuccessful(databaseObject, true, instance);
        }
        if (!this.getDatabaseResults().containsKey(databaseObject)) {
            return this.putResultSuccessful(databaseObject, true, instance);
        }
        if (this.getDatabaseResults().get(databaseObject).hasRuleSucceeded()) {
            return this.putResultSuccessful(databaseObject, true, instance);
        }
        return !this.getDatabaseResults().get(databaseObject).hasRuleSucceeded();
    }

    @Override
    public String getName() {
        return StringUtil.upperCaseFirst((String)StringUtil.join((String[])StringUtil.splitCamelCase((String)this.getClass().getSimpleName()), (String)" ").toLowerCase());
    }

    public abstract String getShortName();

    public abstract List<RuleParameter<?>> getParameters();

    public String prettyPrintParameters() {
        if (this.isConfigurable()) {
            return StringUtil.join((Collection)this.getParameters().stream().map(p -> p.toString() + " = " + p.getDefaultValue()).collect(Collectors.toList()), (String)System.lineSeparator());
        }
        return "<None>";
    }

    public boolean isConfigurable() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    @Override
    public void execute(Facts facts) throws Exception {
    }

    public String generateErrorMessage(String customErrorMessage) {
        Objects.requireNonNull(customErrorMessage);
        return "Changeset " + customErrorMessage.trim();
    }

    public boolean hasResults(Facts facts) {
        if (facts == null) {
            return false;
        }
        return facts.getFact(FactEnum.RULE_RESULTS.toString()) != null;
    }

    public boolean shouldBeEvaluated(ChangeSet changeSet, AbstractConfigurableRule configurableRule) {
        if (changeSet != null) {
            int modeledCount = 0;
            int unmodeledCount = 0;
            for (Change change : changeSet.getChanges()) {
                if (change instanceof AbstractSQLChange) {
                    ++unmodeledCount;
                    continue;
                }
                ++modeledCount;
            }
            List<String> supportedChangesetFormats = this.getSupportedChangesetFormats();
            boolean failedUnmodeled = false;
            boolean failedModeled = false;
            if (unmodeledCount > 0 && !supportedChangesetFormats.containsAll(SupportedChangesetFormats.UNMODELED)) {
                this.addFailureRuleIteration(changeSet, new RuleIteration(RuleIteration.FailureReason.INVALID_CHANGELOG_FILE_TYPE), configurableRule);
                failedUnmodeled = true;
            }
            if (modeledCount > 0 && !supportedChangesetFormats.containsAll(SupportedChangesetFormats.MODELED)) {
                this.addFailureRuleIteration(changeSet, new RuleIteration(RuleIteration.FailureReason.INVALID_CHANGELOG_FILE_TYPE), configurableRule);
                failedModeled = true;
            }
            return !(unmodeledCount == 0 && failedModeled || modeledCount == 0 && failedUnmodeled || failedModeled && failedUnmodeled);
        }
        return true;
    }

    public boolean shouldBeEvaluated(DatabaseObject databaseObject, AbstractConfigurableRule configurableRule) {
        return true;
    }

    public final boolean hasDefaultParameterValues() {
        if (this.getParameters() != null) {
            for (RuleParameter<?> parameter : this.getParameters()) {
                if (parameter.getDefaultValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public LicenseTier getRequiredLicense(ScopeEnum currentlyExecutingScope) {
        return LicenseTier.PRO;
    }

    public LicenseTier getMinimumAllowableLicense() {
        List<ScopeEnum> scopes = this.getScope();
        if (scopes != null) {
            ArrayList<LicenseTier> requiredLicenses = new ArrayList<LicenseTier>(scopes.size());
            for (ScopeEnum scope : scopes) {
                LicenseTier requiredLicense = this.getRequiredLicense(scope);
                if (requiredLicense == null) continue;
                requiredLicenses.add(requiredLicense);
            }
            return requiredLicenses.stream().min(Comparator.comparingInt(LicenseTier::getValue)).orElse(LicenseTier.COMMUNITY);
        }
        return LicenseTier.COMMUNITY;
    }

    public static String getSql(AbstractSQLChange change) {
        if (change instanceof SQLFileChange) {
            Boolean shouldCache = (Boolean)Scope.getCurrentScope().get(ChecksRunCommandStep.CACHE_CHANGELOG_FILE_CONTENTS.getName(), (Object)true);
            Logger log = Scope.getCurrentScope().getLog(AbstractLiquibaseRule.class);
            if (shouldCache.booleanValue() && sqlContentsCache.containsKey(change)) {
                log.fine("Cache hit for " + change);
                return sqlContentsCache.get(change);
            }
            String sql = change.getSql();
            if (!shouldCache.booleanValue()) {
                log.fine("Cache miss for " + change + " and not caching, because caching is disabled");
            } else {
                log.fine("Cache miss for " + change);
                sqlContentsCache.put(change, sql);
            }
            return sql;
        }
        return change.getSql();
    }

    @Override
    public int compareTo(com.datical.liquibase.ext.rules.api.Rule rule) {
        if (this.getPriority() < rule.getPriority()) {
            return -1;
        }
        if (this.getPriority() > rule.getPriority()) {
            return 1;
        }
        return this.getName().compareTo(rule.getName());
    }

    public boolean isEnabledByDefault() {
        return this.hasDefaultParameterValues();
    }

    public static class SupportedChangesetFormats {
        public static final List<String> MODELED = Collections.unmodifiableList(Arrays.asList("xml", "yaml", "json"));
        public static final List<String> UNMODELED = Collections.singletonList("sql");
        public static final List<String> ALL = Stream.concat(UNMODELED.stream(), MODELED.stream()).collect(Collectors.toList());
    }
}

