/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.DropTriggerStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropTrigger", description="Drop trigger", priority=1)
public class DropTriggerChange
extends LicenseValidationChange {
    private String triggerName;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String scope;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @DatabaseChangeProperty(description="Name of the trigger to drop")
    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    @DatabaseChangeProperty(description="Name of the database catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(description="Name of the database schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(description="Name of the table the trigger is set on")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(description="Name of the module for the trigger")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getConfirmationMessage() {
        return "Trigger " + this.getTriggerName() + " has been dropped";
    }

    public SqlStatement[] generateStatements(Database database) {
        DropTriggerStatement dropTriggerStatement = new DropTriggerStatement(this.getCatalogName(), this.getSchemaName(), this.getTriggerName());
        dropTriggerStatement.setScope(this.getScope());
        dropTriggerStatement.setTableName(this.getTableName());
        return new SqlStatement[]{dropTriggerStatement};
    }
}

