/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import liquibase.Scope;
import liquibase.diff.output.DiffOutputControl;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.OpenOptions;
import liquibase.resource.Resource;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.MD5Util;
import liquibase.util.StringUtil;

public class ObjectSqlFileUtil {
    public static String writeObjectSql(StoredDatabaseLogic object) {
        return ObjectSqlFileUtil.writeObjectSql((DatabaseObject)object, object.getBody());
    }

    public static String writeObjectSql(DatabaseObject object, String sqlText) {
        return ObjectSqlFileUtil.writeObjectSql(object, sqlText, null);
    }

    public static String writeObjectSql(DatabaseObject object, String sqlText, String relativePath) {
        Resource baseDir;
        Resource saveFile;
        String objectType = object.getClass().getSimpleName().toLowerCase();
        String objectName = object.getName();
        String actualRelativePath = relativePath;
        if (relativePath == null) {
            String functionArguments;
            actualRelativePath = objectType + "/" + objectName + ".sql";
            if (objectName != null && objectName.contains("(") && (functionArguments = objectName.replaceFirst(".+?\\s*(\\(.*\\)).*", "$1")).length() > 0) {
                actualRelativePath = actualRelativePath.replace(functionArguments, "-" + MD5Util.computeMD5((String)functionArguments).substring(0, 8));
            }
        }
        if (object.getObjectTypeName().equalsIgnoreCase(Trigger.class.getSimpleName()) && objectName != null) {
            String body = (String)object.getAttribute("body", String.class);
            String suffix = body != null ? MD5Util.computeMD5((String)body).substring(0, 8) : StringUtil.randomIdentifer((int)8);
            actualRelativePath = actualRelativePath.replace(objectName, String.format("%s-%s", objectName, suffix));
        }
        DiffOutputControl diffOutputControl = (DiffOutputControl)Scope.getCurrentScope().get("diffOutputControl", DiffOutputControl.class);
        if (object.getSchema() != null) {
            if (diffOutputControl.getIncludeCatalog() && diffOutputControl.getIncludeSchema()) {
                actualRelativePath = object.getSchema().getCatalogName() + "." + object.getSchema().getName() + "/" + actualRelativePath;
            } else if (diffOutputControl.getIncludeCatalog() && object.getSchema().getCatalogName() != null) {
                actualRelativePath = object.getSchema().getCatalogName() + "/" + actualRelativePath;
            } else if (diffOutputControl.getIncludeSchema() && object.getSchema().getName() != null) {
                actualRelativePath = object.getSchema().getName() + "/" + actualRelativePath;
            }
        }
        if ((saveFile = (baseDir = (Resource)Scope.getCurrentScope().get("DiffToChangeLog.externalFilesDir", Resource.class)).resolve(actualRelativePath)).exists()) {
            throw new UnexpectedLiquibaseException(saveFile.getUri() + " already exists");
        }
        try (OutputStream outputStream = saveFile.openOutputStream(new OpenOptions());
             OutputStreamWriter osw = new OutputStreamWriter(outputStream);){
            osw.write(sqlText);
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        return new File(baseDir.getPath()).getName() + "/" + actualRelativePath;
    }
}

