/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.TriFunction;
import java.util.regex.Pattern;

public enum OperatorEnum {
    STARTS_WITH((searchString, value, caseSensitive) -> {
        if (caseSensitive.booleanValue()) {
            return value.startsWith((String)searchString);
        }
        return value.toLowerCase().startsWith(searchString.toLowerCase());
    }, "starts with"),
    ENDS_WITH((searchString, value, caseSensitive) -> {
        if (caseSensitive.booleanValue()) {
            return value.endsWith((String)searchString);
        }
        return value.toLowerCase().endsWith(searchString.toLowerCase());
    }, "ends with"),
    CONTAINS((searchString, value, caseSensitive) -> {
        if (caseSensitive.booleanValue()) {
            return value.contains((CharSequence)searchString);
        }
        return value.toLowerCase().contains(searchString.toLowerCase());
    }, "contains"),
    REGEXP((searchString, value, caseSensitive) -> Pattern.compile(searchString).matcher((CharSequence)value).matches(), "matches the regular expression"),
    EQUALS((searchString, value, caseSensitive) -> {
        if (caseSensitive.booleanValue()) {
            return value.equals(searchString);
        }
        return value.equalsIgnoreCase((String)searchString);
    }, "equals");

    final TriFunction<String, String, Boolean, Boolean> matcher;
    public final String displayName;

    private OperatorEnum(TriFunction<String, String, Boolean, Boolean> matcher, String displayName) {
        this.matcher = matcher;
        this.displayName = displayName;
    }

    public boolean matches(String searchString, String value, boolean caseSensitive) {
        if (value == null) {
            return false;
        }
        return this.matcher.apply(searchString, value, caseSensitive);
    }
}

