/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.dynamic.AbstractRegexHelperCheck;
import java.util.Arrays;
import java.util.List;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;

public class PatternANotPrecededByPatternB
extends AbstractRegexHelperCheck {
    @Override
    public int getPriority() {
        return super.getPriority() + 4;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, database, false, DynamicRuleParameterEnum.NEGATIVE_LOOKBEHIND_MESSAGE, DynamicRuleParameterEnum.LOOKBEHIND_SEARCH_STRING, AbstractRegexHelperCheck.Direction.BACKWARD, false);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changes, changeSet, dr, database, true, DynamicRuleParameterEnum.NEGATIVE_LOOKBEHIND_MESSAGE, DynamicRuleParameterEnum.LOOKBEHIND_SEARCH_STRING, AbstractRegexHelperCheck.Direction.BACKWARD, false);
    }

    @Override
    public String getDescription() {
        return "Check triggers if the user-supplied regex pattern A is NOT preceded by the user-supplied regex pattern B";
    }

    @Override
    public String getShortName() {
        return "PatternANotPrecededByPatternB";
    }

    @Override
    protected String getFailureMessage(String messageTemplate, String primarySearchString, String secondarySearchString, ChangeSet changeSet) {
        String message = super.getFailureMessage(messageTemplate, primarySearchString, secondarySearchString, changeSet);
        return message.replace("<" + (Object)((Object)DynamicRuleParameterEnum.LOOKBEHIND_SEARCH_STRING) + ">", secondarySearchString);
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.PRIMARY_SEARCH_STRING), new RuleParameter(DynamicRuleParameterEnum.LOOKBEHIND_SEARCH_STRING), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE), new RuleParameter(DynamicRuleParameterEnum.NEGATIVE_LOOKBEHIND_MESSAGE), new RuleParameter(DynamicRuleParameterEnum.STRIP_COMMENTS));
    }
}

