/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractChainedChecksRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseServiceUtils;
import liquibase.resource.Resource;
import liquibase.util.StringUtil;

public abstract class AbstractChecksCommandStep
extends AbstractCommandStep {
    private static final String NULL_INPUT_EXCEPTION_MESSAGE = "WARNING:  Severity value '' is not valid.  Options: '0', '1', '2', '3', '4', 'INFO', 'MINOR', 'MAJOR', 'CRITICAL', 'BLOCKER'";
    private static final String WRONG_NUMBER_INPUT_EXCEPTION_MESSAGE = "WARNING:  Severity value '%s' is not valid.  Options: '0', '1', '2', '3', '4'";
    private static final String WRONG_STRING_INPUT_EXCEPTION_MESSAGE = "WARNING:  Severity value '%s' is not valid.  Options: 'INFO', 'MINOR', 'MAJOR', 'CRITICAL', 'BLOCKER'";

    public static List<AbstractConfigurableRule> determineRulesToRun(CheckSettingsConfig config, String checkNameToRunList) throws CommandExecutionException {
        return AbstractChecksCommandStep.determineRulesToRun(config, checkNameToRunList, true);
    }

    public static List<AbstractConfigurableRule> determineRulesToRun(CheckSettingsConfig config, String checkNameToRunList, boolean includeChains) throws CommandExecutionException {
        if (StringUtil.isEmpty((String)checkNameToRunList)) {
            return config.getRules(includeChains);
        }
        List checkNamesToRun = Arrays.stream(checkNameToRunList.split(",")).map(String::trim).collect(Collectors.toList());
        LinkedHashSet<String> rulesToInclude = new LinkedHashSet<String>();
        LinkedHashSet<String> rulesToExclude = new LinkedHashSet<String>();
        for (String checkNameToRun : checkNamesToRun) {
            if (checkNameToRun.startsWith("!")) {
                rulesToExclude.add(checkNameToRun.substring(1));
                continue;
            }
            rulesToInclude.add(checkNameToRun);
        }
        Set intersection = rulesToInclude.stream().filter(rulesToExclude::contains).collect(Collectors.toSet());
        if (!intersection.isEmpty()) {
            throw new CommandExecutionException("The following rules were marked as both included and excluded: " + StringUtil.join(intersection, (String)", "));
        }
        ArrayList<AbstractConfigurableRule> rulesToRun = new ArrayList<AbstractConfigurableRule>(checkNamesToRun.size());
        if (rulesToInclude.isEmpty()) {
            rulesToRun.addAll(config.getRules());
        } else {
            List<AbstractConfigurableRule> rulesList = AbstractChecksCommandStep.convertShortNameListToRuleList(rulesToInclude, config);
            ArrayList<AbstractConfigurableRule> expandedRules = new ArrayList<AbstractConfigurableRule>(rulesList);
            rulesList.forEach(r -> {
                DynamicRule dr;
                if (r instanceof DynamicRule && (dr = (DynamicRule)r).isChained() && dr.isEnabled()) {
                    AbstractChecksCommandStep.expandChainedCheck(config, dr, expandedRules);
                    if (!includeChains) {
                        expandedRules.remove(dr);
                    }
                }
            });
            rulesToRun.addAll(expandedRules);
        }
        if (!rulesToExclude.isEmpty()) {
            rulesToRun.removeAll(AbstractChecksCommandStep.convertShortNameListToRuleList(rulesToExclude, config));
        }
        return rulesToRun;
    }

    public static List<AbstractConfigurableRule> determineChainedRulesToRun(CheckSettingsConfig config, String checkNameToRunList) throws CommandExecutionException {
        if (StringUtil.isEmpty((String)checkNameToRunList)) {
            return config.getChainedRules();
        }
        List checkNamesToRun = Arrays.stream(checkNameToRunList.split(",")).map(String::trim).collect(Collectors.toList());
        LinkedHashSet<String> rulesToInclude = new LinkedHashSet<String>();
        LinkedHashSet<String> rulesToExclude = new LinkedHashSet<String>();
        for (String checkNameToRun : checkNamesToRun) {
            if (checkNameToRun.startsWith("!")) {
                rulesToExclude.add(checkNameToRun.substring(1));
                continue;
            }
            rulesToInclude.add(checkNameToRun);
        }
        Set intersection = rulesToInclude.stream().filter(rulesToExclude::contains).collect(Collectors.toSet());
        if (!intersection.isEmpty()) {
            throw new CommandExecutionException("The following rules were marked as both included and excluded: " + StringUtil.join(intersection, (String)", "));
        }
        ArrayList<AbstractConfigurableRule> rulesToRun = new ArrayList<AbstractConfigurableRule>(checkNamesToRun.size());
        if (rulesToInclude.isEmpty()) {
            rulesToRun.addAll(config.getRules());
        } else {
            List<AbstractConfigurableRule> rulesList = AbstractChecksCommandStep.convertShortNameListToRuleList(rulesToInclude, config);
            ArrayList chainedRules = new ArrayList();
            rulesList.forEach(r -> {
                DynamicRule dr;
                if (r instanceof DynamicRule && (dr = (DynamicRule)r).isChained()) {
                    chainedRules.add(r);
                }
            });
            rulesToRun.addAll(chainedRules);
        }
        if (!rulesToExclude.isEmpty()) {
            rulesToRun.removeAll(AbstractChecksCommandStep.convertShortNameListToRuleList(rulesToExclude, config));
        }
        return rulesToRun;
    }

    private static void expandChainedCheck(CheckSettingsConfig config, DynamicRule dr, List<AbstractConfigurableRule> rulesList) {
        List<String> checks = dr.listChecksInChain();
        ArrayList newList = new ArrayList();
        checks.forEach(c -> {
            AbstractConfigurableRule foundRule = config.getRuleByShortName((String)c);
            if (foundRule != null) {
                if (foundRule instanceof DynamicRule && ((DynamicRule)foundRule).isChained()) {
                    AbstractChecksCommandStep.expandChainedCheck(config, (DynamicRule)foundRule, rulesList);
                } else {
                    newList.add(foundRule);
                }
            }
        });
        newList.forEach(newRule -> {
            if (!rulesList.contains(newRule)) {
                rulesList.add((AbstractConfigurableRule)newRule);
            }
        });
    }

    private static List<AbstractConfigurableRule> convertShortNameListToRuleList(Set<String> ruleNames, CheckSettingsConfig config) throws CommandExecutionException {
        ArrayList<AbstractConfigurableRule> returnList = new ArrayList<AbstractConfigurableRule>(ruleNames.size());
        ArrayList<String> unknownRules = new ArrayList<String>();
        for (String ruleName : ruleNames) {
            AbstractConfigurableRule foundRule = config.getRuleByShortName(ruleName);
            if (foundRule == null) {
                unknownRules.add(ruleName);
                continue;
            }
            returnList.add(foundRule);
        }
        if (!unknownRules.isEmpty()) {
            throw new CommandExecutionException("One or more specified checks not found: '" + StringUtil.join(unknownRules, (String)"', '") + "'. Please check your arguments and try again.");
        }
        return returnList;
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        String customizeHelp = "";
        if (this.isSeverityModificationCommand(commandDefinition)) {
            customizeHelp = "The severity level of a check can be customized to determine its return codes:" + System.lineSeparator() + "Enter \"INFO\" for return code: 0" + System.lineSeparator() + "Enter \"MINOR\" for return code: 1" + System.lineSeparator() + "Enter \"MAJOR\" for return code: 2" + System.lineSeparator() + "Enter \"CRITICAL\" for return code: 3" + System.lineSeparator() + "Enter \"BLOCKER\" for return code: 4" + System.lineSeparator() + System.lineSeparator();
        }
        commandDefinition.setHelpFooter("\nNOTES\n" + customizeHelp + "Liquibase Pro users can enable and customize as many rules as they want!" + System.lineSeparator() + "Learn more about Liquibase Quality Checks at:" + System.lineSeparator() + "https://docs.liquibase.com/quality-checks" + System.lineSeparator() + "Get your FREE Pro trial today " + "https://liquibase.com/trial" + " and add it to your defaults file or use in an Environment variable.");
        if (this.isSeverityModificationCommand(commandDefinition)) {
            commandDefinition.setGroupHelpFooter(commandDefinition.getHelpFooter());
        }
    }

    public void validate(CommandScope commandScope) throws CommandValidationException {
        if (this.commandRequiresProLicense()) {
            LicenseServiceUtils.checkProLicenseAndThrowException((String[])commandScope.getCommand().getName());
        }
        super.validate(commandScope);
    }

    public boolean commandRequiresProLicense() {
        return true;
    }

    protected boolean isMavenIntegration(CommandResultsBuilder resultsBuilder) {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String integration = (String)commandScope.getConfiguredValue(ChecksRunCommandStep.CHECKS_INTEGRATION_ARG).getValue();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(ChecksRunCommandStep.CHECKS_SETTINGS_FILE_ARG).getValue();
        return integration.equalsIgnoreCase("maven") && StringUtil.isEmpty((String)checksSettingsFile);
    }

    private boolean isSeverityModificationCommand(CommandDefinition commandDefinition) {
        return commandDefinition.getName().length > 1 && commandDefinition.getName()[0].equals("checks") && (commandDefinition.getName()[1].equals("customize") || commandDefinition.getName()[1].equals("copy"));
    }

    protected void throwExceptionIfPackageFile(CheckSettingsConfig csc) throws CommandExecutionException {
        boolean isPackageFile;
        if (csc != null && (isPackageFile = csc.isPackageFile())) {
            throw new CommandExecutionException("ERROR: The command '" + StringUtil.join((String[])this.defineCommandNames()[0], (String)" ") + "' cannot be used with a checks-package file. Please update the checks-settings-file property (LIQUIBASE_CHECKS_SETTINGS_FILE, --checks-settings-file, etc) to a different file.");
        }
    }

    protected static boolean modifySeverity(AbstractConfigurableRule ruleToModify) {
        String currentValue = ruleToModify.getSeverity().toString();
        String severity = (String)Scope.getCurrentScope().getUI().prompt("Set the Severity to return a code of 0-4 when triggered. (options: 'INFO'|0, 'MINOR'|1, 'MAJOR'|2, 'CRITICAL'|3, 'BLOCKER'|4)?", (Object)currentValue, (input, type) -> {
            SeverityEnum[] enums = SeverityEnum.values();
            if (input == null) {
                throw new IllegalArgumentException(NULL_INPUT_EXCEPTION_MESSAGE);
            }
            if (StringUtil.isNumeric((CharSequence)input)) {
                return Arrays.stream(enums).filter(e -> input.equals(Integer.toString(e.getExitValue()))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(WRONG_NUMBER_INPUT_EXCEPTION_MESSAGE, input))).name();
            }
            return Arrays.stream(enums).filter(e -> input.equalsIgnoreCase(e.name())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(WRONG_STRING_INPUT_EXCEPTION_MESSAGE, input))).name();
        }, String.class);
        SeverityEnum[] enums = SeverityEnum.values();
        Optional<SeverityEnum> severityEnum = Arrays.stream(enums).filter(e -> severity.equalsIgnoreCase(e.name())).findFirst();
        if (severityEnum.isPresent() && !ruleToModify.getSeverity().equals((Object)severityEnum.get())) {
            ruleToModify.setSeverity(severityEnum.get());
            return true;
        }
        return false;
    }

    protected static AbstractLiquibaseRule findConfigurableParentRule(AbstractConfigurableRule configurableRule, List<AbstractLiquibaseRule> rules, String checkName, String parentRuleNotConfigurableErrorMessage) throws CommandExecutionException {
        Optional<AbstractLiquibaseRule> parentRuleOpt = configurableRule.findParentRule(rules);
        if (!parentRuleOpt.isPresent()) {
            throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + checkName + "' was copied from a rule which does not exist.  Run 'liquibase checks show' to see a list of available checks.");
        }
        AbstractLiquibaseRule parentRule = parentRuleOpt.get();
        if (!parentRule.isConfigurable()) {
            throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + checkName + "' " + parentRuleNotConfigurableErrorMessage + "." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
        }
        return parentRule;
    }

    public static List<AbstractLiquibaseRule> listAllRules() {
        ArrayList<AbstractLiquibaseRule> rules = new ArrayList<AbstractLiquibaseRule>(Scope.getCurrentScope().getServiceLocator().findInstances(AbstractLiquibaseRule.class));
        Collections.sort(rules);
        return rules;
    }

    public static List<AbstractLiquibaseRule> listAllChainedRules() {
        ArrayList rules = new ArrayList(Scope.getCurrentScope().getServiceLocator().findInstances(AbstractLiquibaseRule.class));
        List<AbstractLiquibaseRule> chainedRules = rules.stream().filter(AbstractChainedChecksRule.class::isInstance).collect(Collectors.toList());
        Collections.sort(chainedRules);
        return chainedRules;
    }

    public static AbstractLiquibaseRule findRuleByShortName(String shortName) throws CommandExecutionException {
        return AbstractChecksCommandStep.findRuleByShortName(AbstractChecksCommandStep.listAllRules(), shortName);
    }

    public static AbstractLiquibaseRule findRuleByShortName(List<AbstractLiquibaseRule> rules, String shortName) throws CommandExecutionException {
        Optional<AbstractLiquibaseRule> rule = rules.stream().filter(r -> r.getShortName().equalsIgnoreCase(shortName)).findFirst();
        if (rule.isPresent()) {
            return rule.get();
        }
        throw new CommandExecutionException("\n\nCheck '" + shortName + "' does not exist.  Run 'liquibase checks show' to see a list of available checks.");
    }

    public static void createListOfChecksInChains(List<AbstractConfigurableRule> rulesToRun, CheckSettingsConfig config, List<String> checksInChains) {
        rulesToRun.forEach(r -> {
            DynamicRule dr;
            if (r instanceof DynamicRule && (dr = (DynamicRule)r).isChained() && dr.isEnabled()) {
                ArrayList<AbstractConfigurableRule> innerRules = new ArrayList<AbstractConfigurableRule>();
                List<String> checksInThisChain = dr.listChecksInChain();
                checksInThisChain.forEach(innerCheck -> {
                    DynamicRule innerDynamic = config.getDynamicRuleByShortName((String)innerCheck);
                    if (innerDynamic != null && innerDynamic.isChained()) {
                        innerRules.add(innerDynamic);
                    } else if (!checksInChains.contains(innerCheck)) {
                        checksInChains.add((String)innerCheck);
                    }
                });
                AbstractChecksCommandStep.createListOfChecksInChains(innerRules, config, checksInChains);
            }
        });
    }

    protected static void checkFileArgExistence(String fileNameArg, String argDesc) throws IllegalArgumentException {
        if (StringUtil.isEmpty((String)fileNameArg)) {
            return;
        }
        if (!AbstractChecksCommandStep.doesFileExist(fileNameArg, argDesc)) {
            throw new IllegalArgumentException(String.format("%nERROR: The %s file specified at '%s' was not found.\nPlease specify a path including the filename in the CLI, by Environment variable, or other standard method.\nLearn more at https://docs.liquibase.com/quality-checks", argDesc, fileNameArg));
        }
    }

    private static boolean doesFileExist(String fileNameArg, String argDesc) {
        try {
            Resource resource = ResourceUtil.getResource(fileNameArg);
            return resource.exists();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%nError reading %s settings file '%s': %s%nCorrect this issue and try to run checks again.", argDesc, fileNameArg, e.getMessage()));
        }
    }
}

