/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.CheckStatus;
import com.datical.liquibase.ext.command.checks.ChecksPackageNotFoundException;
import com.datical.liquibase.ext.command.checks.ChecksTableColumns;
import com.datical.liquibase.ext.command.helpers.ChecksAutoEnableNewChecksArgument;
import com.datical.liquibase.ext.command.helpers.ChecksAutoUpdateArgument;
import com.datical.liquibase.ext.command.helpers.ChecksPackagesArgument;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class ChecksShowCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "show"};
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;
    public static final CommandArgumentDefinition<String> SHOW_COLUMNS_ARG;
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<CheckStatus> CHECK_STATUS_ARG;

    private static Set<String> convertColArgs(String showColsArgs) {
        List<String> argsList = Arrays.asList(showColsArgs.split(","));
        AtomicInteger i = new AtomicInteger();
        argsList.forEach(arg -> {
            if (arg.trim().equalsIgnoreCase("enabled")) {
                argsList.set(i.get(), "status");
            }
            i.getAndIncrement();
        });
        return new LinkedHashSet<String>(argsList);
    }

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        if (this.isMavenIntegration(resultsBuilder)) {
            InMemoryChecksFileAccessor fileAccessor = new InMemoryChecksFileAccessor();
            Scope.child(Collections.singletonMap("fileAccessor", fileAccessor), () -> this.doRun(resultsBuilder));
        } else {
            this.doRun(resultsBuilder);
        }
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(ChecksPackagesArgument.class, ChecksAutoUpdateArgument.class, ChecksAutoEnableNewChecksArgument.class);
    }

    private void doRun(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksShowCommandStep.checkFileArgExistence(checksSettingsFile, "checks settings");
        String reportMessage = System.lineSeparator() + "Generating report on current configuration of checks using settings in: " + (StringUtil.isEmpty((String)checksSettingsFile) ? "liquibase.checks-settings.conf" : checksSettingsFile) + System.lineSeparator();
        Scope.getCurrentScope().getUI().sendMessage(reportMessage);
        String packagesArgument = (String)commandScope.getDependency(ChecksPackagesArgument.class);
        boolean outputtedTable = ChecksShowCommandStep.writeTableToOutput(resultsBuilder, checksSettingsFile, true, packagesArgument);
        if (outputtedTable) {
            String infoMessage = "INFO: Customize 'checks show' table with --show-cols flag. Learn more with 'liquibase checks show --help'" + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage(infoMessage);
        }
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("List available checks, their configuration options, and current settings");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    @Override
    public boolean commandRequiresProLicense() {
        return false;
    }

    public static boolean writeTableToOutput(CommandResultsBuilder resultsBuilder, CheckSettingsConfig config, boolean filterRulesUsingCheckNameArgument) throws IOException, LiquibaseException {
        List<ChecksTableColumns> requiredColumns = ChecksShowCommandStep.getRequiredColumns(resultsBuilder, config != null && config.isPackageFile());
        List<AbstractLiquibaseRule> allRules = ChecksShowCommandStep.listAllRules();
        if (config != null) {
            CheckSettingsConfigHelper.sortRulesByPriority(allRules, config);
        }
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checkNameToRunList = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue();
        CheckStatus checkStatus = (CheckStatus)((Object)commandScope.getConfiguredValue(CHECK_STATUS_ARG).getValue());
        List<AbstractLiquibaseRule> requiredRules = allRules;
        if (!checkNameToRunList.equals("all") && filterRulesUsingCheckNameArgument) {
            if (config != null) {
                List<AbstractConfigurableRule> requiredConfigRules = ChecksShowCommandStep.filterRulesByShortName(config, checkNameToRunList);
                config.setRules(requiredConfigRules);
            } else {
                requiredRules = ChecksShowCommandStep.filterRulesByShortName(allRules, checkNameToRunList);
            }
        }
        List<List<String>> table = ChecksShowCommandStep.createTableWithData(requiredRules, config, requiredColumns, checkStatus);
        boolean outputtedTable = false;
        if (!table.isEmpty()) {
            Writer outputWriter = ChecksShowCommandStep.createOutputWriter(resultsBuilder);
            TableOutput.formatOutput(table, ChecksTableColumns.getColumnWidthsList(requiredColumns), (boolean)true, (Writer)outputWriter);
            outputtedTable = true;
        }
        if (config != null) {
            config.outputWarningMessage();
        }
        return outputtedTable;
    }

    public static boolean writeTableToOutput(CommandResultsBuilder resultsBuilder, String filename, boolean filterRulesUsingCheckNameArgument, String packagesArgument) throws IOException, LiquibaseException {
        CheckSettingsConfig config;
        List<AbstractLiquibaseRule> allRules = ChecksShowCommandStep.listAllRules();
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Boolean autoUpdate = (Boolean)commandScope.getDependency(ChecksAutoUpdateArgument.class);
        Boolean autoEnableNewChecks = (Boolean)commandScope.getDependency(ChecksAutoEnableNewChecksArgument.class);
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(filename, autoUpdate, autoEnableNewChecks);
        try {
            config = helper.read(allRules, packagesArgument);
        }
        catch (ChecksPackageNotFoundException cpe) {
            throw cpe;
        }
        catch (Exception e) {
            throw new CommandExecutionException(CheckSettingsConfigHelper.generateInvalidChecksExceptionMessage(filename), (Throwable)e);
        }
        return ChecksShowCommandStep.writeTableToOutput(resultsBuilder, config, filterRulesUsingCheckNameArgument);
    }

    private static List<AbstractLiquibaseRule> filterRulesByShortName(List<AbstractLiquibaseRule> rules, String checkNameToRunList) throws CommandExecutionException {
        if (StringUtil.isEmpty((String)checkNameToRunList)) {
            return rules;
        }
        List checkNamesToRun = StringUtil.splitAndTrim((String)checkNameToRunList, (String)",");
        ArrayList<AbstractLiquibaseRule> rulesToRun = new ArrayList<AbstractLiquibaseRule>(checkNamesToRun.size());
        ArrayList<String> unknownRules = new ArrayList<String>();
        for (String checkNameToRun : checkNamesToRun) {
            Optional<AbstractLiquibaseRule> foundRuleOpt = rules.stream().filter(rule -> checkNamesToRun.contains(ChecksShowCommandStep.toArgumentCase(rule.getShortName()))).findFirst();
            if (!foundRuleOpt.isPresent()) {
                unknownRules.add(checkNameToRun);
                continue;
            }
            rulesToRun.add(foundRuleOpt.get());
        }
        if (!unknownRules.isEmpty()) {
            throw new CommandExecutionException("One or more specified checks not found: '" + StringUtil.join(unknownRules, (String)"', '") + "'. Please check your arguments and try again.");
        }
        return rulesToRun;
    }

    private static List<AbstractConfigurableRule> filterRulesByShortName(CheckSettingsConfig config, String checkNameToRunList) throws CommandExecutionException {
        return AbstractChecksCommandStep.determineRulesToRun(config, checkNameToRunList);
    }

    private static List<List<String>> createTableWithData(List<AbstractLiquibaseRule> rules, CheckSettingsConfig config, List<ChecksTableColumns> requiredColumns, CheckStatus checkStatus) {
        List<String> requiredColumnNames = ChecksTableColumns.getColumnNamesList(requiredColumns);
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        if (config != null) {
            table.add(requiredColumnNames);
            for (AbstractConfigurableRule customizedRule : config.getRules()) {
                if (checkStatus == CheckStatus.ENABLED && !customizedRule.isEnabled() || checkStatus == CheckStatus.DISABLED && customizedRule.isEnabled()) continue;
                Optional<AbstractLiquibaseRule> parentRuleOpt = ChecksShowCommandStep.findParentRule(rules, customizedRule);
                if (parentRuleOpt.isPresent()) {
                    AbstractLiquibaseRule parentRule = parentRuleOpt.get();
                    String customizations = "<None>";
                    String shortName = parentRule.getShortName();
                    if (customizedRule.isConfigurable()) {
                        customizations = ((DynamicRule)customizedRule).prettyPrintParameters();
                        shortName = customizedRule.getShortName();
                    }
                    Map<String, String> allRuleProperties = ChecksShowCommandStep.prepareAllRulePropertiesMap(parentRule.getId().toString(), parentRule.getName(), shortName, ChecksShowCommandStep.scopesToString(parentRule.getScope()), StringUtil.join(parentRule.getSupportedChangesetFormats(), (String)", "), customizedRule.isEnabled() ? "enabled" : "disabled", Integer.toString(customizedRule.getSeverity().getExitValue()), String.valueOf(parentRule.getPriority()), customizations, parentRule.getDescription(), customizedRule.getFileInfo() != null ? customizedRule.getFileInfo().getFilename() : null);
                    table.add(ChecksShowCommandStep.getRulePropertiesForRequiredColumns(requiredColumnNames, allRuleProperties));
                    continue;
                }
                Scope.getCurrentScope().getLog(ChecksShowCommandStep.class).fine("Customized rule with ID " + customizedRule.getId() + " does not match any rules loaded in the system, and will not be shown.");
            }
        }
        return table;
    }

    private static List<ChecksTableColumns> getRequiredColumns(CommandResultsBuilder resultsBuilder, boolean isPackageFile) {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String requiredColumnArgs = (String)commandScope.getConfiguredValue(SHOW_COLUMNS_ARG).getValue();
        if (ChecksTableColumns.DEFAULT_COLUMNS_ARG.equals(requiredColumnArgs) && isPackageFile) {
            requiredColumnArgs = ChecksTableColumns.DEFAULT_COLUMNS_ARG_WITH_FILE;
        }
        ArrayList<String> convertedArgs = new ArrayList<String>(ChecksShowCommandStep.convertColArgs(requiredColumnArgs));
        String finalRequiredColumnArgs = StringUtil.join(convertedArgs, (String)",");
        return Arrays.stream(ChecksTableColumns.values()).filter(column -> finalRequiredColumnArgs.contains(column.getNameArgumentCase())).collect(Collectors.toList());
    }

    private static Optional<AbstractLiquibaseRule> findParentRule(List<AbstractLiquibaseRule> rules, AbstractConfigurableRule customizedRule) {
        DynamicRule dr;
        UUID idToMatch = customizedRule.isConfigurable() ? ((dr = (DynamicRule)customizedRule).isCopy() ? dr.getParentRuleId() : dr.getId()) : customizedRule.getId();
        return rules.stream().filter(r -> r.getId().equals(idToMatch)).findFirst();
    }

    private static Map<String, String> prepareAllRulePropertiesMap(String id, String name, String shortname, String scope, String changesetType, String enabled, String severity, String priority, String customization, String description, String file) {
        LinkedHashMap<String, String> allRuleProperties = new LinkedHashMap<String, String>();
        allRuleProperties.put(ChecksTableColumns.ID.getName(), id);
        allRuleProperties.put(ChecksTableColumns.CHECKNAME.getName(), name);
        allRuleProperties.put(ChecksTableColumns.SHORTNAME.getName(), shortname);
        allRuleProperties.put(ChecksTableColumns.SCOPE.getName(), scope);
        allRuleProperties.put(ChecksTableColumns.CHANGESET_TYPE.getName(), changesetType);
        allRuleProperties.put(ChecksTableColumns.STATUS.getName(), enabled);
        allRuleProperties.put(ChecksTableColumns.SEVERITY.getName(), severity);
        allRuleProperties.put(ChecksTableColumns.PRIORITY.getName(), priority);
        allRuleProperties.put(ChecksTableColumns.CUSTOMIZATION.getName(), customization);
        allRuleProperties.put(ChecksTableColumns.DESCRIPTION.getName(), description);
        allRuleProperties.put(ChecksTableColumns.FILE.getName(), file);
        return allRuleProperties;
    }

    private static String toArgumentCase(String value) {
        return StringUtil.toLowerWithoutWhitespaces((String)value);
    }

    private static List<String> getRulePropertiesForRequiredColumns(List<String> requiredColumnNames, Map<String, String> allRuleProperties) {
        return requiredColumnNames.stream().map(allRuleProperties::get).collect(Collectors.toList());
    }

    private static String scopesToString(List<ScopeEnum> scopes) {
        return StringUtil.join((Collection)scopes.stream().map(scopeEnum -> scopeEnum.toString().toLowerCase()).sorted().collect(Collectors.toList()), (String)", ");
    }

    private static Writer createOutputWriter(CommandResultsBuilder resultsBuilder) throws IOException {
        String charsetName = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        OutputStream outputStream = resultsBuilder.getOutputStream();
        return new OutputStreamWriter(outputStream, charsetName);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_INTEGRATION_ARG = builder.argument("checksIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing checks show").build();
        SHOW_COLUMNS_ARG = builder.argument("showCols", String.class).defaultValue((Object)ChecksTableColumns.DEFAULT_COLUMNS_ARG).setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String showColsArgs = ((String)input).toLowerCase();
            if (showColsArgs.equals("all")) {
                return ChecksTableColumns.EVERY_COLUMN_ARG;
            }
            Set<String> specifiedColumnArgs = ChecksShowCommandStep.convertColArgs(showColsArgs);
            Set acceptableColumnArgs = Arrays.stream(ChecksTableColumns.values()).map(ChecksTableColumns::getNameArgumentCase).collect(Collectors.toSet());
            boolean requiredArgsAreAcceptable = acceptableColumnArgs.containsAll(specifiedColumnArgs);
            if (!requiredArgsAreAcceptable) {
                String messageString = "WARNING:  The showCols arguments '" + showColsArgs + "' are not valid." + System.lineSeparator() + "Valid value is a comma separated list of column names: " + ChecksTableColumns.EVERY_COLUMN_ARG + ".";
                throw new IllegalArgumentException(messageString);
            }
            return showColsArgs;
        }).description(String.format("Only show the listed columns. Column options: %s. Use commas to separate column names. Use 'all' to select all the columns.", ChecksTableColumns.EVERY_COLUMN_ARG)).build();
        CHECK_NAME_ARG = builder.argument("checkName", String.class).defaultValue((Object)"all").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            return ((String)input).toLowerCase();
        }).description("Only show the listed rules. Use rule shortnames separated with commas to list all required rules. Checks to exclude can be prefixed with the ! character. Use 'all', to select all the rules (used by default, if the parameter isn't set).").build();
        CHECK_STATUS_ARG = builder.argument("checkStatus", CheckStatus.class).defaultValue((Object)CheckStatus.ALL).description("Only show the rules that are in the requested status. Valid options are 'enabled','disabled', or 'all'").build();
    }
}

