/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.file;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.flow.action.FlowShellCommandAction;
import com.datical.liquibase.ext.flow.action.FlowShellCommandChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.util.ObjectUtil;
import liquibase.util.SystemUtil;

public class FlowVariableExpander {
    public static final Pattern KEY_PATTERN = Pattern.compile("(\\$\\{.+?})");
    public static final String QUOTE_REPLACEMENT = "QUOTE_REPLACEMENT";
    public static final String DEFAULT_VALUE_DELIMITER = ":-";
    private static Map<String, String> executedCommands = new HashMap<String, String>();

    private FlowVariableExpander() {
    }

    public static Map<String, Object> expandVariables(Map<String, Object> args, Map<String, Object> variables) {
        return FlowVariableExpander.expandVariables(args, variables, false);
    }

    public static Map<String, Object> expandVariables(Map<String, Object> args, Map<String, Object> variables, boolean ignoreNonStringScalars) {
        Map<String, Object> anotherAttempt;
        if (args == null) {
            return null;
        }
        int iterations = 0;
        Map<String, Object> expanded = FlowVariableExpander.expand(args, variables, ignoreNonStringScalars);
        while (!(anotherAttempt = FlowVariableExpander.expand(expanded, variables, ignoreNonStringScalars)).equals(expanded)) {
            expanded = anotherAttempt;
            if (++iterations < 100) continue;
        }
        return expanded;
    }

    public static Map<String, Object> execShellCommandsToExpand(Map<String, Object> mapToExpand) {
        if (mapToExpand == null) {
            return null;
        }
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>(mapToExpand);
        mapToExpand.forEach((key, value) -> {
            String expandedArgValue;
            if (value instanceof String && !(expandedArgValue = FlowVariableExpander.execShellToExpand((String)ObjectUtil.convert((Object)value, String.class))).equals(value)) {
                returnMap.put((String)key, expandedArgValue);
            }
        });
        return returnMap;
    }

    public static String execShellToExpand(String stringToExpand) {
        Pattern p = Pattern.compile("`(.*)`");
        Matcher m = p.matcher(stringToExpand);
        while (m.find()) {
            String matched = stringToExpand.substring(m.start(), m.end());
            String expanded = FlowVariableExpander.shellExec(matched);
            if (expanded == null) continue;
            stringToExpand = stringToExpand.replace(matched, expanded);
        }
        return stringToExpand;
    }

    public static String shellExec(String cmdCommand) {
        if (executedCommands.containsKey(cmdCommand = cmdCommand.replace("`", ""))) {
            return executedCommands.get(cmdCommand);
        }
        StringBuilder builder = new StringBuilder();
        try {
            FlowShellCommandAction action = new FlowShellCommandAction();
            action.setExpandedCommand(cmdCommand);
            FlowShellCommandChange commandChange = new FlowShellCommandChange();
            action.setCommandChange(commandChange);
            action.setCommand(cmdCommand);
            String interpreterFromScope = (String)Scope.getCurrentScope().get(FlowCommandStep.FLOW_SHELL_INTERPRETER.getName(), String.class);
            if (interpreterFromScope == null) {
                if (SystemUtil.isWindows()) {
                    action.setInterpreter("cmd");
                } else {
                    action.setInterpreter("bash");
                }
            } else {
                action.setInterpreter(interpreterFromScope);
            }
            Boolean keepTempFiles = (Boolean)Scope.getCurrentScope().get(FlowCommandStep.FLOW_SHELL_KEEP_TEMP_FILES.getName(), Boolean.class);
            if (keepTempFiles == null) {
                keepTempFiles = false;
            }
            action.run(keepTempFiles);
            builder.append(commandChange.getStdout());
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(FlowVariableExpander.class).warning("Unable to execute command: " + cmdCommand + ": " + e.getMessage());
            return null;
        }
        executedCommands.put(cmdCommand, builder.toString());
        return builder.toString();
    }

    private static Map<String, Object> expand(Map<String, Object> args, Map<String, Object> variables, boolean ignoreNonStringScalars) {
        LinkedHashMap<String, Object> expandedMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            if (arg.getValue() instanceof Map) {
                Map<String, Object> innerMap = FlowVariableExpander.expand((Map)arg.getValue(), variables, ignoreNonStringScalars);
                expandedMap.put(arg.getKey(), innerMap);
                continue;
            }
            if (arg.getValue() instanceof List) {
                ArrayList<Object> expandedList = new ArrayList<Object>();
                for (Object o : (List)arg.getValue()) {
                    Map<String, Object> objectMap = Collections.singletonMap("key", o);
                    Map<String, Object> expandMap = FlowVariableExpander.expand(objectMap, variables, ignoreNonStringScalars);
                    expandedList.add(expandMap.get("key"));
                }
                expandedMap.put(arg.getKey(), expandedList);
                continue;
            }
            FlowVariableExpander.expandScalar(variables, expandedMap, arg, ignoreNonStringScalars);
        }
        return expandedMap;
    }

    private static void expandScalar(Map<String, Object> variables, Map<String, Object> expandedMap, Map.Entry<String, Object> arg, boolean ignoreNonStringScalars) {
        Object argValue = arg.getValue();
        if (ignoreNonStringScalars && !(argValue instanceof String)) {
            expandedMap.put(arg.getKey(), argValue);
            return;
        }
        String value = (String)ObjectUtil.convert((Object)argValue, String.class);
        if (value == null) {
            expandedMap.put(arg.getKey(), null);
            return;
        }
        expandedMap.put(arg.getKey(), value);
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            String expandedValue = FlowVariableExpander.expandValue(value, variable);
            value = FlowVariableExpander.replaceWithExpandedValueInMap(expandedValue, value, arg, expandedMap);
        }
        if (value.contains("${") && value.contains("}")) {
            Matcher matcher = KEY_PATTERN.matcher(value);
            while (matcher.find()) {
                FlowVariableExpander.getValueFromConfig(expandedMap, arg, matcher.group(), value);
            }
        }
    }

    private static void getValueFromConfig(Map<String, Object> expandedMap, Map.Entry<String, Object> arg, String possibleKey, String value) {
        String[] parts;
        String defaultValue = null;
        if (possibleKey.contains(DEFAULT_VALUE_DELIMITER) && (parts = possibleKey.split(DEFAULT_VALUE_DELIMITER)).length > 1) {
            possibleKey = parts[0];
            String rhs = FlowVariableExpander.replaceBraces(parts[1]);
            defaultValue = rhs.equals("null") ? "null" : (rhs.equals("empty") ? "" : (!parts[1].startsWith("${") || !parts[1].endsWith("}") ? (String)ObjectUtil.convert((Object)rhs, String.class) : parts[1]));
        }
        String key = FlowVariableExpander.replaceBraces(possibleKey);
        String valueFromConfig = (String)((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getCurrentConfiguredValue(null, null, new String[]{key}).getValue();
        if (valueFromConfig == null) {
            valueFromConfig = defaultValue;
        }
        if (valueFromConfig != null) {
            valueFromConfig = FlowVariableExpander.quoteString(valueFromConfig);
            expandedMap.put(arg.getKey(), valueFromConfig);
            if (defaultValue != null) {
                key = FlowVariableExpander.replaceBraces(value);
            }
            String expandedValue = FlowVariableExpander.expandValue(value, key, valueFromConfig);
            value = FlowVariableExpander.replaceWithExpandedValueInMap(expandedValue, valueFromConfig, arg, expandedMap);
        }
    }

    private static String replaceBraces(String value) {
        String key = value.replace("${", "").replace("}", "");
        return key;
    }

    private static String replaceWithExpandedValueInMap(String expandedValue, String value, Map.Entry<String, Object> arg, Map<String, Object> expandedMap) {
        if (expandedValue.equals(value)) {
            return value;
        }
        boolean possiblyPassword = arg.getKey().toLowerCase().contains("pass");
        Scope.getCurrentScope().getLog(FlowVariableExpander.class).fine("Replacing '" + arg.getKey() + "' configuration of '" + arg.getValue() + "' with '" + (possiblyPassword ? "*****" : expandedValue) + "'");
        expandedMap.put(arg.getKey(), expandedValue);
        return expandedValue;
    }

    private static String expandValue(String value, Map.Entry<String, Object> variable) {
        String stringValue = String.valueOf(variable.getValue());
        stringValue = FlowVariableExpander.quoteString(stringValue);
        String variableKey = variable.getKey();
        return FlowVariableExpander.expandValue(value, variableKey, stringValue);
    }

    private static String quoteString(String stringValue) {
        if (Boolean.TRUE.equals(Scope.getCurrentScope().get(QUOTE_REPLACEMENT, Boolean.class)) && !stringValue.startsWith("'") && !stringValue.startsWith("\"")) {
            stringValue = String.format("'%s'", stringValue);
        }
        return stringValue;
    }

    private static String expandValue(String value, String key, String replacementValue) {
        String returnValue = value.replaceAll(Pattern.quote("${" + key + "}"), Matcher.quoteReplacement(replacementValue));
        if (Boolean.TRUE.equals(Scope.getCurrentScope().get(QUOTE_REPLACEMENT, Boolean.class))) {
            returnValue = returnValue.replace("'" + replacementValue, replacementValue).replace("\"" + replacementValue, replacementValue).replace(replacementValue + "'", replacementValue).replace(replacementValue + "\"", replacementValue);
        }
        return returnValue;
    }
}

