/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.databasepackage.MissingPackageBodyChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageBodyChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingPackageBodyExternalFileChangeGenerator
extends MissingPackageBodyChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && DatabasePackageBody.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixMissing(databaseObject, diffOutputControl, database, database2, changeGeneratorChain);
        CreatePackageBodyChange change = (CreatePackageBodyChange)changes[0];
        change.setRelativeToChangelogFile(true);
        change.setPath(ObjectSqlFileUtil.writeObjectSql((DatabasePackageBody)databaseObject));
        change.setPackageBodyText(null);
        return changes;
    }
}

