/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.storedlogic.AbstractUnexpectedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.DropFunctionChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public class UnexpectedFunctionChangeGenerator
extends AbstractUnexpectedStoredLogicChangeGenerator {
    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class, View.class, Column.class};
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Function.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        DropFunctionChange change = new DropFunctionChange();
        if (diffOutputControl.getIncludeCatalog()) {
            change.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            change.setSchemaName(databaseObject.getSchema().getName());
        }
        change.setFunctionName(Function.getFunctionName(databaseObject));
        return new Change[]{change};
    }
}

