/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.Stage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;

@CommandOverride(override=FlowCommandStep.class)
public class ScriptFlowCommandStep
extends FlowCommandStep {
    public static final String FLOW_VARIABLES = "flowVariables";

    @Override
    protected void runAction(CommandResultsBuilder resultsBuilder, Action action, Stage stage, FlowFile flowFile) throws CommandExecutionException {
        if (!action.getCommand().equals("script")) {
            super.runAction(resultsBuilder, action, stage, flowFile);
            return;
        }
        HashMap<String, LinkedHashMap<String, Object>> scopedValues = new HashMap<String, LinkedHashMap<String, Object>>();
        LinkedHashMap<String, Object> variables = flowFile.getAllVariables();
        Map<String, Object> stageVariables = stage.getVariables();
        variables.putAll(stageVariables);
        scopedValues.put(FLOW_VARIABLES, variables);
        if (action instanceof LiquibaseCommandAction && ((LiquibaseCommandAction)action).getCmdArgs().containsKey("scope")) {
            Map scopeMap = (Map)((LiquibaseCommandAction)action).getCmdArgs().get("scope");
            scopedValues.putAll(scopeMap);
        }
        try {
            Scope.child(scopedValues, () -> super.runAction(resultsBuilder, action, stage, flowFile));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

