/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.reports.ReportType;
import com.datical.liquibase.ext.reports.ReportWriter;
import com.datical.liquibase.ext.util.EnvironmentUtils;
import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.IOException;
import java.io.OutputStream;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;

public class FileSystemReportWriter
implements ReportWriter {
    @Override
    public void write(String path, String name, String contents, ReportType reportType) throws IOException {
        String maybeRelativePath = FileSystemReportWriter.getPathWithSuffix(path, name);
        boolean resourceCreated = !ResourceUtil.getResource(maybeRelativePath).exists();
        try (OutputStream outputStream = this.createResourceIfNeeded(maybeRelativePath);){
            outputStream.write(contents.getBytes((String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
        }
        String fullyQualifiedPath = ProStringUtil.stripUriPrefix(ResourceUtil.getResource(maybeRelativePath).getUri());
        this.logReportCreated(resourceCreated, fullyQualifiedPath);
    }

    private OutputStream createResourceIfNeeded(String path) throws IOException {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        return pathHandlerFactory.openResourceOutputStream(path, new OpenOptions().setTruncate(true).setCreateIfNeeded(true));
    }

    public static String getPathWithSuffix(String reportPath, String name) {
        if (reportPath.endsWith("/")) {
            reportPath = reportPath.substring(0, reportPath.length() - 1);
        }
        if (reportPath.toLowerCase().endsWith(".html")) {
            return reportPath;
        }
        String fullPath = name.toLowerCase().endsWith(".html") ? String.format("%s/%s", reportPath, name) : String.format("%s/%s.%s", reportPath, name, "html");
        return fullPath;
    }

    private void logReportCreated(boolean resourceCreated, String fullyQualifiedPath) {
        if (Boolean.TRUE.equals(ReportConfiguration.QUIET.getCurrentValue())) {
            Scope.getCurrentScope().getUI().sendMessage(String.format("A report was generated at: %s", fullyQualifiedPath));
            return;
        }
        String messageTemplate = "Pro %s Report %s!\n* File '%s' was %s.\n** To suppress %s reports add command arg 'liquibase %s --report-enabled=false'\n** To suppress all Pro Reports set liquibase.reports.enabled=false, or LIQUIBASE_REPORTS_ENABLED=false";
        String commandName = EnvironmentUtils.findCommandName();
        String cliCommandName = ProStringUtil.buildCLICommandName(EnvironmentUtils.findCommandName());
        String message = resourceCreated ? String.format(messageTemplate, commandName, "created", fullyQualifiedPath, "created", commandName, cliCommandName) : String.format(messageTemplate, commandName, "updated", fullyQualifiedPath, "updated", commandName, cliCommandName);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
    }
}

