/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic;

import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.changelog.ChangeSet;
import liquibase.license.LicenseServiceUtils;
import liquibase.serializer.core.formattedsql.FormattedSqlChangeLogSerializer;
import liquibase.util.BooleanUtil;

public class ProFormattedSqlChangeLogSerializer
extends FormattedSqlChangeLogSerializer {
    private static final int PRIORITY_NONE = -1;

    public void createChangeSetInfo(ChangeSet changeSet, StringBuilder builder) {
        Boolean replaceIfExists = false;
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof CreateProcedureChange)) {
                super.createChangeSetInfo(changeSet, builder);
                return;
            }
            replaceIfExists = ((CreateProcedureChange)change).getReplaceIfExists();
        }
        String author = changeSet.getAuthor().replaceAll("\\s+", "_");
        author = author.replace("_(generated)", "");
        builder.append("-- changeset ").append(author).append(":").append(changeSet.getId()).append(" splitStatements:").append(BooleanUtil.isTrue((Boolean)replaceIfExists)).append("\n");
    }

    public int getPriority() {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            return -1;
        }
        return 101;
    }
}

