/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.ChangedFunctionChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class ChangedFunctionExternalFileChangeGenerator
extends ChangedFunctionChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && Function.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixChanged(databaseObject, objectDifferences, diffOutputControl, database, database2, changeGeneratorChain);
        if (changes == null) {
            return null;
        }
        CreateFunctionChange change = AbstractMissingStoredLogicChangeGenerator.findChange(CreateFunctionChange.class, changes);
        change.setRelativeToChangelogFile(true);
        change.setPath(ObjectSqlFileUtil.writeObjectSql((Function)databaseObject));
        change.setFunctionBody(null);
        return changes;
    }
}

