/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.core.AbstractFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.core.FormatConfig;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.Db2Formatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.MariaDbFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.MySqlFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.N1qlFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.PlSqlFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.PostgreSqlFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.RedshiftFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.SparkSqlFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.StandardSqlFormatter;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.languages.TSqlFormatter;

public enum Dialect {
    Db2(Db2Formatter::new, new String[0]),
    MariaDb(MariaDbFormatter::new, new String[0]),
    MySql(MySqlFormatter::new, new String[0]),
    N1ql(N1qlFormatter::new, new String[0]),
    PlSql(PlSqlFormatter::new, "pl/sql"),
    PostgreSql(PostgreSqlFormatter::new, new String[0]),
    Redshift(RedshiftFormatter::new, new String[0]),
    SparkSql(SparkSqlFormatter::new, "spark"),
    StandardSql(StandardSqlFormatter::new, "sql"),
    TSql(TSqlFormatter::new, new String[0]);

    public final Function<FormatConfig, AbstractFormatter> func;
    public final List<String> aliases;

    private Dialect(Function<FormatConfig, AbstractFormatter> func, String ... aliases) {
        this.func = func;
        this.aliases = Arrays.asList(aliases);
    }

    private boolean matches(String name) {
        return this.name().equalsIgnoreCase(name) || this.aliases.stream().anyMatch(s -> s.equalsIgnoreCase(name));
    }

    public static Optional<Dialect> nameOf(String name) {
        return Arrays.stream(Dialect.values()).filter(d -> d.matches(name)).findFirst();
    }
}

