/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.IncludeAllFilter;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public abstract class AbstractChangelogRewriter
implements ChangelogRewriter {
    public static final String IGNORE = "ignore";
    protected String includedPath;
    protected String changelogFile;
    protected DatabaseChangeLog databaseChangelog;
    protected ChangelogRewriter.MOD_TYPE modType;

    protected AbstractChangelogRewriter() {
    }

    @Override
    public void setChangelogFile(String changelogFile) {
        this.changelogFile = changelogFile;
    }

    @Override
    public void setDatabaseChangelog(DatabaseChangeLog databaseChangelog) {
        this.databaseChangelog = databaseChangelog;
    }

    @Override
    public void setIncludedPath(String includedPath) {
        this.includedPath = includedPath;
    }

    @Override
    public void setModType(ChangelogRewriter.MOD_TYPE modType) {
        this.modType = modType;
    }

    @Override
    public void modifyChangelog() throws LiquibaseException {
        InputStream is = null;
        try {
            ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
            Resource resource = resourceAccessor.getExisting(this.changelogFile);
            is = resource.openInputStream();
            String encoding = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            String changelogString = StreamUtil.readStreamAsString((InputStream)is, (String)encoding);
            String newChangeLogString = this.handle(changelogString);
            URI uri = resource.getUri();
            boolean modified = this.writeChangelog(uri, encoding, changelogString, newChangeLogString);
            String message = modified ? "* Changelog file '" + this.changelogFile + "' modified successfully." : "* Changelog file '" + this.changelogFile + "' was not modified.";
            Scope.getCurrentScope().getUI().sendMessage(message);
        }
        catch (IOException | LiquibaseException ioe) {
            String message = "* Changelog file '" + this.changelogFile + "' error: " + ioe.getMessage();
            Scope.getCurrentScope().getLog(AbstractChangelogRewriter.class).severe(message);
            throw new LiquibaseException(ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public abstract String handle(String var1) throws LiquibaseException;

    protected boolean writeChangelog(URI uri, String encoding, String changelogString, String newChangeLogString) throws IOException {
        if (newChangeLogString.equals(changelogString)) {
            return false;
        }
        changelogString = newChangeLogString;
        File f = new File(uri.getPath());
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(f, "rw");){
            randomAccessFile.setLength(0L);
            randomAccessFile.write(changelogString.getBytes(encoding));
        }
        return true;
    }

    protected String determinePath(String newChangeLogString) {
        if (this.includedPath != null) {
            return this.includedPath;
        }
        return this.changelogFile;
    }

    protected String getPath(DatabaseChangeLog changeLog) {
        String path = this.changelogFile;
        if (changeLog.getLogicalFilePath() != null) {
            path = changeLog.getLogicalFilePath();
        }
        return path;
    }

    protected ChangeSet getChangeSet(String author, String id) {
        ChangeSet changeSet = this.databaseChangelog.getChangeSet(this.changelogFile, author, id);
        if (changeSet == null) {
            List skippedChangeSets = this.databaseChangelog.getSkippedChangeSets();
            for (ChangeSet skipped : skippedChangeSets) {
                if (!skipped.getId().equalsIgnoreCase(id) || !skipped.getAuthor().equalsIgnoreCase(author) || !this.changelogFile.equals(skipped.getFilePath()) || this.databaseChangelog.isDbmsMatch(skipped.getDbmsSet())) continue;
                Scope.getCurrentScope().getLog(AbstractChangelogRewriter.class).info("Mismatched DBMS value for changeset '" + skipped + "'");
            }
        }
        return changeSet;
    }

    protected String createContextStringForFile(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.getContextFilter().getContexts().toString().replace("[", "").replace("]", "").replace(", ", ",");
    }

    protected void handleIncludedFile(String includePath) throws LiquibaseException {
        ChangelogRewriterFactory changelogRewriterFactory = (ChangelogRewriterFactory)Scope.getCurrentScope().getSingleton(ChangelogRewriterFactory.class);
        ChangelogRewriter changelogRewriter = changelogRewriterFactory.createChangelogRewriter(includePath, this.databaseChangelog, includePath, this.modType);
        if (changelogRewriter == null) {
            String message = String.format("Unsupported changelog type '%s'", includePath);
            Scope.getCurrentScope().getUI().sendMessage(message);
            return;
        }
        changelogRewriter.modifyChangelog();
    }

    protected String getFirstGroupValue(String stringToMatchIn, Pattern pattern) {
        Matcher matcher = pattern.matcher(stringToMatchIn);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected KeyValuePair parseKeyValuePair(String[] parts) {
        String key = parts[0].replace("\"", "").trim();
        String value = null;
        if (parts.length > 1) {
            value = parts[1].replace("\",", "").replace("\"", "").trim();
        }
        KeyValuePair kvp = new KeyValuePair();
        kvp.key = key;
        kvp.value = value;
        return kvp;
    }

    protected Comparator<String> getStandardChangeLogComparator() {
        return Comparator.comparing(o -> o.replace("WEB-INF/classes/", ""));
    }

    protected Comparator<String> getResourceComparator(String resourceComparatorDef) {
        Comparator<String> resourceComparator;
        if (resourceComparatorDef == null) {
            return this.getStandardChangeLogComparator();
        }
        try {
            resourceComparator = (Comparator<String>)Class.forName(resourceComparatorDef).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Scope.getCurrentScope().getLog(this.getClass()).info("no resourceComparator defined - taking default implementation");
            resourceComparator = this.getStandardChangeLogComparator();
        }
        return resourceComparator;
    }

    protected IncludeAllFilter getIncludeAllFilter(String resourceFilterDef) throws SetupException {
        IncludeAllFilter resourceFilter = null;
        if (resourceFilterDef != null) {
            try {
                resourceFilter = (IncludeAllFilter)Class.forName(resourceFilterDef).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new SetupException((Throwable)e);
            }
        }
        return resourceFilter;
    }

    protected void handleFoundResources(String includeAllPath, boolean errorIfMissingOrEmpty, SortedSet<Resource> resources) throws SetupException {
        if (resources.isEmpty() && errorIfMissingOrEmpty) {
            throw new SetupException("Could not find directory or directory was empty for includeAll '" + includeAllPath + "'");
        }
        try {
            for (Resource resource : resources) {
                Scope.getCurrentScope().getLog(this.getClass()).info("Handling resource: " + resource);
                this.handleIncludedFile(resource.getPath());
            }
        }
        catch (Exception e) {
            throw new SetupException((Throwable)e);
        }
    }

    protected List<Map<String, Object>> parseRootList(String changelogFile) throws ChangeLogParseException, IOException {
        Map parsedYaml;
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(YamlParser.createLoaderOptions()));
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        Resource changelog = resourceAccessor.get(changelogFile);
        if (!changelog.exists()) {
            throw new ChangeLogParseException(changelogFile + " does not exist");
        }
        String physicalChangeLogLocation = changelog.getUri().toString();
        try (InputStream changeLogStream = changelog.openInputStream();){
            parsedYaml = this.parseYamlStream(physicalChangeLogLocation, yaml, changeLogStream);
        }
        if (parsedYaml == null || parsedYaml.isEmpty()) {
            throw new ChangeLogParseException("Empty file " + physicalChangeLogLocation);
        }
        return (List)parsedYaml.get("databaseChangeLog");
    }

    protected void handleIncludes(String changelogString) throws LiquibaseException {
        try {
            List<Map<String, Object>> rootList = this.parseRootList(this.changelogFile);
            if (rootList == null) {
                return;
            }
            for (Map<String, Object> item : rootList) {
                if (!(item instanceof Map)) continue;
                Map<String, Object> map = item;
                String key = map.keySet().iterator().next();
                Map node = (Map)map.get(key);
                if (key.equals("includeAll")) {
                    this.handleResources(node);
                    continue;
                }
                if (!key.equals("include")) continue;
                String file = (String)node.get("file");
                Object nodeValue = node.get(IGNORE);
                boolean ignore = false;
                ignore = nodeValue instanceof String ? Boolean.parseBoolean((String)node.get(IGNORE)) : (Boolean)node.get(IGNORE);
                if (ignore) {
                    String message = "Ignoring include '" + file + "'";
                    Scope.getCurrentScope().getUI().sendMessage(message);
                    continue;
                }
                this.handleIncludedFile(file);
            }
        }
        catch (IOException | ChangeLogParseException e) {
            throw new LiquibaseException(e);
        }
    }

    private Map parseYamlStream(String physicalChangeLogLocation, Yaml yaml, InputStream changeLogStream) throws ChangeLogParseException {
        Map parsedYaml;
        try {
            parsedYaml = (Map)yaml.load(changeLogStream);
        }
        catch (Exception e) {
            throw new ChangeLogParseException("Syntax error in file " + physicalChangeLogLocation + ": " + e.getMessage(), (Throwable)e);
        }
        return parsedYaml;
    }

    private void handleResources(Map<String, Object> node) throws SetupException {
        String includeAllPath = (String)node.get("path");
        String ignoreString = (String)node.get(IGNORE);
        if (Boolean.parseBoolean(ignoreString)) {
            String message = "Ignoring includeAll path '" + includeAllPath + "'";
            Scope.getCurrentScope().getUI().sendMessage(message);
            return;
        }
        String resourceFilterDef = (String)node.get("filter");
        if (resourceFilterDef == null) {
            resourceFilterDef = (String)node.get("resourceFilter");
        }
        boolean isRelativeToChangelogFile = node.containsKey("relativeToChangelogFile") && (Boolean)node.get("relativeToChangelogFile") != false;
        boolean errorIfMissingOrEmpty = !node.containsKey("errorIfMissingOrEmpty") || (Boolean)node.get("errorIfMissingOrEmpty") != false;
        Comparator<String> resourceComparator = this.getStandardChangeLogComparator();
        IncludeAllFilter includeAllFilter = this.getIncludeAllFilter(resourceFilterDef);
        int minDepth = node.containsKey("minDepth") ? (Integer)node.get("minDepth") : 0;
        int maxDepth = node.containsKey("maxDepth") ? (Integer)node.get("maxDepth") : Integer.MAX_VALUE;
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        SortedSet resources = this.databaseChangelog.findResources(includeAllPath, isRelativeToChangelogFile, includeAllFilter, errorIfMissingOrEmpty, resourceComparator, resourceAccessor, minDepth, maxDepth);
        this.handleFoundResources(includeAllPath, errorIfMissingOrEmpty, resources);
    }

    protected static class KeyValuePair {
        String key;
        String value;

        protected KeyValuePair() {
        }
    }
}

