/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import java.util.Optional;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.exception.LiquibaseException;
import liquibase.logging.Logger;

public class SinglePendingChangeSetFilter
implements ChangeSetFilter {
    private final String id;
    private final String author;
    private final String filePath;

    public SinglePendingChangeSetFilter(String id, String author, String filePath, DatabaseChangeLog changelog) throws LiquibaseException {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        ChangeSet changeSet = Optional.ofNullable(changelog.getChangeSet(filePath, author, id)).orElseThrow(() -> {
            log.warning("Unable to locate the change for " + id + "::" + author + "::" + filePath);
            String message = this.createNotFoundErrorMessage(id, author, filePath);
            return new LiquibaseException(message);
        });
        this.id = changeSet.getId();
        this.author = changeSet.getAuthor();
        this.filePath = changeSet.getFilePath();
    }

    private String createNotFoundErrorMessage(String id, String author, String path) {
        return "The changeset targeted by '" + id + "::" + author + "::" + path + "' was not found. ";
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String changeSetString = changeSet.toString();
        if (this.id.equalsIgnoreCase(changeSet.getId()) && this.author.equalsIgnoreCase(changeSet.getAuthor()) && this.filePath.equals(changeSet.getFilePath())) {
            return new ChangeSetFilterResult(true, "Changeset to run is " + changeSetString, this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, "Changeset " + changeSetString + " will not execute", this.getClass(), this.getMdcName(), this.getDisplayName());
    }

    public String getMdcName() {
        return "willNotExecute";
    }

    public String getDisplayName() {
        return "Will not execute";
    }
}

