/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.output.FormattedChangelogChecksIssue;
import com.datical.liquibase.ext.checks.output.FormattedChangelogChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedChangesetValidated;
import com.datical.liquibase.ext.checks.output.FormattedCheckExecuted;
import com.datical.liquibase.ext.checks.output.FormattedCheckParameter;
import com.datical.liquibase.ext.checks.output.FormattedCheckSkipped;
import com.datical.liquibase.ext.checks.output.FormattedCheckSkippedBecauseOfScope;
import com.datical.liquibase.ext.checks.output.FormattedCheckUnrecognized;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksIssue;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksValidated;
import com.datical.liquibase.ext.checks.output.FormattedUnlicensedChangeset;
import com.datical.liquibase.ext.checks.output.FormattedUnparseableChangeset;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper;
import com.datical.liquibase.ext.command.checks.EngineResults;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import com.datical.liquibase.ext.util.EnvironmentUtils;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectCollection;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;

public class ChecksRunJsonOutputHelper {
    private ChecksRunJsonOutputHelper() {
    }

    public static FormattedChangelogChecksResultModel createChangelogJsonOutput(Map<ChangeSet, LiquibaseQualityCheckResult> results, Set<RuleCombination> executedRules, String changelogFilePath, String integration, CheckSettingsConfig config, List<RuleCombination> skippedBecauseOfLicenceRules, Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedBecauseOfScope, List<AbstractLiquibaseRule> instances, List<String> checksInChains, Integer sqlParserFailSeverity) {
        FormattedChangelogChecksResultModel changelogChecksResultModel = new FormattedChangelogChecksResultModel();
        AtomicReference<SeverityEnum> maxSeverityEnum = new AtomicReference<SeverityEnum>(SeverityEnum.INFO);
        if (results == null || results.isEmpty() || changelogFilePath == null) {
            changelogChecksResultModel.maxSeverity = maxSeverityEnum.get();
            return changelogChecksResultModel;
        }
        changelogChecksResultModel.username = EnvironmentUtils.getSystemUsername();
        changelogChecksResultModel.productVersion = LiquibaseUtil.getBuildVersionInfo();
        changelogChecksResultModel.hasProLicense = LicenseServiceUtils.isProLicenseValid();
        changelogChecksResultModel.integration = integration;
        changelogChecksResultModel.changelogFilePath = changelogFilePath;
        changelogChecksResultModel.executionDate = Instant.now().toString();
        changelogChecksResultModel.changesetsValidatedCount = results.size();
        results.forEach((changeSet, changeSetCheckResult) -> {
            FormattedChangesetValidated validated = new FormattedChangesetValidated();
            validated.author = changeSet.getAuthor();
            validated.id = changeSet.getId();
            validated.filepath = changeSet.getFilePath();
            changelogChecksResultModel.changesetsValidated.add(validated);
        });
        ChecksRunJsonOutputHelper.processUnparseableChangesets(results, changelogChecksResultModel, config);
        ChecksRunJsonOutputHelper.processUnlicensedChangesets(results, changelogChecksResultModel, skippedBecauseOfLicenceRules);
        int executedChecksCount = ChecksRunJsonOutputHelper.processExecutedChangelogChecks(executedRules, changelogChecksResultModel, instances);
        int issuesCount = ChecksRunJsonOutputHelper.processChangelogIssues(results, changelogChecksResultModel, maxSeverityEnum, sqlParserFailSeverity, checksInChains);
        ChecksRunJsonOutputHelper.processUnrecognizedChangelogRules(changelogChecksResultModel, config);
        ChecksRunJsonOutputHelper.processChangelogSkippedBecauseOfScope(changelogChecksResultModel, skippedBecauseOfScope);
        changelogChecksResultModel.issueCount = issuesCount;
        changelogChecksResultModel.executedChecksCount = executedChecksCount;
        changelogChecksResultModel.returnCode = maxSeverityEnum.get().getExitValue();
        changelogChecksResultModel.maxSeverity = maxSeverityEnum.get();
        return changelogChecksResultModel;
    }

    public static void processChangelogSkippedBecauseOfScope(FormattedChangelogChecksResultModel changelogChecksResultModel, Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedBecauseOfScope) {
        for (Map.Entry<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedRule : skippedBecauseOfScope.entrySet()) {
            if (skippedRule.getKey() == skippedRule.getValue().get(0)) continue;
            FormattedCheckSkippedBecauseOfScope formattedSkippedBecauseOfScope = ChecksRunJsonOutputHelper.createFormattedCheckSkippedBecauseOfScope(skippedRule);
            changelogChecksResultModel.skippedBecauseOfScope.add(formattedSkippedBecauseOfScope);
        }
    }

    public static FormattedDatabaseChecksResultModel createDatabaseJsonOutput(EngineResults<DatabaseObject> databaseResults, String url, LazyDatabaseSnapshot lazyDatabaseSnapshot, boolean verbose, String integration, CheckSettingsConfig config, Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedBecauseOfScope, Integer sqlParserFailSeverity, List<String> checksInChains) {
        FormattedDatabaseChecksResultModel databaseChecksResultModel = new FormattedDatabaseChecksResultModel();
        AtomicReference<SeverityEnum> maxSeverityEnum = new AtomicReference<SeverityEnum>(SeverityEnum.INFO);
        LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> results = databaseResults.getResults();
        if (results == null || results.isEmpty() && databaseResults.getSkippedBecauseOfLicenceRules().isEmpty()) {
            databaseChecksResultModel.maxSeverity = maxSeverityEnum.get();
            return databaseChecksResultModel;
        }
        databaseChecksResultModel.username = EnvironmentUtils.getSystemUsername();
        databaseChecksResultModel.productVersion = LiquibaseUtil.getBuildVersionInfo();
        databaseChecksResultModel.integration = integration;
        databaseChecksResultModel.executionDate = Instant.now().toString();
        databaseChecksResultModel.target = url;
        databaseChecksResultModel.targetType = url.startsWith("offline:") ? "snapshot" : "jdbcurl";
        databaseChecksResultModel.databaseObjectsValidatedCount = ChecksRunJsonOutputHelper.calcSnapshotObjectCount(lazyDatabaseSnapshot);
        databaseChecksResultModel.hasProLicense = LicenseServiceUtils.isProLicenseValid();
        ChecksRunJsonOutputHelper.processDatabaseChecksValidated(databaseChecksResultModel, lazyDatabaseSnapshot, verbose);
        int executedChecksCount = ChecksRunJsonOutputHelper.processExecutedDatabaseChecks(results, databaseChecksResultModel, sqlParserFailSeverity);
        int issuesCount = ChecksRunJsonOutputHelper.processDatabaseIssues(results, databaseChecksResultModel, maxSeverityEnum, sqlParserFailSeverity, checksInChains);
        ChecksRunJsonOutputHelper.processUnrecognizedDatabaseRules(databaseChecksResultModel, config);
        ChecksRunJsonOutputHelper.processDatabaseSkippedBecauseOfScope(databaseChecksResultModel, skippedBecauseOfScope);
        databaseChecksResultModel.issueCount = issuesCount;
        databaseChecksResultModel.executedChecksCount = executedChecksCount;
        databaseChecksResultModel.returnCode = maxSeverityEnum.get().getExitValue();
        databaseChecksResultModel.maxSeverity = maxSeverityEnum.get();
        return databaseChecksResultModel;
    }

    public static void processDatabaseSkippedBecauseOfScope(FormattedDatabaseChecksResultModel databaseChecksResultModel, Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedBecauseOfScope) {
        for (Map.Entry<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedRule : skippedBecauseOfScope.entrySet()) {
            FormattedCheckSkippedBecauseOfScope formattedSkippedBecauseOfScope = ChecksRunJsonOutputHelper.createFormattedCheckSkippedBecauseOfScope(skippedRule);
            databaseChecksResultModel.skippedBecauseOfScope.add(formattedSkippedBecauseOfScope);
        }
    }

    public static void processDatabaseChecksValidated(FormattedDatabaseChecksResultModel databaseChecksResultModel, LazyDatabaseSnapshot lazyDatabaseSnapshot, boolean verbose) {
        try {
            Set typesSet = lazyDatabaseSnapshot.getSnapshot().getSnapshotControl().getTypesToInclude();
            ArrayList typesToInclude = new ArrayList(typesSet);
            Collections.sort(typesToInclude, new ChecksRunConsoleOutputHelper.DatabaseObjectTypeSortComparator());
            for (Class includeType : typesToInclude) {
                Set databaseObjectsSet = lazyDatabaseSnapshot.getSnapshot().get(includeType);
                if (databaseObjectsSet.isEmpty()) continue;
                String objectTypeName = includeType.getSimpleName();
                FormattedDatabaseChecksValidated validated = new FormattedDatabaseChecksValidated();
                validated.objecttype = StringUtil.upperCaseFirst((String)objectTypeName);
                validated.count = databaseObjectsSet.size();
                if (verbose) {
                    Database database = lazyDatabaseSnapshot.getDatabase();
                    ArrayList databaseObjects = new ArrayList(databaseObjectsSet);
                    Collections.sort(databaseObjects, new ChecksRunConsoleOutputHelper.DatabaseObjectSortComparator());
                    for (DatabaseObject databaseObject : databaseObjects) {
                        if (database.isLiquibaseObject(databaseObject)) {
                            --validated.count;
                            continue;
                        }
                        validated.objects.add(DatabaseObjectUtils.buildFullyQualifiedName(databaseObject));
                    }
                }
                databaseChecksResultModel.databaseObjectsValidated.add(validated);
            }
        }
        catch (CommandExecutionException cee) {
            throw new UnexpectedLiquibaseException((Throwable)cee);
        }
    }

    private static FormattedCheckSkippedBecauseOfScope createFormattedCheckSkippedBecauseOfScope(Map.Entry<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedRule) {
        FormattedCheckSkippedBecauseOfScope formattedSkippedBecauseOfScope = new FormattedCheckSkippedBecauseOfScope();
        formattedSkippedBecauseOfScope.name = skippedRule.getKey().getName();
        formattedSkippedBecauseOfScope.shortName = skippedRule.getKey().getShortName();
        formattedSkippedBecauseOfScope.logicConditional = (String)((DynamicRule)skippedRule.getKey()).getParameter(DynamicRuleParameterEnum.LOGIC_CONDITIONAL).getValue();
        List skippedRuleNames = skippedRule.getValue().stream().map(AbstractConfigurableRule::getShortName).collect(Collectors.toList());
        formattedSkippedBecauseOfScope.skippedChecks.addAll(skippedRuleNames);
        return formattedSkippedBecauseOfScope;
    }

    private static int calcSnapshotObjectCount(LazyDatabaseSnapshot lazyDatabaseSnapshot) {
        DatabaseSnapshot snapshot = null;
        try {
            snapshot = lazyDatabaseSnapshot.getSnapshot();
        }
        catch (CommandExecutionException cee) {
            Scope.getCurrentScope().getLog(ChecksRunJsonOutputHelper.class).warning("Unable to get snapshot count of database objects: " + cee.getMessage());
            return 0;
        }
        int snapshotObjectCount = 0;
        DatabaseObjectCollection objectCollection = (DatabaseObjectCollection)snapshot.getSerializableFieldValue("objects");
        Map map = objectCollection.toMap();
        for (Class type : map.keySet()) {
            snapshotObjectCount += objectCollection.get(type).size();
        }
        return snapshotObjectCount;
    }

    private static void processUnlicensedChangesets(Map<ChangeSet, LiquibaseQualityCheckResult> results, FormattedChangelogChecksResultModel checksResultModel, List<RuleCombination> skippedBecauseOfLicenceRules) {
        Map<ChangeSet, LiquibaseQualityCheckResult> unlicensedChangesetResults = ChecksRunJsonOutputHelper.getUnlicensedChangeSetResults(results, skippedBecauseOfLicenceRules);
        checksResultModel.unlicensedChangesetsCount = unlicensedChangesetResults.size();
        for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> unlicensed : unlicensedChangesetResults.entrySet()) {
            ChangeSet changeSet = unlicensed.getKey();
            LiquibaseQualityCheckResult checkResult = unlicensed.getValue();
            FormattedUnlicensedChangeset unlicensedChangeset = new FormattedUnlicensedChangeset();
            unlicensedChangeset.changesetId = changeSet.getId();
            for (RuleCombination skippedRule : skippedBecauseOfLicenceRules) {
                FormattedCheckSkipped skippedCheck = new FormattedCheckSkipped();
                String checkName = skippedRule.rule.getName();
                String shortCheckName = null;
                if (skippedRule.rule instanceof DynamicRule) {
                    shortCheckName = ((DynamicRule)skippedRule.configurableRule).getShortName();
                }
                skippedCheck.checkName = checkName;
                skippedCheck.checkShortName = shortCheckName != null ? shortCheckName.replace("(", "").replace(")", "").trim() : null;
                unlicensedChangeset.skipped.add(skippedCheck);
            }
            checksResultModel.unlicensedChangesets.add(unlicensedChangeset);
        }
    }

    private static void processUnrecognizedDatabaseRules(FormattedDatabaseChecksResultModel checksResultModel, CheckSettingsConfig config) {
        List<AbstractConfigurableRule> unrecognizedRules = config.getUnrecognizedRules();
        for (AbstractConfigurableRule unknownRule : unrecognizedRules) {
            FormattedCheckUnrecognized unrecognized = new FormattedCheckUnrecognized();
            if (unknownRule.isConfigurable()) {
                unrecognized.checkShortName = ((DynamicRule)unknownRule).getShortName();
                unrecognized.checkShortName = unrecognized.checkShortName != null ? unrecognized.checkShortName.replace("(", "").replace(")", "").trim() : null;
            }
            unrecognized.checkId = unknownRule.getId().toString();
            checksResultModel.unrecognizedChecks.add(unrecognized);
        }
    }

    private static void processUnrecognizedChangelogRules(FormattedChangelogChecksResultModel checksResultModel, CheckSettingsConfig config) {
        List<AbstractConfigurableRule> unrecognizedRules = config.getUnrecognizedRules();
        for (AbstractConfigurableRule unknownRule : unrecognizedRules) {
            FormattedCheckUnrecognized unrecognized = new FormattedCheckUnrecognized();
            if (unknownRule.isConfigurable()) {
                unrecognized.checkShortName = ((DynamicRule)unknownRule).getShortName();
                unrecognized.checkShortName = unrecognized.checkShortName != null ? unrecognized.checkShortName.replace("(", "").replace(")", "").trim() : null;
            }
            unrecognized.checkId = unknownRule.getId().toString();
            checksResultModel.unrecognizedChecks.add(unrecognized);
        }
    }

    private static int processDatabaseIssues(Map<DatabaseObject, LiquibaseQualityCheckResult> results, FormattedDatabaseChecksResultModel checksResultModel, AtomicReference<SeverityEnum> maxSeverityEnum, Integer sqlParserFailSeverity, List<String> checksInChains) {
        int issuesCount = 0;
        for (Map.Entry<DatabaseObject, LiquibaseQualityCheckResult> resultEntry : results.entrySet()) {
            DatabaseObject databaseObject = resultEntry.getKey();
            List<LiquibaseRuleResult> ruleResults = resultEntry.getValue().getRuleResults();
            for (LiquibaseRuleResult ruleResult : ruleResults) {
                String shortName;
                if (ruleResult.hasRuleSucceeded() || ChecksRunJsonOutputHelper.isPartOfAChain(shortName = ruleResult.getRuleShortName().replace("(", "").replace(")", "").trim(), checksInChains)) continue;
                for (RuleIteration ruleIteration : ruleResult.getExecutions()) {
                    ++issuesCount;
                    String logicConditional = ChecksRunJsonOutputHelper.getLogicConditional(ruleResult);
                    FormattedDatabaseChecksIssue issue = new FormattedDatabaseChecksIssue();
                    issue.databaseObjectName = databaseObject.getName();
                    issue.databaseObjectType = databaseObject.getObjectTypeName();
                    issue.databaseObjectLocation = DatabaseObjectUtils.buildFullyQualifiedName(databaseObject);
                    issue.checkName = ruleResult.getRule().getName();
                    SeverityEnum severityEnum = ruleResult.getRuleSeverity(sqlParserFailSeverity);
                    issue.checkSeverity = severityEnum.toString();
                    issue.checkReturnCode = ruleResult.getRuleExitValue(sqlParserFailSeverity);
                    if (severityEnum.getValue() > maxSeverityEnum.get().getValue()) {
                        maxSeverityEnum.set(severityEnum);
                    }
                    issue.checkShortName = shortName;
                    issue.checkMessage = StringUtil.join(ruleIteration.getMessages(), (String)",");
                    if (logicConditional != null) {
                        issue.logicConditional = logicConditional;
                    }
                    if (ruleIteration.getCheckRuleResults() != null) {
                        issue.chainedCheckOutcomes = ruleIteration.getCheckRuleResults();
                    }
                    checksResultModel.issues.add(issue);
                }
            }
        }
        return issuesCount;
    }

    private static int processChangelogIssues(Map<ChangeSet, LiquibaseQualityCheckResult> results, FormattedChangelogChecksResultModel checksResultModel, AtomicReference<SeverityEnum> maxSeverityEnum, Integer sqlParserFailSeverity, List<String> checksInChains) {
        int issuesCount = 0;
        for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> resultEntry : results.entrySet()) {
            ChangeSet changeSet = resultEntry.getKey();
            List<LiquibaseRuleResult> ruleResults = resultEntry.getValue().getRuleResults();
            for (LiquibaseRuleResult ruleResult : ruleResults) {
                String shortName = ruleResult.getRuleShortName().replace("(", "").replace(")", "").trim();
                if (ruleResult.hasRuleSucceeded() || ChecksRunJsonOutputHelper.isPartOfAChain(shortName, checksInChains)) continue;
                for (RuleIteration ruleIteration : ruleResult.getExecutions()) {
                    if (ruleIteration.isSuccess() || ruleIteration.getMessages().isEmpty()) continue;
                    ++issuesCount;
                    String logicConditional = ChecksRunJsonOutputHelper.getLogicConditional(ruleResult);
                    FormattedChangelogChecksIssue issue = new FormattedChangelogChecksIssue();
                    issue.changesetAuthor = changeSet.getAuthor();
                    issue.changesetId = changeSet.getId();
                    issue.changesetFilePath = changeSet.getFilePath();
                    issue.checkName = ruleResult.getRule().getName();
                    SeverityEnum severityEnum = ruleResult.getRuleSeverity(sqlParserFailSeverity);
                    issue.checkSeverity = severityEnum.toString();
                    issue.checkReturnCode = severityEnum.getExitValue();
                    if (severityEnum.getValue() > maxSeverityEnum.get().getValue()) {
                        maxSeverityEnum.set(severityEnum);
                    }
                    issue.checkShortName = shortName;
                    issue.checkMessage = StringUtil.join(ruleIteration.getMessages(), (String)",");
                    if (logicConditional != null) {
                        issue.logicConditional = logicConditional;
                    }
                    if (ruleIteration.getCheckRuleResults() != null) {
                        issue.chainedCheckOutcomes = ruleIteration.getCheckRuleResults();
                    }
                    checksResultModel.issues.add(issue);
                }
            }
        }
        return issuesCount;
    }

    public static String getLogicConditional(LiquibaseRuleResult ruleResult) {
        DynamicRule dr;
        String logicConditional = "";
        AbstractConfigurableRule cr = ruleResult.getConfigurableRule();
        if (cr instanceof DynamicRule && (dr = (DynamicRule)cr).getParameter(DynamicRuleParameterEnum.LOGIC_CONDITIONAL) != null) {
            logicConditional = (String)dr.getParameterValue(DynamicRuleParameterEnum.LOGIC_CONDITIONAL);
        }
        return logicConditional;
    }

    public static boolean isPartOfAChain(String shortName, List<String> checksInChains) {
        return checksInChains.stream().anyMatch(c -> c.equalsIgnoreCase(shortName));
    }

    private static int processExecutedDatabaseChecks(Map<DatabaseObject, LiquibaseQualityCheckResult> results, FormattedDatabaseChecksResultModel checksResultModel, Integer sqlParserFailSeverity) {
        LinkedHashSet executedRuleNames = new LinkedHashSet();
        results.forEach((changeSet, changeSetCheckResult) -> {
            for (LiquibaseRuleResult ruleResult : changeSetCheckResult.getRuleResults()) {
                AbstractConfigurableRule configuredRule;
                if (executedRuleNames.contains(ruleResult.getRuleShortName())) continue;
                executedRuleNames.add(ruleResult.getRuleShortName());
                FormattedCheckExecuted executed = new FormattedCheckExecuted();
                executed.checkName = ruleResult.getRule().getName();
                executed.checkShortName = ruleResult.getRuleShortName().replace("(", "").replace(")", "").trim();
                executed.description = ruleResult.getRule().getDescription();
                executed.severity = ruleResult.getRuleSeverity(sqlParserFailSeverity).toString();
                executed.enabled = true;
                if (ruleResult.getConfigurableRule() != null && (configuredRule = ruleResult.getConfigurableRule()) instanceof DynamicRule) {
                    DynamicRule dynamicRule = (DynamicRule)configuredRule;
                    executed.enabled = dynamicRule.isEnabled();
                    FormattedCheckParameter parameter = new FormattedCheckParameter();
                    dynamicRule.getParameters().forEach(p -> ChecksRunJsonOutputHelper.setParamValueInModel(parameter, p));
                    executed.customizations.add(parameter);
                }
                checksResultModel.executedChecks.add(executed);
            }
        });
        return executedRuleNames.size();
    }

    private static int processExecutedChangelogChecks(Set<RuleCombination> executedRules, FormattedChangelogChecksResultModel checksResultModel, List<AbstractLiquibaseRule> instances) {
        for (RuleCombination ruleCombination : executedRules) {
            Rule rule = ruleCombination.rule;
            AbstractConfigurableRule configurableRule = ruleCombination.configurableRule;
            FormattedCheckExecuted executed = new FormattedCheckExecuted();
            executed.checkName = rule.getName();
            executed.checkShortName = configurableRule.getShortName(instances);
            executed.description = rule.getDescription();
            executed.severity = Integer.toString(configurableRule.getSeverity().getExitValue());
            executed.enabled = true;
            if (configurableRule instanceof DynamicRule) {
                DynamicRule dynamicRule = (DynamicRule)configurableRule;
                executed.enabled = dynamicRule.isEnabled();
                FormattedCheckParameter parameter = new FormattedCheckParameter();
                dynamicRule.getParameters().forEach(p -> ChecksRunJsonOutputHelper.setParamValueInModel(parameter, p));
                executed.customizations.add(parameter);
            }
            checksResultModel.executedChecks.add(executed);
        }
        return executedRules.size();
    }

    private static void processUnparseableChangesets(Map<ChangeSet, LiquibaseQualityCheckResult> results, FormattedChangelogChecksResultModel checksResultModel, CheckSettingsConfig config) {
        Map<ChangeSet, LiquibaseQualityCheckResult> unparseableChangeSetResults = ChecksRunJsonOutputHelper.getUnparseableChangeSetResultsWithoutMessage(results);
        checksResultModel.unparseableChangesetsCount = unparseableChangeSetResults.size();
        for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> unparseable : unparseableChangeSetResults.entrySet()) {
            ChangeSet changeSet = unparseable.getKey();
            LiquibaseQualityCheckResult checkResult = unparseable.getValue();
            FormattedUnparseableChangeset unparseableChangeset = new FormattedUnparseableChangeset();
            unparseableChangeset.changesetId = changeSet.getId();
            for (String skippedRuleName : checkResult.getRuleNamesSkippedDueToUnparseableSql()) {
                FormattedCheckSkipped skippedCheck = new FormattedCheckSkipped();
                skippedCheck.checkShortName = skippedRuleName != null ? skippedRuleName : "";
                DynamicRule dynamicRule = config.getDynamicRuleByShortName(skippedRuleName);
                skippedCheck.checkName = dynamicRule != null ? dynamicRule.getName() : "";
                unparseableChangeset.skipped.add(skippedCheck);
            }
            checksResultModel.unparseableChangesets.add(unparseableChangeset);
        }
    }

    private static void setParamValueInModel(FormattedCheckParameter parameter, DynamicRuleParameter p) {
        String param = p.getParameter();
        Field[] fields = FormattedCheckParameter.class.getFields();
        Field field = Arrays.stream(fields).filter(f -> f.getName().equalsIgnoreCase(param.replace("_", ""))).findFirst().orElse(null);
        if (field != null) {
            try {
                field.set((Object)parameter, p.getValue());
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).warning("Unable to set parameter value for " + field.getName());
            }
        }
    }

    private static Map<ChangeSet, LiquibaseQualityCheckResult> getUnparseableChangeSetResultsWithoutMessage(Map<ChangeSet, LiquibaseQualityCheckResult> results) {
        return results.entrySet().stream().filter(e -> !((LiquibaseQualityCheckResult)e.getValue()).getRuleNamesSkippedDueToUnparseableSql().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
    }

    private static Map<ChangeSet, LiquibaseQualityCheckResult> getUnlicensedChangeSetResults(Map<ChangeSet, LiquibaseQualityCheckResult> results, List<RuleCombination> skippedBecauseOfLicenceRules) {
        return results.entrySet().stream().filter(e -> !skippedBecauseOfLicenceRules.isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
    }
}

