/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.AbstractArgumentCommandStep;

public class RollbackOnErrorArgument
extends AbstractArgumentCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"rollbackOnError"};
    public static final CommandArgumentDefinition<Boolean> ROLLBACK_ON_ERROR_ARG;
    private static final String ROLLBACK_ON_ERROR_ARG_NAME = "rollbackOnError";
    private static final String ROLLBACK_ON_ERROR_ARG_DESCRIPTION = "If set to true and any changeset in a deployment fails, then the update operation stops, and liquibase attempts to rollback all changesets just deployed. A changeset marked \"fail-on-error=false\" does not trigger as an error, therefore rollback-on-error will not occur. Additionally, if a changeset is not auto-rollback compliant or does not have a rollback script, then no rollback-on-error will occur for any changeset.";

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(RollbackOnErrorArgument.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        boolean rollbackOnError = (Boolean)commandScope.getArgumentValue(ROLLBACK_ON_ERROR_ARG);
        Scope.getCurrentScope().addMdcValue(ROLLBACK_ON_ERROR_ARG_NAME, String.valueOf(rollbackOnError));
        commandScope.provideDependency(RollbackOnErrorArgument.class, (Object)rollbackOnError);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        ROLLBACK_ON_ERROR_ARG = builder.argument(ROLLBACK_ON_ERROR_ARG_NAME, Boolean.class).description(ROLLBACK_ON_ERROR_ARG_DESCRIPTION).defaultValue((Object)false).build();
    }
}

