/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.reports.ReportFormat;
import com.datical.liquibase.ext.util.EnvironmentUtils;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.awt.GraphicsEnvironment;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import liquibase.Scope;
import liquibase.license.LicenseServiceUtils;
import lombok.Generated;

public class ReportArguments {
    public Boolean enabled;
    public String name;
    public String path;
    public ReportFormat format;
    public boolean nameSetGlobally;
    public boolean pathSetGlobally;
    public boolean formatSetGlobally;

    public String buildReportDateFormat(LocalDateTime time) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd-MMM-yyyy-HHmmss");
        return dateFormatter.format(time);
    }

    public boolean ignoreReport() {
        boolean shouldPrintReportNotCreatedMessage;
        boolean bl = shouldPrintReportNotCreatedMessage = Boolean.FALSE.equals(this.enabled) && LicenseServiceUtils.isProLicenseValid() && Boolean.FALSE.equals(ReportConfiguration.QUIET.getCurrentValue());
        if (shouldPrintReportNotCreatedMessage) {
            this.printReportNotCreatedMessage();
            return true;
        }
        if (!LicenseServiceUtils.isProLicenseValid() || Boolean.FALSE.equals(this.enabled)) {
            String reason = !LicenseServiceUtils.isProLicenseValid() ? "invalid license" : "reporting is disabled";
            Scope.getCurrentScope().getLog(this.getClass()).fine(String.format("Ignoring report generation: %s", reason));
            return true;
        }
        return false;
    }

    private void printReportNotCreatedMessage() {
        if (!GraphicsEnvironment.isHeadless()) {
            String command = ProStringUtil.buildCLICommandName(EnvironmentUtils.findCommandName());
            String commandName = EnvironmentUtils.findCommandName();
            String message = String.format("A Pro %s Report was not created!\n** To generate a %s report add command arg 'liquibase %s --report-enabled=true'\n** To generate all available Pro reports set liquibase.reports.enabled=true, or LIQUIBASE_REPORTS_ENABLED=true", commandName, commandName, command);
            Scope.getCurrentScope().getLog(this.getClass()).info(message);
            Scope.getCurrentScope().getUI().sendMessage(message);
        }
    }

    @Generated
    public ReportArguments(Boolean enabled, String name, String path, ReportFormat format, boolean nameSetGlobally, boolean pathSetGlobally, boolean formatSetGlobally) {
        this.enabled = enabled;
        this.name = name;
        this.path = path;
        this.format = format;
        this.nameSetGlobally = nameSetGlobally;
        this.pathSetGlobally = pathSetGlobally;
        this.formatSetGlobally = formatSetGlobally;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public ReportFormat getFormat() {
        return this.format;
    }

    @Generated
    public boolean isNameSetGlobally() {
        return this.nameSetGlobally;
    }

    @Generated
    public boolean isPathSetGlobally() {
        return this.pathSetGlobally;
    }

    @Generated
    public boolean isFormatSetGlobally() {
        return this.formatSetGlobally;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }
}

