/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.api;

import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.core.RuleProxy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Rules
implements Iterable<Rule> {
    private Set<Rule> rules = new TreeSet<Rule>();

    public Rules(Set<Rule> rules) {
        this.rules = new TreeSet<Rule>(rules);
    }

    public Rules(Rule ... rules) {
        Collections.addAll(this.rules, rules);
    }

    public Rules(Object ... rules) {
        this.register(rules);
    }

    public void register(Object ... rules) {
        Objects.requireNonNull(rules);
        for (Object rule : rules) {
            Objects.requireNonNull(rule);
            this.rules.add(RuleProxy.asRule(rule));
        }
    }

    public void unregister(Object ... rules) {
        Objects.requireNonNull(rules);
        for (Object rule : rules) {
            Objects.requireNonNull(rule);
            this.rules.remove(RuleProxy.asRule(rule));
        }
    }

    public void unregister(String ruleName) {
        Objects.requireNonNull(ruleName);
        Rule rule = this.findRuleByName(ruleName);
        if (rule != null) {
            this.unregister(rule);
        }
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public void clear() {
        this.rules.clear();
    }

    public int size() {
        return this.rules.size();
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    private Rule findRuleByName(String ruleName) {
        return this.rules.stream().filter(rule -> rule.getName().equalsIgnoreCase(ruleName)).findFirst().orElse(null);
    }
}

