/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.AddCheckConstraintStatement;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DisableCheckConstraintStatement;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class AddCheckConstraintGenerator
extends AbstractSqlGenerator<AddCheckConstraintStatement> {
    public boolean supports(AddCheckConstraintStatement statement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase && ((MySQLDatabase)database).isMinimumMySQLVersion("8.0.16") || database instanceof AbstractDb2Database || database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(AddCheckConstraintStatement addCheckConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("constraintBody", (Object)addCheckConstraintStatement.getConstraintBody());
        validationErrors.checkRequiredField("constraintName", (Object)addCheckConstraintStatement.getConstraintName());
        validationErrors.checkRequiredField("tableName", (Object)addCheckConstraintStatement.getTableName());
        return validationErrors;
    }

    public Sql[] generateSql(AddCheckConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        String sql = String.format("ALTER TABLE %s ADD CONSTRAINT %s CHECK (%s)", database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()), database.escapeConstraintName(statement.getConstraintName()), statement.getConstraintBody());
        if (database instanceof OracleDatabase) {
            sql = sql + (statement.isDisabled() ? " DISABLE " : "");
            sql = sql + (!statement.isValidate() && !statement.isDisabled() ? " ENABLE NOVALIDATE " : "");
        }
        returnList.add(new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedCheckConstraint(statement)}));
        if (statement.isDisabled() && !(database instanceof OracleDatabase)) {
            DisableCheckConstraintStatement disableCheckConstraintStatement = new DisableCheckConstraintStatement(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getConstraintName());
            returnList.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql((SqlStatement)disableCheckConstraintStatement, database)));
        }
        return returnList.toArray(new Sql[returnList.size()]);
    }

    protected CheckConstraint getAffectedCheckConstraint(AddCheckConstraintStatement statement) {
        CheckConstraint checkConstraint = new CheckConstraint().setName(statement.getConstraintName()).setTable((Table)new Table().setName(statement.getTableName()).setSchema(statement.getCatalogName(), statement.getSchemaName()));
        return checkConstraint;
    }
}

