/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import java.util.Arrays;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class DropValidator
extends AbstractValidator<Drop> {
    @Override
    public void validate(Drop drop) {
        String type = drop.getType();
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.drop);
            this.validateFeature(c, NamedObject.table.name().equalsIgnoreCase(type), Feature.dropTable);
            this.validateFeature(c, NamedObject.index.equalsIgnoreCase(type), Feature.dropIndex);
            this.validateFeature(c, NamedObject.view.equalsIgnoreCase(type), Feature.dropView);
            this.validateFeature(c, NamedObject.schema.equalsIgnoreCase(type), Feature.dropSchema);
            this.validateFeature(c, NamedObject.sequence.equalsIgnoreCase(type), Feature.dropSequence);
            this.validateFeature(c, drop.isIfExists() && NamedObject.table.name().equalsIgnoreCase(type), Feature.dropTableIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.index.equalsIgnoreCase(type), Feature.dropIndexIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.view.equalsIgnoreCase(type), Feature.dropViewIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.schema.equalsIgnoreCase(type), Feature.dropSchemaIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.sequence.equalsIgnoreCase(type), Feature.dropSequenceIfExists);
        }
        NamedObject named = NamedObject.forName(type);
        if (Arrays.asList(NamedObject.table, NamedObject.view).contains((Object)named)) {
            this.validateName(named, drop.getName().getFullyQualifiedName());
        }
    }
}

