/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public class JsonChangelogRewriter
extends AbstractChangelogRewriter {
    public static final String CONTEXT = "context";
    public static final String CONTEXT_FILTER = "contextFilter";
    public static final String LABELS = "labels";
    public static final String AUTHOR = "author";
    public static final String ID = "id";
    public static final String CHANGES = "changes";
    public static final String CHANGE_SET = "\"changeSet\":";
    public static final String LABELS_REPLACEMENT = "\"labels\": ";
    public static final String CONTEXT_REPLACEMENT = "\"context\": ";

    @Override
    public boolean supports(String path) {
        return path.toLowerCase().endsWith(".json");
    }

    @Override
    public String handle(String changelogString) throws LiquibaseException {
        StringBuilder newChangeLogString = new StringBuilder();
        String[] lines = changelogString.replace("\r\n", "\n").split("\n");
        boolean changeSetFound = false;
        String id = null;
        String author = null;
        boolean hasLabels = false;
        boolean hasContexts = false;
        String previousLine = null;
        for (String line : lines) {
            if (line.isEmpty()) {
                newChangeLogString.append(line);
                newChangeLogString.append(System.lineSeparator());
                continue;
            }
            if (line.contains(CHANGES) && changeSetFound) {
                this.handleAddToJson(newChangeLogString, id, author, hasLabels, hasContexts, previousLine);
                changeSetFound = false;
                hasLabels = false;
                hasContexts = false;
            } else if (changeSetFound) {
                String message;
                ChangeSet changeSet;
                String[] parts = line.split(":");
                AbstractChangelogRewriter.KeyValuePair kvp = this.parseKeyValuePair(parts);
                if (kvp.key.equals(ID)) {
                    id = kvp.value;
                } else if (kvp.key.equals(AUTHOR)) {
                    author = kvp.value;
                } else if (this.modType == ChangelogRewriter.MOD_TYPE.LABELS && kvp.key.equals(LABELS)) {
                    changeSet = this.getChangeSet(author, id);
                    if (changeSet != null) {
                        if (changeSet.isIgnore()) {
                            message = "Ignoring changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(message);
                            changeSetFound = false;
                            hasLabels = false;
                        } else if (!this.databaseChangelog.isDbmsMatch(changeSet.getDbmsSet())) {
                            message = "Mismatched DBMS for changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(message);
                            changeSetFound = false;
                            hasLabels = false;
                        } else if (parts.length > 1) {
                            line = this.rewriteLabelsJSON(line, parts[1], kvp.value, changeSet);
                            hasLabels = true;
                        }
                    } else {
                        changeSetFound = false;
                        hasLabels = false;
                    }
                    id = null;
                    author = null;
                } else if (this.modType == ChangelogRewriter.MOD_TYPE.CONTEXTS && (kvp.key.startsWith(CONTEXT) || kvp.key.startsWith(CONTEXT_FILTER))) {
                    changeSet = this.getChangeSet(author, id);
                    if (changeSet != null) {
                        if (changeSet.isIgnore()) {
                            message = "Ignoring changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(message);
                            changeSetFound = false;
                            hasContexts = false;
                        } else if (!this.databaseChangelog.isDbmsMatch(changeSet.getDbmsSet())) {
                            message = "Mismatched DBMS for changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(message);
                            changeSetFound = false;
                            hasContexts = false;
                        } else if (parts.length > 1) {
                            line = this.rewriteContextsJSON(line, parts[1], kvp.value, changeSet);
                            hasContexts = true;
                        }
                    } else {
                        changeSetFound = false;
                        hasContexts = false;
                    }
                    id = null;
                    author = null;
                }
            } else if (line.contains(CHANGE_SET)) {
                changeSetFound = true;
            }
            newChangeLogString.append(line);
            newChangeLogString.append(System.lineSeparator());
            previousLine = line;
        }
        this.handleIncludes(newChangeLogString.toString());
        return newChangeLogString.toString();
    }

    private void handleAddToJson(StringBuilder newChangeLogString, String id, String author, boolean hasLabels, boolean hasContexts, String line) {
        if (this.modType == ChangelogRewriter.MOD_TYPE.LABELS && !hasLabels) {
            this.addNewLabelsLineToJson(newChangeLogString, id, author, line);
        } else if (this.modType == ChangelogRewriter.MOD_TYPE.CONTEXTS && !hasContexts) {
            this.addNewContextsLineToJson(newChangeLogString, id, author, line);
        }
    }

    private void addNewLabelsLineToJson(StringBuilder newChangeLogString, String id, String author, String line) {
        ChangeSet changeSet = this.getChangeSet(author, id);
        if (changeSet != null && changeSet.getLabels() != null) {
            String[] parts = line.split(":");
            String newLabelsLine = parts[0].replaceFirst("\"(.*)\"", LABELS_REPLACEMENT) + "\"" + changeSet.getLabels() + "\",";
            newChangeLogString.append(newLabelsLine);
            newChangeLogString.append(System.lineSeparator());
        }
    }

    private void addNewContextsLineToJson(StringBuilder newChangeLogString, String id, String author, String line) {
        ChangeSet changeSet = this.getChangeSet(author, id);
        String contextStringForFile = this.createContextStringForFile(changeSet);
        if (changeSet != null && StringUtil.isNotEmpty((String)contextStringForFile)) {
            String[] parts = line.split(":");
            String newContextsLine = parts[0].replaceFirst("\"(.*)\"", CONTEXT_REPLACEMENT) + "\"" + contextStringForFile + "\",";
            newChangeLogString.append(newContextsLine);
            newChangeLogString.append(System.lineSeparator());
        }
    }

    private String rewriteContextsJSON(String line, String toReplace, String existingValue, ChangeSet changeSet) {
        String contextStringForFile = this.createContextStringForFile(changeSet);
        if (changeSet != null && StringUtil.isNotEmpty((String)contextStringForFile) && !existingValue.equals(contextStringForFile)) {
            line = line.replace(":" + toReplace, ": \"" + contextStringForFile + "\",");
        }
        return line;
    }

    private String rewriteLabelsJSON(String line, String toReplace, String existingValue, ChangeSet changeSet) {
        String newLabels;
        if (changeSet != null && changeSet.getLabels() != null && StringUtil.isNotEmpty((String)(newLabels = changeSet.getLabels().toString())) && !existingValue.equals(newLabels)) {
            line = line.replace(":" + toReplace, ": \"" + newLabels + "\",");
        }
        return line;
    }
}

