/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.RollbackOneChangesetCommandStep;
import com.datical.liquibase.ext.command.helpers.RollbackOnErrorArgument;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DbmsTargetedChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.report.UpdateReportParameters;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;

public class InternalRollbackOnErrorCommandStep
extends AbstractCommandStep {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    private static final String CHANGE_SET_DOES_NOT_SUPPORT_ROLLBACK_ERROR_MESSAGE = "ERROR: There was an error with changeset '%s' by author '%s' in file '%s'. The --rollback-on-error flag was set, but at least one changeset in this deployment does not contain a rollback so no changeset in this deployment will be auto-rolled back.";
    private static final String ROLLBACK_ON_ERROR_WILL_BE_EXECUTED = "ERROR: There was an error with changeset '%s' by author '%s' in file '%s'. The --rollback-on-error flag was set, so all changes from this deployment will be rolled back.";
    private static final String NO_CHANGE_SETS_TO_ROLLBACK = "ERROR: There was an error with changeset '%s' by author '%s' in file '%s'. The --rollback-on-error flag was set, but no deployed changesets to rollback were found.";
    private static final String PARTIAL_CHANGE_SETS_TO_ROLLBACK = "INFO: Incomplete deployment detected from changeset '%s' by author '%s' in file '%s'. Rolling back deployed changes from this changeset.";
    private static final String PARTIAL_CHANGE_SETS_TO_ROLLBACK_COMPLETE = "INFO: Successfully rolled back changes from the incomplete deployment.";
    private static final String ROLLBACK_ON_ERROR_COMPLETE = "ERROR: Liquibase operation encountered an error during deployment from changelog %s, and rollback-on-error is set to true. Changes have been rolled back successfully!";
    public static final String[] COMMAND_NAME = new String[]{"internalRollbackOnError"};
    public static final CommandArgumentDefinition<Boolean> ROLLBACK_ON_ERROR_ARG;
    public static final CommandArgumentDefinition<LiquibaseException> EXCEPTION_ARG;
    public static final CommandArgumentDefinition<DefaultChangeExecListener> LISTENER;
    public static final CommandArgumentDefinition<UpdateReportParameters> UPDATE_REPORT_PARAMETERS_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    public List<Class<?>> requiredDependencies() {
        return Collections.singletonList(Database.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        CommandScope commandScope = resultsBuilder.getCommandScope();
        LiquibaseException maybeMigrationException = (LiquibaseException)((Object)commandScope.getConfiguredValue(EXCEPTION_ARG).getValue());
        boolean rollbackOnError = this.findRollbackOnErrorArg(commandScope);
        UpdateReportParameters updateReport = (UpdateReportParameters)commandScope.getConfiguredValue(UPDATE_REPORT_PARAMETERS_ARG).getValue();
        if (!(maybeMigrationException.getCause() instanceof MigrationFailedException) || !rollbackOnError) {
            throw maybeMigrationException;
        }
        if (!LicenseServiceUtils.isProLicenseValid()) {
            throw new CommandValidationException(String.format("Using 'rollback-on-error' requires a valid Liquibase Pro or Labs license. Get a free license key at %s.", "https://liquibase.com/trial"), (Throwable)maybeMigrationException);
        }
        Database database = (Database)commandScope.getDependency(Database.class);
        DefaultChangeExecListener listener = (DefaultChangeExecListener)commandScope.getConfiguredValue(LISTENER).getValue();
        ChangeSet failedChangeSet = (ChangeSet)listener.getFailedChangeSets().stream().findFirst().orElseThrow(() -> new LiquibaseException("Failed changeset not found."));
        List deployedChangesFromFailedChangeSet = listener.getDeployedChanges(failedChangeSet);
        List changeSetsToRollback = listener.getDeployedChangeSets();
        ChangeLogParameters changeLogParameters = new ChangeLogParameters(database);
        String changeLogFile = failedChangeSet.getChangeLog().getFilePath();
        Liquibase liquibase = new Liquibase(changeLogFile, Scope.getCurrentScope().getResourceAccessor(), database);
        LockService lockService = LockServiceFactory.getInstance().getLockService(database);
        ChangeSet partialChangeSet = new ChangeSet(failedChangeSet.getId(), failedChangeSet.getAuthor(), false, false, failedChangeSet.getFilePath(), failedChangeSet.getContextFilter().toString(), null, liquibase.getDatabaseChangeLog());
        boolean hasPartialChangeSetToRollback = !deployedChangesFromFailedChangeSet.isEmpty();
        boolean allPartialChangesSupportRollback = deployedChangesFromFailedChangeSet.stream().allMatch(change -> change.supportsRollback(database));
        boolean hasChangeSetsToRollback = !changeSetsToRollback.isEmpty();
        boolean allChangeSetsSupportRollback = changeSetsToRollback.stream().allMatch(changeSet -> changeSet.supportsRollback(database));
        if (!hasChangeSetsToRollback && !hasPartialChangeSetToRollback) {
            throw resultsBuilder.commandFailed(String.format(NO_CHANGE_SETS_TO_ROLLBACK, failedChangeSet.getId(), failedChangeSet.getAuthor(), failedChangeSet.getFilePath()), 1);
        }
        if (hasChangeSetsToRollback && !allChangeSetsSupportRollback || hasPartialChangeSetToRollback && !allPartialChangesSupportRollback) {
            throw resultsBuilder.commandFailed(String.format(CHANGE_SET_DOES_NOT_SUPPORT_ROLLBACK_ERROR_MESSAGE, failedChangeSet.getId(), failedChangeSet.getAuthor(), failedChangeSet.getFilePath()), 1);
        }
        String rollbackErrorMsg = String.format(ROLLBACK_ON_ERROR_WILL_BE_EXECUTED, failedChangeSet.getId(), failedChangeSet.getAuthor(), failedChangeSet.getFilePath());
        Scope.getCurrentScope().getUI().sendMessage(rollbackErrorMsg);
        if (updateReport != null) {
            updateReport.getOperationInfo().setOperationOutcomeErrorMsg(rollbackErrorMsg);
        }
        Collections.reverse(changeSetsToRollback);
        lockService.waitForLock();
        ArrayList processedChangesets = new ArrayList();
        boolean shouldRollbackPartialChanges = !(database instanceof PostgresDatabase) && !(database instanceof MSSQLDatabase) && !(database instanceof DB2Database) || (Boolean)LiquibaseProConfiguration.FORCE_ROLLBACK_ON_ERROR_PARTIAL_CHANGES.getCurrentValue() != false;
        try {
            if (hasPartialChangeSetToRollback) {
                if (shouldRollbackPartialChanges) {
                    Collections.reverse(deployedChangesFromFailedChangeSet);
                    deployedChangesFromFailedChangeSet.forEach(arg_0 -> ((ChangeSet)partialChangeSet).addChange(arg_0));
                    Scope.getCurrentScope().getUI().sendMessage(String.format(PARTIAL_CHANGE_SETS_TO_ROLLBACK, failedChangeSet.getId(), failedChangeSet.getAuthor(), failedChangeSet.getFilePath()));
                    this.rollback(partialChangeSet, database);
                    Scope.getCurrentScope().getUI().sendMessage(PARTIAL_CHANGE_SETS_TO_ROLLBACK_COMPLETE);
                } else {
                    log.info(String.format("Skipping partial rollback changeset due to detected DBMS (%s)", database.getShortName()));
                }
            }
            for (ChangeSet changeSet2 : changeSetsToRollback) {
                String changeLogForChangeSet = changeSet2.getChangeLog().getFilePath();
                CommandScope liquibaseCommand = this.createRollbackOneChangeSetCommand(changeLogForChangeSet, changeSet2, database, liquibase, changeLogParameters);
                CommandResults commandResults = liquibaseCommand.execute();
                processedChangesets.addAll((List)commandResults.getResult("processedChangesets"));
            }
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)ChangesetsRolledback.fromChangesetList(processedChangesets));
            Scope.getCurrentScope().addMdcValue("changelogFile", changeLogFile);
            Scope.getCurrentScope().addMdcValue("liquibaseInternalCommand", COMMAND_NAME[0]);
            throw resultsBuilder.commandFailed(String.format(ROLLBACK_ON_ERROR_COMPLETE, changeLogFile), 1, true);
        }
        catch (Throwable throwable) {
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)ChangesetsRolledback.fromChangesetList(processedChangesets));
            try {
                lockService.releaseLock();
            }
            catch (LockException e) {
                log.severe(MSG_COULD_NOT_RELEASE_LOCK, (Throwable)e);
            }
            throw throwable;
        }
    }

    private CommandScope createRollbackOneChangeSetCommand(String changeLog, ChangeSet changeSet, Database database, Liquibase liquibase, ChangeLogParameters changeLogParameters) throws LiquibaseException {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        argsMap.put("changeLogFile", changeLog);
        argsMap.put(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG.getName(), database);
        argsMap.put("liquibase", liquibase);
        argsMap.put("changeLogParameters", changeLogParameters);
        argsMap.put("changeSetId", changeSet.getId());
        argsMap.put("changeSetAuthor", changeSet.getAuthor());
        argsMap.put("changeSetPath", changeSet.getFilePath());
        argsMap.put("force", Boolean.TRUE);
        argsMap.put(RollbackOneChangesetCommandStep.SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK.getName(), false);
        CommandScope liquibaseCommand = new CommandScope(new String[]{RollbackOneChangesetCommandStep.COMMAND_NAME[0]});
        for (Map.Entry entry : argsMap.entrySet()) {
            liquibaseCommand.addArgumentValue((String)entry.getKey(), entry.getValue());
        }
        return liquibaseCommand;
    }

    private void rollback(ChangeSet changeSet, Database database) throws RollbackFailedException {
        Executor originalExecutor = this.setupCustomExecutorIfNecessary(changeSet, database);
        try {
            if (database.supportsDDLInTransaction()) {
                database.setAutoCommit(!changeSet.isRunInTransaction());
            }
            if (changeSet.hasCustomRollbackChanges()) {
                LinkedList<SqlStatement> statements = new LinkedList<SqlStatement>();
                for (Change change : changeSet.getRollback().getChanges()) {
                    if (change instanceof DbmsTargetedChange && !DatabaseList.definitionMatches((String)((DbmsTargetedChange)change).getDbms(), (Database)database, (boolean)true)) continue;
                    ValidationErrors errors = change.validate(database);
                    if (errors.hasErrors()) {
                        throw new RollbackFailedException("Rollback statement failed validation: " + errors);
                    }
                    SqlStatement[] changeStatements = change.generateStatements(database);
                    if (changeStatements == null) continue;
                    statements.addAll(Arrays.asList(changeStatements));
                }
                if (!statements.isEmpty()) {
                    database.executeRollbackStatements(statements.toArray(new SqlStatement[0]), changeSet.getSqlVisitors());
                }
            } else {
                List changes = changeSet.getChanges();
                for (int i = changes.size() - 1; i >= 0; --i) {
                    Change change = (Change)changes.get(i);
                    database.executeRollbackStatements(change, changeSet.getSqlVisitors());
                }
            }
            if (changeSet.isRunInTransaction()) {
                database.commit();
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("ChangeSet " + changeSet + " has been successfully rolled back.");
        }
        catch (Exception e) {
            try {
                database.rollback();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            throw new RollbackFailedException((Throwable)e);
        }
        finally {
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", database, originalExecutor);
            if (!changeSet.isRunInTransaction() && database.supportsDDLInTransaction()) {
                try {
                    database.setAutoCommit(false);
                }
                catch (DatabaseException e) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Could not resetInternalState autocommit", (Throwable)e);
                }
            }
        }
    }

    private Executor setupCustomExecutorIfNecessary(ChangeSet changeSet, Database database) {
        Executor originalExecutor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        if (changeSet.getRunWith() == null || originalExecutor instanceof LoggingExecutor) {
            return originalExecutor;
        }
        String executorName = ChangeSet.lookupExecutor((String)changeSet.getRunWith());
        Executor customExecutor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor(executorName, database);
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", database, customExecutor);
        List changes = changeSet.getChanges();
        for (Change change : changes) {
            ResourceAccessor resourceAccessor;
            if (!(change instanceof AbstractChange) || (resourceAccessor = ((AbstractChange)change).getResourceAccessor()) == null) continue;
            customExecutor.setResourceAccessor(resourceAccessor);
            break;
        }
        return originalExecutor;
    }

    private boolean findRollbackOnErrorArg(CommandScope commandScope) {
        Boolean scoped = (Boolean)Scope.getCurrentScope().get("rollbackOnError", Boolean.class);
        Boolean argument = (Boolean)commandScope.getConfiguredValue(ROLLBACK_ON_ERROR_ARG).getValue();
        Boolean dependency = (Boolean)commandScope.getDependency(RollbackOnErrorArgument.class);
        return Boolean.TRUE.equals(scoped) || Boolean.TRUE.equals(argument) || Boolean.TRUE.equals(dependency);
    }

    public static void executeCommand(Database database, DefaultChangeExecListener changeExecListener, Throwable exception, Boolean shouldRollback, UpdateReportParameters updateReportParameters) throws CommandExecutionException {
        CommandScope rollbackOnErrorCommand = new CommandScope(new String[]{"internalRollbackOnError"});
        rollbackOnErrorCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG, (Object)database);
        rollbackOnErrorCommand.addArgumentValue("exception", (Object)exception);
        rollbackOnErrorCommand.addArgumentValue("listener", (Object)changeExecListener);
        rollbackOnErrorCommand.addArgumentValue(RollbackOnErrorArgument.ROLLBACK_ON_ERROR_ARG, (Object)shouldRollback);
        rollbackOnErrorCommand.addArgumentValue("updateReportParameters", (Object)updateReportParameters);
        rollbackOnErrorCommand.execute();
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        ROLLBACK_ON_ERROR_ARG = builder.argument("rollbackOnError", Boolean.class).defaultValue((Object)false).build();
        EXCEPTION_ARG = builder.argument("exception", LiquibaseException.class).required().build();
        LISTENER = builder.argument("listener", DefaultChangeExecListener.class).required().build();
        UPDATE_REPORT_PARAMETERS_ARG = builder.argument("updateReportParameters", UpdateReportParameters.class).build();
    }
}

