/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.checks.CustomScriptArguments;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import com.datical.liquibase.ext.scripts.ScriptExecutor;
import com.datical.liquibase.ext.scripts.ScriptReturnDTO;
import com.datical.liquibase.ext.util.CustomScriptUtil;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.exception.LiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.resource.Resource;
import org.apache.commons.lang3.StringUtils;

public class ScriptCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"script"};
    public static final CommandArgumentDefinition<String> SCRIPT_PATH_ARG;
    public static final CommandArgumentDefinition<String> SCRIPT_TYPE_ARG;
    public static final CommandArgumentDefinition<String> SCRIPT_ARGS;
    public static final CommandArgumentDefinition<Bindings> BINDINGS_ARG;
    public static final CommandArgumentDefinition<Resource> RESOURCE_ARG;
    public static final CommandArgumentDefinition<ScriptExecutor> SCRIPT_EXECUTOR_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;
    public static final CommandArgumentDefinition<Boolean> RUNNING_IN_CHECKS_COMMAND;
    public static final String BINDING_SUFFIX = "_binding";
    public static final String ARG_SEGMENT = "_arg";

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription("Execute Python or Groovy script");
        commandDefinition.setHidden(true);
    }

    public List<Class<?>> requiredDependencies() {
        return Collections.singletonList(CustomScriptArguments.class);
    }

    public void validate(CommandScope commandScope) throws CommandValidationException {
        try {
            LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        }
        catch (CommandValidationException cve) {
            String message = "ERROR: No valid Pro license found to enable the 'script' command. Get a free trial license key at https://liquibase.com/trial and include liquibase.licenseKey in defaults file, or add via CLI or Environment variable. Learn more at https://docs.liquibase.com";
            throw new CommandValidationException(message, (Throwable)cve);
        }
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        Resource scriptResource;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String scriptPath = (String)commandScope.getArgumentValue(SCRIPT_PATH_ARG);
        String scriptType = (String)commandScope.getArgumentValue(SCRIPT_TYPE_ARG);
        scriptType = ScriptCommandStep.determineScriptType(scriptType, scriptPath);
        if (Boolean.FALSE.equals(CustomScriptUtil.getCustomScriptArguments(commandScope).getEnabled())) {
            throw new CommandExecutionException("Execution of custom scripts is disabled. To run custom scripts, enable it via the checksScriptsEnabled argument.");
        }
        ScriptExecutor scriptExecutor = (ScriptExecutor)commandScope.getArgumentValue(SCRIPT_EXECUTOR_ARG);
        if (scriptExecutor == null) {
            throw new CommandExecutionException("You must specify a ScriptExecutor for script type '" + scriptType + "'");
        }
        Bindings bindings = (Bindings)commandScope.getArgumentValue(BINDINGS_ARG);
        if (bindings == null) {
            bindings = new SimpleBindings();
        }
        ScriptCommandStep.loadFlowVariables(bindings);
        ScriptCommandStep.loadScriptArgs(commandScope, bindings);
        bindings.put("script_path_binding", (Object)scriptPath);
        bindings.put("resultsBuilder_binding", (Object)resultsBuilder);
        bindings.put("logger_binding", (Object)Scope.getCurrentScope().getLog(ScriptCommandStep.class));
        bindings.put("ui_binding", (Object)Scope.getCurrentScope().getUI());
        if (!bindings.containsKey("status_binding")) {
            bindings.put("status_binding", (Object)new ScriptReturnDTO());
        }
        if ((scriptResource = (Resource)commandScope.getArgumentValue(RESOURCE_ARG)) == null && !(scriptResource = CustomScriptUtil.getScriptResource(scriptPath, commandScope)).exists()) {
            if (((Boolean)commandScope.getArgumentValue(RUNNING_IN_CHECKS_COMMAND)).booleanValue()) {
                return;
            }
            throw new LiquibaseException(String.format("Unable to locate script: '%s'", scriptPath));
        }
        try (InputStream is = scriptResource.openInputStream();
             InputStreamReader reader = new InputStreamReader(is);){
            Scope.getCurrentScope().getLog(ScriptCommandStep.class).info("Opening script at " + scriptResource.getUri().toString());
            Object returnValue = scriptExecutor.eval(reader);
            ScriptCommandStep.addReturnValue(resultsBuilder, returnValue);
            resultsBuilder.addResult("scriptExecutor", (Object)scriptExecutor);
        }
        catch (Exception e) {
            String message = String.format("Error while executing script '%s'", scriptPath);
            if (e.getMessage() == null) {
                ScriptReturnDTO returnDTO = (ScriptReturnDTO)bindings.get("status_binding");
                if (returnDTO.message != null) {
                    message = returnDTO.message;
                }
            } else if (e.getCause() != null) {
                message = e.getCause().getMessage();
                message = String.format("Error while executing script '%s': %s", scriptPath, message);
            } else {
                message = String.format("Error while executing script '%s': %s", scriptPath, e.getMessage());
            }
            throw new LiquibaseException(message);
        }
    }

    public static String determineScriptType(String scriptType, String scriptName) throws LiquibaseException {
        if (scriptType != null) {
            return scriptType;
        }
        Optional<String> optional = ScriptCommandStep.determineScriptExtension(scriptName);
        if (!optional.isPresent()) {
            throw new CommandExecutionException("Unable to determine script type from file name '" + scriptName + "'");
        }
        scriptType = optional.get();
        if (scriptType.equalsIgnoreCase("py")) {
            scriptType = "python";
        } else if (scriptType.equalsIgnoreCase("groovy")) {
            scriptType = "groovy";
        } else if (scriptType.equalsIgnoreCase("js")) {
            scriptType = "Graal.js";
        } else {
            throw new CommandExecutionException("Unable to determine script type from file name '" + scriptName + "'");
        }
        return scriptType;
    }

    private static void addReturnValue(CommandResultsBuilder resultsBuilder, Object returnValue) {
        if (returnValue instanceof Boolean) {
            resultsBuilder.addResult("returnValue", returnValue);
        } else {
            resultsBuilder.addResult("returnValue", (Object)Boolean.parseBoolean(returnValue.toString()));
        }
    }

    private static void loadScriptArgs(CommandScope commandScope, Bindings bindings) {
        String scriptArgs = (String)commandScope.getArgumentValue(SCRIPT_ARGS);
        if (StringUtils.isEmpty((CharSequence)scriptArgs)) {
            return;
        }
        String[] parts = scriptArgs.split(",");
        Arrays.stream(parts).forEach(part -> {
            String[] kv = part.trim().split("=");
            if (kv.length == 1) {
                throw new IllegalArgumentException("Invalid script argument '" + kv[0] + "'");
            }
            bindings.put(kv[0].trim() + ARG_SEGMENT + BINDING_SUFFIX, (Object)kv[1].trim());
        });
    }

    private static void loadFlowVariables(Bindings bindings) {
        Map<String, Object> variables = (Map<String, Object>)Scope.getCurrentScope().get("flowVariables", Map.class);
        if (variables != null) {
            variables = FlowVariableExpander.expandVariables(variables, variables);
            variables.forEach((k, v) -> bindings.put(k + BINDING_SUFFIX, v));
        }
    }

    private static Optional<String> determineScriptExtension(String scriptPath) {
        return Optional.ofNullable(scriptPath).filter(f -> f.contains(".")).map(f -> f.substring(scriptPath.lastIndexOf(".") + 1));
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        SCRIPT_PATH_ARG = builder.argument("script", String.class).required().description(ProStringUtil.markWithPro("Path of the script to execute")).build();
        SCRIPT_TYPE_ARG = builder.argument("scriptType", String.class).description(ProStringUtil.markWithPro("Type of script to execute")).build();
        SCRIPT_ARGS = builder.argument("scriptArgs", String.class).description(ProStringUtil.markWithPro("Comma-separated list of key/value script arguments")).build();
        BINDINGS_ARG = builder.argument("bindings", Bindings.class).hidden().description(ProStringUtil.markWithPro("Bindings to use when running this script")).build();
        SCRIPT_EXECUTOR_ARG = builder.argument("scriptExecutor", ScriptExecutor.class).hidden().description("ScriptExecutor instance to use when executing the script").build();
        RESOURCE_ARG = builder.argument("resourceArg", Resource.class).hidden().description("The Resource that contains the script").build();
        URL_ARG = builder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL.").build();
        DEFAULT_SCHEMA_NAME_ARG = builder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = builder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = builder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = builder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = builder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").build();
        PASSWORD_ARG = builder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        RUNNING_IN_CHECKS_COMMAND = builder.argument("runningInChecksCommand", Boolean.class).hidden().defaultValue((Object)false).description("Indicates if the script is being run as part of a checks command").build();
    }
}

