/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.config.LiquibaseFlowConfiguration;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.FlowShellCommandChange;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtil;
import liquibase.util.SystemUtil;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FlowShellCommandAction
extends Action {
    private String command;
    private String expandedCommand;
    private List<String> argsList;
    private FlowShellCommandChange commandChange;
    private String interpreter = SystemUtil.isWindows() ? "cmd" : "bash";
    private static final String COMMAND_KEY = "command";

    public FlowShellCommandAction() {
    }

    public FlowShellCommandAction(String cmd) {
        this.setExpandedCommand(cmd);
        this.commandChange = new FlowShellCommandChange();
        this.setCommand(cmd);
        String interpreterFromScope = (String)Scope.getCurrentScope().get(FlowCommandStep.FLOW_SHELL_INTERPRETER.getName(), String.class);
        if (interpreterFromScope == null) {
            if (SystemUtil.isWindows()) {
                this.setInterpreter("cmd");
            } else {
                this.setInterpreter("bash");
            }
        } else {
            this.setInterpreter(interpreterFromScope);
        }
    }

    public String getCommandOutput() {
        return this.commandChange.getStdout();
    }

    @Override
    public String getType() {
        return "shell";
    }

    public String toString() {
        if (Boolean.TRUE.equals(LiquibaseFlowConfiguration.FLOW_VERBOSE_TO_STRING.getCurrentValue())) {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
        return String.format("'%s' %s", this.getType(), this.command);
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(String interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getExpandedCommand() {
        return this.expandedCommand;
    }

    public void setExpandedCommand(String expandedCommand) {
        this.expandedCommand = expandedCommand;
    }

    public List<String> getArgsList() {
        return this.argsList;
    }

    public void setArgsList(List<String> argsList) {
        this.argsList = argsList;
    }

    public void setCommandChange(FlowShellCommandChange commandChange) {
        this.commandChange = commandChange;
    }

    @Override
    public Action fromAction(Map<String, Object> actionMap, Map<String, Object> variables) {
        FlowShellCommandAction shellAction = new FlowShellCommandAction();
        String commandLine = (String)actionMap.get(COMMAND_KEY);
        if (StringUtil.isEmpty((String)commandLine)) {
            throw new IllegalArgumentException("Empty command found");
        }
        Map<String, Object> mapWithOneEntry = Collections.singletonMap(COMMAND_KEY, commandLine);
        Map<String, Object> expandedVariables = FlowVariableExpander.expandVariables(variables, variables);
        Map<String, Object> expandedCommandMap = FlowVariableExpander.expandVariables(mapWithOneEntry, expandedVariables);
        String commandLineToExpand = (String)expandedCommandMap.get(COMMAND_KEY);
        commandLine = FlowVariableExpander.execShellToExpand(commandLineToExpand);
        shellAction.setExpandedCommand(commandLine);
        String[] parsed = FlowShellCommandAction.parseToArray((String)expandedCommandMap.get(COMMAND_KEY));
        if (!parsed[0].equals(this.interpreter)) {
            shellAction.setCommand(shellAction.getExpandedCommand());
        } else {
            shellAction.setCommand(this.interpreter);
        }
        if (parsed.length > 1) {
            parsed = Arrays.copyOfRange(parsed, 1, parsed.length);
            shellAction.setArgsList(Arrays.asList(parsed));
        }
        Map<String, Object> expandedUserMetadata = FlowVariableExpander.expandVariables((Map)actionMap.get("userMetadata"), expandedVariables);
        this.addUserMetadata(expandedUserMetadata, shellAction);
        shellAction.commandChange = new FlowShellCommandChange();
        return shellAction;
    }

    @Override
    public void validate(String flowFileArg) throws CommandExecutionException {
    }

    @Override
    public void execute(CommandResultsBuilder resultsBuilder) throws CommandExecutionException {
        CommandScope scope = resultsBuilder.getCommandScope();
        String interpreterFromScope = (String)scope.getArgumentValue(FlowCommandStep.FLOW_SHELL_INTERPRETER);
        if (interpreterFromScope != null) {
            this.setInterpreter(interpreterFromScope);
        }
        Scope.getCurrentScope().getLog(FlowCommandStep.class).info("Using interpreter '" + this.interpreter + "'");
        boolean keepTempFiles = (Boolean)scope.getArgumentValue(FlowCommandStep.FLOW_SHELL_KEEP_TEMP_FILES);
        this.run(keepTempFiles);
    }

    public void run(boolean keepTempFiles) {
        if (!this.command.equals(this.interpreter)) {
            Path outFile = FlowShellCommandAction.createTempFile(keepTempFiles, this.interpreter);
            ArrayList<String> parsedList = new ArrayList<String>();
            if (this.interpreter.equals("cmd")) {
                parsedList.add("@ECHO OFF");
            }
            String[] parsed = this.getExpandedCommand().split("\n");
            parsedList.addAll(Arrays.asList(parsed));
            String[] finalArray = parsedList.toArray(new String[0]);
            FlowShellCommandAction.addCommandsToTempFile(finalArray, outFile);
            this.setArgsList(new ArrayList<String>());
            if (this.interpreter.equals("cmd")) {
                this.argsList.add("/c");
            } else {
                this.argsList.add("-c");
            }
            String tmpFilePath = outFile.toFile().getAbsolutePath();
            if (SystemUtil.isWindows() && this.interpreter.equals("bash")) {
                tmpFilePath = tmpFilePath.replace("\\", "\\\\");
            }
            this.argsList.add(tmpFilePath);
        }
        this.setCommand(this.interpreter);
        this.commandChange.setExecutable(this.command);
        if (this.argsList != null) {
            this.argsList.forEach(arg_0 -> ((FlowShellCommandChange)this.commandChange).addArg(arg_0));
        }
        this.commandChange.createShellCommandArray();
        try {
            this.commandChange.executeShellCommand();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Path createTempFile(boolean keepTempFiles, String interpreter) {
        Path outFile = null;
        try {
            File f = null;
            if (SystemUtil.isWindows()) {
                if (interpreter.equals("bash")) {
                    f = Files.createTempFile("flow-", ".sh", new FileAttribute[0]).toFile();
                    boolean b = f.setExecutable(true);
                    if (!b) {
                        throw new UnexpectedLiquibaseException("Unable to set file '" + f.getAbsolutePath() + "' as executable");
                    }
                } else {
                    f = Files.createTempFile("flow-", ".bat", new FileAttribute[0]).toFile();
                }
            } else {
                FileAttribute<Set<PosixFilePermission>> rwx = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
                f = Files.createTempFile("flow-", ".sh", rwx).toFile();
            }
            if (!keepTempFiles) {
                f.deleteOnExit();
            }
            outFile = f.toPath();
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        return outFile;
    }

    private static String[] parseToArray(String toProcess) {
        if (toProcess == null || toProcess.isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public static void addCommandsToTempFile(String[] strings, Path outFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(outFile, new OpenOption[0]);){
            for (String line : strings) {
                line = line.trim();
                line = line.replace("\r", "");
                writer.write(line + "\n");
            }
        }
        catch (Exception ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
    }
}

