/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.reports.ReportUtils;
import com.datical.liquibase.ext.sqlgenerator.DatabaseChangeLogHistoryColumns;
import com.datical.liquibase.ext.statement.CreateDatabaseChangeLogHistoryTableStatement;
import com.datical.liquibase.ext.statement.InsertDatabaseChangeLogHistoryStatement;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import liquibase.ChecksumVersion;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.TempObjectQuotingStrategy;
import liquibase.database.core.DatabaseUtils;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.integration.IntegrationDetails;
import liquibase.logging.mdc.MdcManager;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.MarkChangeSetRanGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.Cache;
import liquibase.util.NetUtil;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtil;
import liquibase.util.VersionUtils;
import org.apache.commons.lang3.SystemProperties;

public class InsertDatabaseChangeLogHistoryGenerator
extends AbstractSqlGenerator<InsertDatabaseChangeLogHistoryStatement> {
    private static final Cache<String> extensionsCache = new Cache(() -> {
        Path workingDirectory = Paths.get(".", new String[0]).toAbsolutePath();
        List libraries = VersionUtils.listLibraries((Map)VersionUtils.getLibraryInfoMap(), (Path)VersionUtils.getLiquibaseHomePath((Path)workingDirectory), (Path)workingDirectory, null);
        return StringUtil.join((Collection)libraries, (String)", ");
    });

    public ValidationErrors validate(InsertDatabaseChangeLogHistoryStatement statement, Database database, SqlGeneratorChain<InsertDatabaseChangeLogHistoryStatement> sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(InsertDatabaseChangeLogHistoryStatement statement, Database database, SqlGeneratorChain<InsertDatabaseChangeLogHistoryStatement> sqlGeneratorChain) {
        String deploymentId;
        SqlStatement createHistoryTableStatement;
        ChangeSet changeSet = statement.getChangeSet();
        String interfaceName = InsertDatabaseChangeLogHistoryGenerator.getInterfaceName();
        String commandName = InsertDatabaseChangeLogHistoryGenerator.getFromMdc("liquibaseCommandName");
        String internalCommandName = InsertDatabaseChangeLogHistoryGenerator.getFromMdc("liquibaseInternalCommand");
        String tag = MarkChangeSetRanGenerator.getTagFromChangeset((ChangeSet)changeSet);
        if (tag == null) {
            tag = (String)Scope.getCurrentScope().get("tag", String.class);
        }
        String args = InsertDatabaseChangeLogHistoryGenerator.getArgs();
        String extensions = this.getExtensions();
        ArrayList<Object> statements = new ArrayList<Object>();
        if (this.shouldCreateTable(statement) && (createHistoryTableStatement = this.createHistoryTableIfNotExists(database, statement.isLoggingExecutor())) != null) {
            statements.add(createHistoryTableStatement);
            statement.getDidCreateTable().set(true);
        }
        if ((deploymentId = (String)ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getDeploymentId)) == null) {
            ChangeLogHistoryService changelogService = ((ChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(ChangeLogHistoryServiceFactory.class)).getChangeLogService(database);
            deploymentId = changelogService.getDeploymentId();
        }
        Object sql = null;
        if (((Boolean)DatabaseChangelogHistoryConfiguration.CAPTURE_SQL.getCurrentValue()).booleanValue()) {
            sql = ObjectUtil.defaultIfNull((Object)changeSet, (Object)ObjectUtil.defaultIfNull((Object)Scope.getCurrentScope().get("completeSql", AtomicReference.class), null, AtomicReference::get), cs -> StringUtil.join((Collection)cs.getGeneratedSql(), (String)", "));
        }
        InsertStatement insertStatement = new InsertStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), DatabaseChangelogHistoryConfiguration.getTableName(database)).addColumnValue(DatabaseChangeLogHistoryColumns.ID.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getId)).addColumnValue(DatabaseChangeLogHistoryColumns.AUTHOR.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getAuthor)).addColumnValue(DatabaseChangeLogHistoryColumns.FILENAME.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getFilePath)).addColumnValue(DatabaseChangeLogHistoryColumns.COMMAND.getColumnName(), (Object)commandName).addColumnValue(DatabaseChangeLogHistoryColumns.INTERNAL_COMMAND.getColumnName(), (Object)internalCommandName).addColumnValue(DatabaseChangeLogHistoryColumns.ARGUMENTS.getColumnName(), (Object)StringUtil.limitSize((String)args, (int)255)).addColumnValue(DatabaseChangeLogHistoryColumns.OUTCOME.getColumnName(), (Object)statement.getOutcome()).addColumnValue(DatabaseChangeLogHistoryColumns.START.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, (Object)ObjectUtil.defaultIfNull((Object)statement.getCommandScope(), null, CommandScope::getOperationStartTime), ChangeSet::getOperationStartTime)).addColumnValue(DatabaseChangeLogHistoryColumns.END.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, (Object)new Date(), ChangeSet::getOperationStopTime)).addColumnValue(DatabaseChangeLogHistoryColumns.CONTEXTS.getColumnName(), (Object)this.getContextsColumn(changeSet)).addColumnValue(DatabaseChangeLogHistoryColumns.LABELS.getColumnName(), (Object)this.getLabelsColumn(changeSet)).addColumnValue(DatabaseChangeLogHistoryColumns.MD5SUM.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, null, cs -> cs.generateCheckSum(ChecksumVersion.latest()).toString())).addColumnValue(DatabaseChangeLogHistoryColumns.DESCRIPTION.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, null, cs -> StringUtil.limitSize((String)cs.getDescription(), (int)255))).addColumnValue(DatabaseChangeLogHistoryColumns.COMMENTS.getColumnName(), ObjectUtil.defaultIfNull((Object)changeSet, null, cs -> StringUtil.limitSize((String)cs.getComments(), (int)255))).addColumnValue(DatabaseChangeLogHistoryColumns.DEPLOYMENT_ID.getColumnName(), (Object)deploymentId).addColumnValue(DatabaseChangeLogHistoryColumns.EXECUTEDSQL.getColumnName(), sql).addColumnValue(DatabaseChangeLogHistoryColumns.LIQUIBASEVERSION.getColumnName(), (Object)MarkChangeSetRanGenerator.getLiquibaseBuildVersion()).addColumnValue(DatabaseChangeLogHistoryColumns.HOSTNAME.getColumnName(), (Object)NetUtil.getLocalHostName()).addColumnValue(DatabaseChangeLogHistoryColumns.SYSTEMUSER.getColumnName(), (Object)SystemProperties.getUserName()).addColumnValue(DatabaseChangeLogHistoryColumns.INTERFACE.getColumnName(), (Object)interfaceName).addColumnValue(DatabaseChangeLogHistoryColumns.EXTENSIONS.getColumnName(), (Object)extensions);
        if (tag != null) {
            insertStatement.addColumnValue(DatabaseChangeLogHistoryColumns.TAG.getColumnName(), (Object)tag);
        }
        statements.add(insertStatement);
        try (TempObjectQuotingStrategy tempObjectQuotingStrategy = database.temporarilySetObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);){
            Sql[] sqlArray = SqlGeneratorFactory.getInstance().generateSql(statements.toArray(SqlStatement.EMPTY_SQL_STATEMENT), database);
            return sqlArray;
        }
    }

    private static String getArgs() {
        String[] cliArgs = (String[])Scope.getCurrentScope().get("commandArguments", String[].class);
        Map mavenConfigurationProperties = (Map)Scope.getCurrentScope().get(Scope.Attr.mavenConfigurationProperties.name(), new HashMap());
        if (!mavenConfigurationProperties.isEmpty()) {
            cliArgs = mavenConfigurationProperties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList()).toArray(new String[0]);
        }
        return ReportUtils.getDisplayArgs(cliArgs);
    }

    private boolean shouldCreateTable(InsertDatabaseChangeLogHistoryStatement statement) {
        return !statement.isLoggingExecutor() || !statement.getDidCreateTable().get();
    }

    private static String getInterfaceName() {
        IntegrationDetails integrationDetails = (IntegrationDetails)Scope.getCurrentScope().get((Enum)Scope.Attr.integrationDetails, IntegrationDetails.class);
        String interfaceName = null;
        if (integrationDetails != null) {
            interfaceName = integrationDetails.getName();
        }
        return interfaceName;
    }

    private static String getFromMdc(String key) {
        MdcManager mdcManager = Scope.getCurrentScope().getMdcManager();
        Map mdc = mdcManager.getAll();
        String commandName = null;
        if (mdc != null) {
            commandName = String.valueOf(mdc.get(key));
        }
        return commandName;
    }

    private String getExtensions() {
        String extensions = null;
        if (((Boolean)DatabaseChangelogHistoryConfiguration.CAPTURE_EXTENSIONS.getCurrentValue()).booleanValue()) {
            try {
                extensions = (String)extensionsCache.get();
            }
            catch (Exception e) {
                extensions = "Failed to determine list of extensions.";
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to determine list of extensions for insertion into history table. Continuing.", (Throwable)e);
            }
        }
        return extensions;
    }

    private String getContextsColumn(ChangeSet changeSet) {
        if (changeSet != null) {
            return changeSet.buildFullContext();
        }
        return null;
    }

    private String getLabelsColumn(ChangeSet changeSet) {
        if (changeSet != null) {
            return changeSet.buildFullLabels();
        }
        return null;
    }

    private SqlStatement createHistoryTableIfNotExists(Database database, boolean loggingExecutor) {
        try {
            Table historyTable = InsertDatabaseChangeLogHistoryGenerator.getDatabaseChangeLogHistoryTable(new SnapshotControl(database, false, new Class[]{Table.class, Column.class}), database);
            if (historyTable == null) {
                CreateDatabaseChangeLogHistoryTableStatement createTableStatement = new CreateDatabaseChangeLogHistoryTableStatement();
                String tableName = DatabaseChangelogHistoryConfiguration.getTableName(database);
                String catalog = database.getLiquibaseCatalogName();
                String schema = database.getLiquibaseSchemaName();
                if (!loggingExecutor) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Creating database history table with name: " + database.escapeTableName(catalog, schema, tableName));
                    String catalogAndSchema = DatabaseUtils.buildCatalogAndSchemaString((String)catalog, (String)schema);
                    String inMessage = StringUtil.isEmpty((String)catalogAndSchema) ? "" : " in '" + catalogAndSchema + "'";
                    Scope.getCurrentScope().getUI().sendMessage("INFO: A new table '" + tableName + "' was created" + inMessage + " to track database changing Liquibase operations. The Pro property 'liquibase.dbclhistory.enabled=true' was configured on the CLI, or as Environment Variable or defaults file property, etc. To pause collecting history, set to 'false'. Learn more at " + "https://docs.liquibase.com/DATABASECHANGELOGHISTORY");
                }
                return createTableStatement;
            }
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        return null;
    }

    public static Table getDatabaseChangeLogHistoryTable(SnapshotControl snapshotControl, Database database) throws DatabaseException {
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            Table liquibaseTable = (Table)new Table().setName(DatabaseChangelogHistoryConfiguration.getTableName(database)).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName()));
            Table table = (Table)SnapshotGeneratorFactory.getInstance().createSnapshot((DatabaseObject)liquibaseTable, database, snapshotControl);
            return table;
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }
}

