/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.storedproc.StoredProcedureSnapshotGenerator;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;
import liquibase.util.StringUtil;

public class MySQLStoredProcedureSnapshotGenerator
extends StoredProcedureSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof MySQLDatabase) {
            int parentPriority = super.getPriority(objectType, database);
            if (parentPriority > 0) {
                return 50;
            }
            return parentPriority;
        }
        return -1;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{StoredProcedureSnapshotGenerator.class};
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        String snapshotObjectSql = this.getSnapshotObjectSql(storedDatabaseLogicExample, database);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List queryForList = executor.queryForList((SqlStatement)new RawSqlStatement(snapshotObjectSql));
        List<Map<String, ?>> rs = this.castToListOfMaps(queryForList);
        StringBuilder body = new StringBuilder();
        StringBuilder paramsString = new StringBuilder();
        String name = null;
        Boolean valid = null;
        for (Map<String, ?> row : rs) {
            if (name == null) {
                name = (String)row.get("Procedure");
            }
            if (body.length() != 0) continue;
            String objectBody = (String)row.get("Create Procedure");
            if (objectBody != null) {
                objectBody = objectBody.replaceAll("CREATE DEFINER=(.*) PROCEDURE ", "CREATE PROCEDURE ");
            } else {
                objectBody = " [CANNOT READ OBJECT BODY]";
                String warningMessage = null;
                if (database instanceof MariaDBDatabase) {
                    warningMessage = "\nThe current MariaDB user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. Learn more about altering permissions with suggested MariaDB GRANTs at https://docs.liquibase.com/workflows/liquibase-pro/mariadbgrants.html\n";
                } else if (database instanceof MySQLDatabase) {
                    warningMessage = "\nThe current MySQL user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. This is potentially due to a known\nMySQL bug https://bugs.mysql.com/bug.php?id=22763. Learn more about altering permissions with suggested MySQL GRANTs at\nhttps://docs.liquibase.com/workflows/liquibase-pro/mysqlgrants.html\n";
                }
                if (warningMessage != null) {
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: " + warningMessage);
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(warningMessage);
                }
            }
            body.append(objectBody.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        body = new StringBuilder(StringUtil.trimToEmpty((String)StringUtil.trimToEmpty((String)body.toString().replace("\r\n", "\n").replace("\r", "\n"))));
        StoredDatabaseLogic storedDatabaseLogic = ((StoredProcedure)((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(storedDatabaseLogicExample.getSchema())).setName(name)).setValid(valid)).setBody(body.toString());
        return storedDatabaseLogic;
    }

    public StoredDatabaseLogic performSnapshotAndBuildStoredObject2(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        String snapshotObjectSql = this.getSnapshotObjectSql(storedDatabaseLogicExample, database);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List queryForList = executor.queryForList((SqlStatement)new RawSqlStatement(snapshotObjectSql));
        List<Map<String, ?>> rs = this.castToListOfMaps(queryForList);
        StringBuilder body = new StringBuilder();
        StringBuilder paramsString = new StringBuilder();
        String name = null;
        String previousName = null;
        Boolean valid = null;
        for (Map<String, ?> row : rs) {
            if (name == null) {
                previousName = name = (String)row.get("OBJECT_NAME");
            }
            if (valid == null) {
                valid = "VALID".equals(row.get("STATUS"));
            }
            String dataType = (String)row.get("DATA_TYPE");
            String parameterMode = (String)row.get("PARAMETER_MODE");
            String parameterName = (String)row.get("PARAMETER_NAME");
            if (parameterName != null) {
                if (paramsString.length() > 0) {
                    paramsString.append(", ");
                }
                if (parameterMode != null) {
                    paramsString.append(parameterMode);
                    paramsString.append(" ");
                }
                paramsString.append(parameterName);
                paramsString.append(" ");
                paramsString.append(dataType.toUpperCase());
                Object charLength = row.get("CHAR_LENGTH");
                Number numericPrecision = (Number)row.get("NUMERIC_PRECISION");
                Number numericScale = (Number)row.get("NUMERIC_SCALE");
                if (charLength != null) {
                    paramsString.append("( ");
                    paramsString.append(charLength);
                    paramsString.append(" )");
                } else if (numericPrecision != null) {
                    paramsString.append("( ");
                    paramsString.append(numericPrecision);
                    if (numericScale != null) {
                        paramsString.append(", ");
                        paramsString.append(numericScale);
                    }
                    paramsString.append(" )");
                }
            }
            if (body.length() != 0) continue;
            String objectBody = (String)row.get("OBJECT_BODY");
            if (objectBody == null) {
                objectBody = " [CANNOT READ OBJECT BODY]";
                String warningMessage = null;
                if (database instanceof MariaDBDatabase) {
                    warningMessage = "\nThe current MariaDB user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. Learn more about altering permissions with suggested MariaDB GRANTs at https://docs.liquibase.com/workflows/liquibase-pro/mariadbgrants.html\n";
                } else if (database instanceof MySQLDatabase) {
                    warningMessage = "\nThe current MySQL user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. This is potentially due to a known\nMySQL bug https://bugs.mysql.com/bug.php?id=22763. Learn more about altering permissions with suggested MySQL GRANTs at\nhttps://docs.liquibase.com/workflows/liquibase-pro/mysqlgrants.html\n";
                }
                if (warningMessage != null) {
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: " + warningMessage);
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(warningMessage);
                }
            }
            body.append(objectBody.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        body = new StringBuilder(StringUtil.trimToEmpty((String)StringUtil.trimToEmpty((String)body.toString().replace("\r\n", "\n").replace("\r", "\n"))));
        String finalParamsString = " ( " + paramsString.toString() + " )";
        body.insert(0, "CREATE PROCEDURE " + name + finalParamsString + "\n\n");
        StoredDatabaseLogic storedDatabaseLogic = ((StoredProcedure)((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(storedDatabaseLogicExample.getSchema())).setName(name)).setValid(valid)).setBody(body.toString());
        return storedDatabaseLogic;
    }
}

