/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymChange;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.OutputChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.StringUtil;

public class MissingSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Synonym.class.isAssignableFrom(objectType)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, View.class, StoredProcedure.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{ForeignKey.class, Index.class};
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        Synonym synonym = (Synonym)missingObject;
        CreateSynonymChange change = new CreateSynonymChange();
        change.setSynonymName(synonym.getName());
        change.setObjectName(synonym.getObjectName());
        boolean isPrivate = synonym.isPrivate();
        if (comparisionDatabase instanceof MSSQLDatabase) {
            isPrivate = true;
        }
        change.setPrivate(isPrivate);
        change.setObjectType(synonym.getObjectType());
        if (isPrivate && synonym.getSchema() != null) {
            if (control.getIncludeCatalog()) {
                change.setSynonymCatalogName(synonym.getSchema().getCatalogName());
            }
            if (control.getIncludeSchema()) {
                change.setSynonymSchemaName(synonym.getSchema().getName());
            }
        }
        if (synonym.getObjectSchema() != null) {
            boolean schemaDifferent;
            String objectCatalogName = (String)synonym.getAttribute("_actualObjectCatalogName", String.class);
            if (objectCatalogName == null) {
                objectCatalogName = synonym.getObjectSchema().getCatalogName();
            }
            boolean catalogDifferent = !StringUtil.trimToEmpty((String)objectCatalogName).equalsIgnoreCase(StringUtil.trimToEmpty((String)referenceDatabase.getDefaultCatalogName()));
            boolean bl = schemaDifferent = !StringUtil.trimToEmpty((String)synonym.getObjectSchema().getName()).equalsIgnoreCase(StringUtil.trimToEmpty((String)referenceDatabase.getDefaultSchemaName()));
            if (catalogDifferent || control.getIncludeCatalog()) {
                change.setObjectCatalogName(objectCatalogName);
            }
            if (schemaDifferent || control.getIncludeSchema()) {
                change.setObjectSchemaName(synonym.getObjectSchema().getName());
            }
        }
        if (referenceDatabase instanceof OracleDatabase && change.getSynonymCatalogName() != null && change.getSynonymSchemaName() == null) {
            change.setSynonymSchemaName(change.getSynonymCatalogName());
            change.setSynonymCatalogName(null);
        }
        if (referenceDatabase instanceof OracleDatabase && change.getObjectCatalogName() != null && change.getObjectSchemaName() == null) {
            change.setObjectSchemaName(change.getObjectCatalogName());
            change.setObjectCatalogName(null);
        }
        if (referenceDatabase instanceof OracleDatabase && ((Boolean)missingObject.getAttribute("missingSchema", (Object)false)).booleanValue()) {
            OutputChange outputChange = new OutputChange();
            outputChange.setMessage("No schema found for the object pointed to by this synonym. This may mean it references an object across database link. Please ensure the synonym is being created correctly.");
            return new Change[]{outputChange, change};
        }
        return new Change[]{change};
    }
}

