/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.dto.AddTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.AlterTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.DropTypeAttribute;
import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.statement.compositetype.AlterCompositeTypeAttributesStatement;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="alterCompositeTypeAttributes", description="Add/Alter/Drop attributes in Composite Type", priority=5)
public class AlterCompositeTypeAttributesChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String typeName;
    private List<AddTypeAttribute> addAttributes = new ArrayList<AddTypeAttribute>();
    private List<AlterTypeAttribute> alterAttributes = new ArrayList<AlterTypeAttribute>();
    private List<DropTypeAttribute> dropAttributes = new ArrayList<DropTypeAttribute>();

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        if (this.addAttributes.isEmpty() && this.alterAttributes.isEmpty() && this.dropAttributes.isEmpty()) {
            validationErrors.addError("At least one of addAttribute/alterAttributes/dropAttributes must be set");
        }
        if (!this.addAttributes.isEmpty()) {
            for (AddTypeAttribute addTypeAttribute : this.addAttributes) {
                if (addTypeAttribute.getType() == null) {
                    validationErrors.addError("attribute 'type' is required for addAttribute");
                }
                if (addTypeAttribute.getName() != null) continue;
                validationErrors.addError("attribute 'name' is required for addAttribute");
            }
        }
        if (!this.alterAttributes.isEmpty()) {
            for (AlterTypeAttribute alterTypeAttribute : this.alterAttributes) {
                if (alterTypeAttribute.getNewType() == null) {
                    validationErrors.addError("attribute 'newType' is required for alterAttribute");
                }
                if (alterTypeAttribute.getName() != null) continue;
                validationErrors.addError("attribute 'name' is required for alterAttribute");
            }
        }
        if (!this.dropAttributes.isEmpty()) {
            for (DropTypeAttribute dropTypeAttribute : this.dropAttributes) {
                if (dropTypeAttribute.getName() != null) continue;
                validationErrors.addError("attribute 'name' is required for dropAttribute");
            }
        }
        return validationErrors;
    }

    public String getConfirmationMessage() {
        return "Composite type '" + this.typeName + "' successfully altered.";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new AlterCompositeTypeAttributesStatement(this.catalogName, this.schemaName, this.typeName, this.addAttributes, this.alterAttributes, this.dropAttributes)};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @DatabaseChangeProperty(description="Add Attributes definitions")
    public List<AddTypeAttribute> getAddAttributes() {
        if (this.addAttributes == null) {
            return new ArrayList<AddTypeAttribute>();
        }
        return this.addAttributes;
    }

    @DatabaseChangeProperty(description="Alter Attributes definitions")
    public List<AlterTypeAttribute> getAlterAttributes() {
        if (this.alterAttributes == null) {
            return new ArrayList<AlterTypeAttribute>();
        }
        return this.alterAttributes;
    }

    @DatabaseChangeProperty(description="Drop Attributes definitions")
    public List<DropTypeAttribute> getDropAttributes() {
        if (this.dropAttributes == null) {
            return new ArrayList<DropTypeAttribute>();
        }
        return this.dropAttributes;
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setAddAttributes(List<AddTypeAttribute> addAttributes) {
        this.addAttributes = addAttributes;
    }

    @Generated
    public void setAlterAttributes(List<AlterTypeAttribute> alterAttributes) {
        this.alterAttributes = alterAttributes;
    }

    @Generated
    public void setDropAttributes(List<DropTypeAttribute> dropAttributes) {
        this.dropAttributes = dropAttributes;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }
}

