/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.database.jvm;

import com.datical.liquibase.ext.config.LiquibaseSnowflakeConfiguration;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.openssl.PEMParser;
import net.snowflake.client.jdbc.internal.org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.InputDecryptorProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OperatorCreationException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCSException;

public class SnowflakeProJdbcConnection
extends ProJdbcConnection {
    private static final String PKI_AUTH_TYPE = "PKI";
    private static final String OAUTH_AUTH_TYPE = "OAUTH";

    public SnowflakeProJdbcConnection() {
    }

    public SnowflakeProJdbcConnection(Connection connection) {
        super(connection);
    }

    @Override
    public int getPriority() {
        return super.getPriority() + 1;
    }

    @Override
    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        String authType = (String)LiquibaseSnowflakeConfiguration.AUTHENTICATION_TYPE.getCurrentValue();
        if (PKI_AUTH_TYPE.equalsIgnoreCase(authType)) {
            driverProperties.put("privateKey", this.getPrivateKey());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Attempting PKI connection to Snowflake with URL: " + url);
        }
        if (OAUTH_AUTH_TYPE.equalsIgnoreCase(authType)) {
            String token = (String)LiquibaseSnowflakeConfiguration.AUTHENTICATION_TOKEN.getCurrentValue();
            this.throwIfNotPresent(token, "OAuth authentication type was specified, but token was not provided. Please provide one in the 'snowflake-auth-token' configuration.");
            driverProperties.put("authenticator", "oauth");
            driverProperties.put("token", token);
        }
        super.open(url, driverObject, driverProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrivateKey getPrivateKey() throws DatabaseException {
        String privateKeyFilePath = (String)LiquibaseSnowflakeConfiguration.PRIVATE_KEY_FILE_PATH.getCurrentValue();
        this.throwIfNotPresent(privateKeyFilePath, "For the PKI authentication type the 'snowflake-auth-private-key-path' configuration is required. Please specify the path to a valid Private Key file.");
        File privateKey = Paths.get(privateKeyFilePath, new String[0]).toFile();
        if (!privateKey.exists()) {
            this.throwIfNotPresent(null, String.format("No files found with specified path '%s'. ", privateKeyFilePath) + "Please verify 'snowflake-auth-private-key-path' configuration.");
        }
        PrivateKeyInfo privateKeyInfo = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(privateKey));){
            Object pemObject = pemParser.readObject();
            if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                String passphrase = (String)LiquibaseSnowflakeConfiguration.PRIVATE_KEY_FILE_PASSPHRASE.getCurrentValue();
                this.throwIfNotPresent(passphrase, "Used Private key is encrypted with a passphrase. Please provide one in the 'snowflake-auth-private-key-passphrase' configuration");
                InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passphrase.toCharArray());
                this.throwIfNotPresent(pkcs8Prov, "Wrong passphrase. Please provide correct passphrase in the 'snowflake-auth-private-key-passphrase' configuration");
                privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
            } else if (pemObject instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)pemObject;
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            PrivateKey privateKey2 = converter.getPrivateKey(privateKeyInfo);
            return privateKey2;
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            throw new DatabaseException("Unable to process private key with current configuration. Please check 'snowflake-auth-private-key-path', 'snowflake-auth-private-key-passphrase' and Private Key validity", e);
        }
    }

    private void throwIfNotPresent(Object config, String errorMessage) throws DatabaseException {
        if (config == null) {
            throw new DatabaseException(errorMessage);
        }
    }

    public boolean supports(String url) {
        return url.contains("snowflake");
    }
}

