/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.history;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryEntry;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryService;
import com.datical.liquibase.ext.reports.ReportUtils;
import com.datical.liquibase.ext.sqlgenerator.DatabaseChangeLogHistoryColumns;
import com.datical.liquibase.ext.statement.InsertDatabaseChangeLogHistoryStatement;
import com.datical.liquibase.ext.statement.SelectFromDatabaseChangeLogHistoryStatement;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import liquibase.ChecksumVersion;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.integration.IntegrationDetails;
import liquibase.logging.mdc.MdcManager;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.sqlgenerator.core.MarkChangeSetRanGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.Cache;
import liquibase.util.NetUtil;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtil;
import liquibase.util.VersionUtils;
import org.apache.commons.lang3.SystemProperties;

public class StandardDatabaseChangeLogHistoryService
implements DatabaseChangeLogHistoryService {
    private static final Cache<String> extensionsCache = new Cache(() -> {
        Path workingDirectory = Paths.get(".", new String[0]).toAbsolutePath();
        List libraries = VersionUtils.listLibraries((Map)VersionUtils.getLibraryInfoMap(), (Path)VersionUtils.getLiquibaseHomePath((Path)workingDirectory), (Path)workingDirectory, null);
        return StringUtil.join((Collection)libraries, (String)", ");
    });

    @Override
    public int getPriority(Database database) {
        return 1;
    }

    @Override
    public void insertHistoryEntry(ChangeSet changeSet, Database database, String outcome, CommandScope commandScope, AtomicBoolean createdTable) throws DatabaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        InsertDatabaseChangeLogHistoryStatement insertStatement = new InsertDatabaseChangeLogHistoryStatement(changeSet, outcome, commandScope, createdTable, executor instanceof LoggingExecutor);
        executor.execute((SqlStatement)insertStatement);
    }

    @Override
    public boolean historyTableExists(Database database) throws DatabaseException {
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            Table liquibaseTable = (Table)new Table().setName(DatabaseChangelogHistoryConfiguration.getTableName(database)).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName()));
            boolean bl = SnapshotGeneratorFactory.getInstance().createSnapshot((DatabaseObject)liquibaseTable, database, new SnapshotControl(database, false, new Class[]{Table.class, Column.class})) != null;
            return bl;
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    @Override
    public DatabaseChangeLogHistoryEntry buildEntry(ChangeSet changeSet, String outcome, CommandScope commandScope, Database database) {
        String interfaceName = StandardDatabaseChangeLogHistoryService.getInterfaceName();
        String commandName = StandardDatabaseChangeLogHistoryService.getFromMdc("liquibaseCommandName");
        String internalCommandName = StandardDatabaseChangeLogHistoryService.getFromMdc("liquibaseInternalCommand");
        String tag = MarkChangeSetRanGenerator.getTagFromChangeset((ChangeSet)changeSet);
        if (tag == null) {
            tag = (String)Scope.getCurrentScope().get("tag", String.class);
        }
        String args = StandardDatabaseChangeLogHistoryService.getArgs();
        String extensions = this.getExtensions();
        String deploymentId = (String)ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getDeploymentId);
        if (deploymentId == null) {
            deploymentId = Scope.getCurrentScope().getDeploymentId();
        }
        Object sql = null;
        if (((Boolean)DatabaseChangelogHistoryConfiguration.CAPTURE_SQL.getCurrentValue()).booleanValue()) {
            sql = ObjectUtil.defaultIfNull((Object)changeSet, (Object)ObjectUtil.defaultIfNull((Object)Scope.getCurrentScope().get("completeSql", AtomicReference.class), null, AtomicReference::get), cs -> StringUtil.join((Collection)cs.getGeneratedSql(), (String)", "));
        }
        DatabaseChangeLogHistoryEntry entry = this.getNewHistoryObject();
        entry.setId((String)ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getId));
        entry.setAuthor((String)ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getAuthor));
        entry.setFilename((String)ObjectUtil.defaultIfNull((Object)changeSet, null, ChangeSet::getFilePath));
        entry.setCommand(commandName);
        entry.setInternalCommand(internalCommandName);
        entry.setArguments(StringUtil.limitSize((String)args, (int)255));
        entry.setOutcome(outcome);
        entry.setStart((Date)ObjectUtil.defaultIfNull((Object)changeSet, (Object)ObjectUtil.defaultIfNull((Object)commandScope, null, CommandScope::getOperationStartTime), ChangeSet::getOperationStartTime));
        entry.setEnd((Date)ObjectUtil.defaultIfNull((Object)changeSet, (Object)new Date(), ChangeSet::getOperationStopTime));
        entry.setTag(tag);
        entry.setContexts(this.getContextsColumn(changeSet));
        entry.setLabels(this.getLabelsColumn(changeSet));
        entry.setMd5Sum((String)ObjectUtil.defaultIfNull((Object)changeSet, null, cs -> cs.generateCheckSum(ChecksumVersion.latest()).toString()));
        entry.setDescription((String)ObjectUtil.defaultIfNull((Object)changeSet, null, cs -> StringUtil.limitSize((String)cs.getDescription(), (int)255)));
        entry.setComments((String)ObjectUtil.defaultIfNull((Object)changeSet, null, cs -> StringUtil.limitSize((String)cs.getComments(), (int)255)));
        entry.setDeploymentId(deploymentId);
        entry.setExecutedSql(String.valueOf(sql));
        entry.setLiquibaseVersion(MarkChangeSetRanGenerator.getLiquibaseBuildVersion());
        entry.setHostname(NetUtil.getLocalHostName());
        entry.setSystemUser(SystemProperties.getUserName());
        entry.setIinterface(interfaceName);
        entry.setExtensions(extensions);
        return entry;
    }

    @Override
    public DatabaseChangeLogHistoryEntry getNewHistoryObject() {
        return new DatabaseChangeLogHistoryEntry();
    }

    @Override
    public List<DatabaseChangeLogHistoryEntry> getHistoryEntries(Database database, boolean verbose) throws DatabaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        SelectFromDatabaseChangeLogHistoryStatement selectStatement = new SelectFromDatabaseChangeLogHistoryStatement(verbose);
        List resultSet = executor.queryForList((SqlStatement)selectStatement);
        return DatabaseChangeLogHistoryColumns.fromResultSet(resultSet, verbose);
    }

    private static String getArgs() {
        String[] cliArgs = (String[])Scope.getCurrentScope().get("commandArguments", String[].class);
        Map mavenConfigurationProperties = (Map)Scope.getCurrentScope().get(Scope.Attr.mavenConfigurationProperties.name(), new HashMap());
        if (!mavenConfigurationProperties.isEmpty()) {
            cliArgs = mavenConfigurationProperties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList()).toArray(new String[0]);
        }
        return ReportUtils.getDisplayArgs(cliArgs);
    }

    private static String getInterfaceName() {
        IntegrationDetails integrationDetails = (IntegrationDetails)Scope.getCurrentScope().get((Enum)Scope.Attr.integrationDetails, IntegrationDetails.class);
        String interfaceName = null;
        if (integrationDetails != null) {
            interfaceName = integrationDetails.getName();
        }
        return interfaceName;
    }

    private static String getFromMdc(String key) {
        MdcManager mdcManager = Scope.getCurrentScope().getMdcManager();
        Map mdc = mdcManager.getAll();
        String commandName = null;
        if (mdc != null) {
            commandName = String.valueOf(mdc.get(key));
        }
        return commandName;
    }

    private String getExtensions() {
        String extensions = null;
        if (((Boolean)DatabaseChangelogHistoryConfiguration.CAPTURE_EXTENSIONS.getCurrentValue()).booleanValue()) {
            try {
                extensions = (String)extensionsCache.get();
            }
            catch (Exception e) {
                extensions = "Failed to determine list of extensions.";
                Scope.getCurrentScope().getLog(this.getClass()).warning("Failed to determine list of extensions for insertion into history table. Continuing.", (Throwable)e);
            }
        }
        return extensions;
    }

    private String getContextsColumn(ChangeSet changeSet) {
        if (changeSet != null) {
            return changeSet.buildFullContext();
        }
        return null;
    }

    private String getLabelsColumn(ChangeSet changeSet) {
        if (changeSet != null) {
            return changeSet.buildFullLabels();
        }
        return null;
    }
}

