/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator.compositetype;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.statement.compositetype.RenameCompositeTypeStatement;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class RenameCompositeTypeGenerator
extends AbstractSqlGenerator<RenameCompositeTypeStatement> {
    public boolean supports(RenameCompositeTypeStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(RenameCompositeTypeStatement statement, Database database, SqlGeneratorChain<RenameCompositeTypeStatement> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("oldTypeName", (Object)statement.getOldTypeName());
        validationErrors.checkRequiredField("newTypeName", (Object)statement.getNewTypeName());
        return validationErrors;
    }

    public Sql[] generateSql(RenameCompositeTypeStatement statement, Database database, SqlGeneratorChain<RenameCompositeTypeStatement> sqlGeneratorChain) {
        return new Sql[]{new UnparsedSql(String.format("ALTER TYPE %s RENAME TO %s", database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getOldTypeName(), CompositeType.class), database.escapeObjectName(statement.getNewTypeName(), CompositeType.class)), new DatabaseObject[0])};
    }
}

