/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.diff.compare;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;

public class CompositeTypeComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (CompositeType.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof CompositeType) || !(databaseObject2 instanceof CompositeType)) {
            return false;
        }
        CompositeType thisType = (CompositeType)databaseObject1;
        CompositeType otherType = (CompositeType)databaseObject2;
        if (!DefaultDatabaseObjectComparator.nameMatches((DatabaseObject)thisType, (DatabaseObject)otherType, (Database)accordingTo)) {
            return false;
        }
        return DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)thisType.getSchema(), (DatabaseObject)otherType.getSchema(), chain.getSchemaComparisons(), accordingTo);
    }

    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        return new String[]{databaseObject.getName().toLowerCase()};
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("name");
        exclude.add("typeAttributes");
        ObjectDifferences differences = chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
        differences.compare("name", databaseObject1, databaseObject2, (ObjectDifferences.CompareFunction)new ObjectDifferences.DatabaseObjectNameCompareFunction(CompositeType.class, accordingTo));
        return differences;
    }
}

