/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.diff.compare;

import com.datical.liquibase.ext.appdba.type.DataTypeAttribute;
import java.util.Locale;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;

public class TypeAttributeComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (DataTypeAttribute.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof DataTypeAttribute) || !(databaseObject2 instanceof DataTypeAttribute)) {
            return false;
        }
        DataTypeAttribute thisDataTypeAttribute = (DataTypeAttribute)databaseObject1;
        DataTypeAttribute otherDataTypeAttribute = (DataTypeAttribute)databaseObject2;
        if (!DefaultDatabaseObjectComparator.nameMatches((DatabaseObject)thisDataTypeAttribute, (DatabaseObject)otherDataTypeAttribute, (Database)accordingTo)) {
            return false;
        }
        return DatabaseObjectComparatorFactory.getInstance().isSameObject(thisDataTypeAttribute.getContainingObjects()[0], otherDataTypeAttribute.getContainingObjects()[0], chain.getSchemaComparisons(), accordingTo);
    }

    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        DataTypeAttribute dataTypeAttribute = (DataTypeAttribute)databaseObject;
        String hash = dataTypeAttribute.getName();
        DatabaseObject[] containingObjects = dataTypeAttribute.getContainingObjects();
        if (containingObjects != null && containingObjects.length > 0 && containingObjects[0] != null) {
            hash = hash + ":" + containingObjects[0].getName();
        }
        return new String[]{hash.toLowerCase(Locale.US)};
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("parentType");
        exclude.add("name");
        ObjectDifferences differences = chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
        differences.compare("name", databaseObject1, databaseObject2, (ObjectDifferences.CompareFunction)new ObjectDifferences.DatabaseObjectNameCompareFunction(DataTypeAttribute.class, accordingTo));
        return differences;
    }
}

