/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.diff.output.changelog;

import com.datical.liquibase.ext.appdba.markunused.change.MarkUnusedChange;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import liquibase.change.Change;
import liquibase.change.core.DropColumnChange;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.core.UnexpectedColumnChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;

public class UnexpectedColumnChangeGeneratorAppDBA
extends UnexpectedColumnChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        boolean supported;
        if (!LicenseServiceUtils.isProLicenseValid()) {
            return -1;
        }
        boolean bl = supported = database instanceof OracleDatabase || Column.class.isAssignableFrom(objectType);
        if (!supported || !((Boolean)LiquibaseProConfiguration.MARK_UNUSED_NOT_DROP.getCurrentValue()).booleanValue()) {
            return -1;
        }
        int priority = super.getPriority(objectType, database);
        if (priority == -1) {
            return -1;
        }
        return priority + 100;
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Change[] changes = super.fixUnexpected(unexpectedObject, control, referenceDatabase, comparisonDatabase, chain);
        if (changes != null) {
            for (int i = 0; i < changes.length; ++i) {
                if (!(changes[i] instanceof DropColumnChange)) continue;
                changes[i] = new MarkUnusedChange((DropColumnChange)changes[i]);
            }
        }
        return changes;
    }
}

