/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.DataTypeAttribute;
import com.datical.liquibase.ext.appdba.type.DropCompositeTypeChange;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.function.Function;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public class UnexpectedCompositeTypeChangeGenerator
extends LicenseCheckingChangeGenerator
implements UnexpectedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (CompositeType.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, View.class, DatabasePackage.class, DatabasePackageBody.class, StoredProcedure.class, Function.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[0];
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        CompositeType compositeType = (CompositeType)unexpectedObject;
        DropCompositeTypeChange change = new DropCompositeTypeChange();
        change.setTypeName(compositeType.getName());
        if (control.getIncludeCatalog()) {
            change.setCatalogName(compositeType.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(compositeType.getSchema().getName());
        }
        for (DataTypeAttribute attribute : compositeType.getTypeAttributes()) {
            control.setAlreadyHandledUnexpected((DatabaseObject)attribute);
        }
        return new Change[]{change};
    }
}

