/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.arguments.DriftDetectionArguments;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import java.util.Arrays;
import java.util.List;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.DiffChangelogCommandStep;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.command.core.helpers.ReferenceDbUrlConnectionCommandStep;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.license.LicenseServiceUtils;

public class ProDriftDetectCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"driftDetect"};
    public static final String DRIFT_EXIT_CODE = "driftExitCode";
    public static final String DRIFT_EXIT_MESSAGE_TEMPLATE = "ERROR: Liquibase detected drift of %d missing, %d changed, and %d unexpected objects between target '%s' and reference '%s'.%nFor additional details, inspect the output, set --format=JSON, or learn more at https://docs.liquibase.com/drift-reports.%nDiff command exited with error code %d";

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(DiffResult.class, FormattedDiffModel.class, DriftDetectionArguments.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        if (Arrays.equals(commandDefinition.getName(), COMMAND_NAME)) {
            commandDefinition.setHidden(true);
        }
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int result = super.getOrder(commandDefinition);
        if (result < 0 && !commandDefinition.getName()[0].equals(DiffCommandStep.COMMAND_NAME[0]) && !commandDefinition.getName()[0].equals(DiffChangelogCommandStep.COMMAND_NAME[0])) {
            return result;
        }
        return 1110;
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        DriftDetectionArguments arguments = (DriftDetectionArguments)commandScope.getDependency(DriftDetectionArguments.class);
        boolean isDriftEnabled = arguments.isEnabled();
        if (!isDriftEnabled) {
            return;
        }
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])DiffCommandStep.COMMAND_NAME);
        DiffResult diffResult = (DiffResult)resultsBuilder.getResult(DiffCommandStep.DIFF_RESULT.getName());
        int missingExitCode = 0;
        int unexpectedExitCode = 0;
        int changedExitCode = 0;
        if (!diffResult.getMissingObjects().isEmpty()) {
            missingExitCode = arguments.getMissingSeverity();
        }
        if (!diffResult.getUnexpectedObjects().isEmpty()) {
            unexpectedExitCode = arguments.getUnexpectedSeverity();
        }
        if (!diffResult.getChangedObjects().isEmpty()) {
            changedExitCode = arguments.getChangedSeverity();
        }
        int exitCode = 0;
        if (missingExitCode != 0 || unexpectedExitCode != 0 || changedExitCode != 0) {
            exitCode = Math.max(missingExitCode, Math.max(unexpectedExitCode, changedExitCode));
            resultsBuilder.addResult(DRIFT_EXIT_CODE, (Object)exitCode);
            String targetUrl = (String)commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG);
            String referenceTargetUrl = (String)commandScope.getArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_URL_ARG);
            throw resultsBuilder.commandFailed(String.format(DRIFT_EXIT_MESSAGE_TEMPLATE, diffResult.getMissingObjects().size(), diffResult.getChangedObjects().size(), diffResult.getUnexpectedObjects().size(), JdbcConnection.sanitizeUrl((String)targetUrl), JdbcConnection.sanitizeUrl((String)referenceTargetUrl), exitCode), exitCode, true);
        }
        resultsBuilder.addResult(DRIFT_EXIT_CODE, (Object)exitCode);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
    }
}

