/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.RollbackOneUpdateCommandStep;
import com.datical.liquibase.ext.command.helpers.ReportCommandArguments;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.util.LoggingExecutorTextUtil;

public class RollbackOneUpdateSqlCommandStep
extends RollbackOneUpdateCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneUpdateSql"};
    public static final CommandArgumentDefinition<Boolean> OUTPUT_DEFAULT_SCHEMA_ARG;
    public static final CommandArgumentDefinition<Boolean> OUTPUT_DEFAULT_CATALOG_ARG;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Generate the SQL to rollback one update from the database"));
    }

    @Override
    public List<Class<?>> requiredDependencies() {
        ArrayList dependencies = new ArrayList();
        dependencies.add(Writer.class);
        dependencies.addAll(super.requiredDependencies());
        dependencies.removeIf(aClass -> aClass.isAssignableFrom(ReportCommandArguments.class));
        return dependencies;
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        Boolean outputDefaultCatalog = (Boolean)commandScope.getArgumentValue(OUTPUT_DEFAULT_CATALOG_ARG);
        Boolean outputDefaultSchema = (Boolean)commandScope.getArgumentValue(OUTPUT_DEFAULT_SCHEMA_ARG);
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        Boolean force = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        String deploymentId = (String)commandScope.getArgumentValue(DEPLOYMENT_ID_ARG);
        commandScope.addArgumentValue(FORCE_ARG, (Object)(force == null || force != false ? 1 : 0));
        database.setOutputDefaultCatalog(outputDefaultCatalog.booleanValue());
        database.setOutputDefaultSchema(outputDefaultSchema.booleanValue());
        if (deploymentId == null) {
            deploymentId = this.findLatestDeploymentId(database);
        }
        LoggingExecutorTextUtil.outputHeader((String)("Rollback deployment ID '" + deploymentId + "'"), (Database)database, (String)databaseChangeLog.getFilePath());
        super.run(resultsBuilder);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        OUTPUT_DEFAULT_SCHEMA_ARG = builder.argument("outputDefaultSchema", Boolean.class).description("Control whether names of objects in the default schema are fully qualified or not. If true they are. If false, only objects outside the default schema are fully qualified").defaultValue((Object)true).build();
        OUTPUT_DEFAULT_CATALOG_ARG = builder.argument("outputDefaultCatalog", Boolean.class).description("Control whether names of objects in the default catalog are fully qualified or not. If true they are. If false, only objects outside the default catalog are fully qualified").defaultValue((Object)true).build();
        FORCE_ARG = builder.argument("force", Boolean.class).hidden().build();
        builder.addArgument(DEPLOYMENT_ID_ARG).build();
        builder.addArgument(ROLLBACK_SCRIPT_ARG).build();
    }
}

