/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfigurationValueObfuscator;

public class SqlplusConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> PATH;
    public static final ConfigurationDefinition<Integer> TIMEOUT;
    public static final ConfigurationDefinition<Boolean> TEMP_KEEP;
    public static final ConfigurationDefinition<String> ARGS;
    public static final ConfigurationDefinition<String> TEMP_NAME;
    public static final ConfigurationDefinition<String> TEMP_PATH;
    public static final ConfigurationDefinition<Boolean> TEMP_OVERWRITE;
    public static final ConfigurationDefinition<String> SQLERROR;
    public static final ConfigurationDefinition<Boolean> CREATE_SPOOL;
    public static final ConfigurationDefinition<String> USERNAME;
    public static final ConfigurationDefinition<String> PASSWORD;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.sqlplus");
        PATH = builder.define("path", String.class).setDescription("Path to sqlplus executable").build();
        TIMEOUT = builder.define("timeout", Integer.class).setDescription("Seconds to wait for sqlplus timeout").build();
        TEMP_KEEP = builder.define("keep.temp", Boolean.class).setDescription("If true, do not delete temporary sql files generated").setHidden(true).build();
        TEMP_NAME = builder.define("keep.temp.name", String.class).setDescription("Optionally, specify a custom filename").build();
        TEMP_PATH = builder.define("keep.temp.path", String.class).setDescription("Optionally, specify the path in which to store the temporary files. If not specified, the files will be stored in the system's temp directory.").build();
        TEMP_OVERWRITE = builder.define("keep.temp.overwrite", Boolean.class).setDescription("If true, overwrite any files in the specified directory with the same name").build();
        ARGS = builder.define("args", String.class).setDescription("Extra arguments which will be passed to the sqlplus executable").build();
        SQLERROR = builder.define("sqlerror", String.class).setDescription("Value to be used for the WHENEVER clause when sqlplus executes").build();
        CREATE_SPOOL = builder.define("createSpool", Boolean.class).setDescription("If true, create an Oracle spool file").build();
        USERNAME = builder.define("username", String.class).setDescription("Optionally, specify the username to use when executing. If not specified, the regular username will be used.").build();
        PASSWORD = builder.define("password", String.class).setDescription("Optionally, specify the pasword to use when executing. If not specified, the regular password will be used.").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }

    public static class ConfigurationKeys {
        public static final String BASE = "liquibase.sqlplus";
        public static final String KEEP_TEMP_BASE = "keep.temp";
        public static final String KEEP_TEMP_NAME = "keep.temp.name";
        public static final String KEEP_TEMP_PATH = "keep.temp.path";
        public static final String KEEP_TEMP_OVERWRITE = "keep.temp.overwrite";
        public static final String SQLERROR = "sqlerror";
        public static final String USERNAME = "username";
        public static final String PASSWORD = "password";

        public static String getFullKey(String keyName) {
            return "liquibase.sqlplus." + keyName;
        }
    }
}

