/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.database.core.ProDb2zConfiguration;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.Db2zDatabase;
import liquibase.exception.CommandValidationException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseServiceUtils;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import org.apache.commons.lang3.StringUtils;

public class ProDb2zCreateDatabaseChangeLogLockTableGenerator
extends AbstractSqlGenerator<CreateDatabaseChangeLogLockTableStatement> {
    public int getPriority() {
        return 6;
    }

    public boolean supports(CreateDatabaseChangeLogLockTableStatement statement, Database database) {
        return database instanceof Db2zDatabase;
    }

    public ValidationErrors validate(CreateDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (database instanceof Db2zDatabase && LicenseServiceUtils.isProLicenseValid()) {
            validationErrors.addAll(ProDb2zConfiguration.validateTrackingTablesLocationConsistency());
        }
        return validationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sql[] generateSql(CreateDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors;
        boolean usingDb2zProperties;
        String dbName = (String)ProDb2zConfiguration.CHANGELOG_TABLES_DATABASE.getCurrentValue();
        String tsName = (String)ProDb2zConfiguration.CHANGELOG_TABLES_TABLESPACE.getCurrentValue();
        String idxName = (String)ProDb2zConfiguration.DATABASECHANGELOGLOCK_INDEX.getCurrentValue();
        boolean bl = usingDb2zProperties = StringUtils.isNotEmpty((CharSequence)dbName) || StringUtils.isNotEmpty((CharSequence)tsName) || StringUtils.isNotEmpty((CharSequence)idxName);
        if (usingDb2zProperties) {
            try {
                ProDb2zConfiguration.checkProLicenseForDb2zFeatures();
            }
            catch (CommandValidationException e) {
                String errorMessage = "Using DB2z tracking table customization properties requires a valid Liquibase Pro license. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.";
                throw new UnexpectedLiquibaseException(errorMessage);
            }
        }
        if ((validationErrors = ProDb2zConfiguration.validateTrackingTablesLocationConsistency()).hasErrors()) {
            throw new RuntimeException("DB2z tracking tables configuration error: " + (String)validationErrors.getErrorMessages().get(0));
        }
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            String catalog = database.getLiquibaseCatalogName();
            String schema = database.getLiquibaseSchemaName();
            String tableName = database.escapeTableName(catalog, schema, database.getDatabaseChangeLogLockTableName());
            dbName = ProDb2zConfiguration.validateLicenseForProperty((String)ProDb2zConfiguration.CHANGELOG_TABLES_DATABASE.getCurrentValue(), ProDb2zConfiguration.CHANGELOG_TABLES_DATABASE.getKey());
            tsName = ProDb2zConfiguration.validateLicenseForProperty((String)ProDb2zConfiguration.CHANGELOG_TABLES_TABLESPACE.getCurrentValue(), ProDb2zConfiguration.CHANGELOG_TABLES_TABLESPACE.getKey());
            boolean hasDb = StringUtils.isNotEmpty((CharSequence)dbName);
            boolean hasTs = StringUtils.isNotEmpty((CharSequence)tsName);
            String createTable = String.format("CREATE TABLE %s (ID INTEGER NOT NULL, LOCKED SMALLINT NOT NULL, LOCKGRANTED TIMESTAMP, LOCKEDBY VARCHAR(255), PRIMARY KEY (ID))", tableName);
            if (hasDb && hasTs) {
                createTable = createTable + String.format(" IN %s.%s", dbName, tsName);
            } else if (hasTs) {
                createTable = createTable + String.format(" IN %s", tsName);
            } else if (hasDb) {
                createTable = createTable + String.format(" IN %s", dbName);
            }
            UnparsedSql createTableSql = new UnparsedSql(createTable, new DatabaseObject[]{this.getAffectedTable(database)});
            if (hasDb && hasTs) {
                idxName = ProDb2zConfiguration.validateLicenseForProperty((String)ProDb2zConfiguration.DATABASECHANGELOGLOCK_INDEX.getCurrentValue(), ProDb2zConfiguration.DATABASECHANGELOGLOCK_INDEX.getKey());
                if (StringUtils.isEmpty((CharSequence)idxName)) {
                    idxName = database.getDatabaseChangeLogLockTableName() + "_PK";
                }
                String qualifiedIdxName = database.escapeObjectName(idxName, Table.class);
                String createIndex = String.format("CREATE UNIQUE INDEX %s ON %s%s (ID)", qualifiedIdxName, schema != null && !schema.isEmpty() ? schema + "." : "", database.getDatabaseChangeLogLockTableName());
                UnparsedSql createIndexSql = new UnparsedSql(createIndex, new DatabaseObject[]{this.getAffectedTable(database)});
                Sql[] sqlArray = new Sql[]{createTableSql, createIndexSql};
                return sqlArray;
            }
            Sql[] sqlArray = new Sql[]{createTableSql};
            return sqlArray;
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    protected Relation getAffectedTable(Database database) {
        return new Table().setName(database.getDatabaseChangeLogLockTableName()).setSchema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName());
    }
}

