/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator.compositetype;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.DataTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.AddDataTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.AlterDataTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.DropDataTypeAttribute;
import com.datical.liquibase.ext.statement.compositetype.AlterCompositeTypeAttributesStatement;
import java.util.Iterator;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.AbstractLiquibaseSerializable;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class AlterCompositeTypeAttributesGenerator
extends AbstractSqlGenerator<AlterCompositeTypeAttributesStatement> {
    public boolean supports(AlterCompositeTypeAttributesStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(AlterCompositeTypeAttributesStatement statement, Database database, SqlGeneratorChain<AlterCompositeTypeAttributesStatement> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("typeName", (Object)statement.getName());
        if (!(statement.getAddAttributes() != null && !statement.getAddAttributes().isEmpty() || statement.getAlterAttributes() != null && !statement.getAlterAttributes().isEmpty() || statement.getDropAttributes() != null && !statement.getDropAttributes().isEmpty())) {
            validationErrors.addError("You must specify at least one attribute");
        }
        return validationErrors;
    }

    public Sql[] generateSql(AlterCompositeTypeAttributesStatement statement, Database database, SqlGeneratorChain<AlterCompositeTypeAttributesStatement> sqlGeneratorChain) {
        AbstractLiquibaseSerializable attribute;
        boolean addAttributesPresent = statement.getAddAttributes() != null && !statement.getAddAttributes().isEmpty();
        boolean alterAttributesPresent = statement.getAlterAttributes() != null && !statement.getAlterAttributes().isEmpty();
        boolean dropAttributesPresent = statement.getDropAttributes() != null && !statement.getDropAttributes().isEmpty();
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TYPE ").append(database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getName(), CompositeType.class));
        if (addAttributesPresent) {
            Iterator<AddDataTypeAttribute> addIterator = statement.getAddAttributes().iterator();
            while (addIterator.hasNext()) {
                attribute = addIterator.next();
                builder.append(" ADD ATTRIBUTE ").append(database.escapeObjectName(attribute.getName(), DataTypeAttribute.class)).append(" ").append(attribute.getType());
                if (StringUtils.isNotEmpty((CharSequence)attribute.getCollation())) {
                    builder.append(" COLLATE \"").append(attribute.getCollation()).append("\"");
                }
                if (StringUtils.isNotEmpty((CharSequence)attribute.getOnCreate())) {
                    builder.append(" ").append(attribute.getOnCreate());
                }
                if (!addIterator.hasNext()) continue;
                builder.append(",");
            }
        }
        if (addAttributesPresent && alterAttributesPresent) {
            builder.append(",");
        }
        if (alterAttributesPresent) {
            Iterator<AlterDataTypeAttribute> alterIterator = statement.getAlterAttributes().iterator();
            while (alterIterator.hasNext()) {
                attribute = alterIterator.next();
                builder.append(" ALTER ATTRIBUTE ").append(database.escapeObjectName(attribute.getName(), DataTypeAttribute.class)).append(" SET DATA TYPE ").append(attribute.getNewType());
                if (StringUtils.isNotEmpty((CharSequence)attribute.getCollation())) {
                    builder.append(" COLLATE \"").append(attribute.getCollation()).append("\"");
                }
                if (StringUtils.isNotEmpty((CharSequence)attribute.getOnUpdate())) {
                    builder.append(" ").append(attribute.getOnUpdate());
                }
                if (!alterIterator.hasNext()) continue;
                builder.append(",");
            }
        }
        if ((addAttributesPresent || alterAttributesPresent) && dropAttributesPresent) {
            builder.append(",");
        }
        if (dropAttributesPresent) {
            Iterator<DropDataTypeAttribute> dropIterator = statement.getDropAttributes().iterator();
            while (dropIterator.hasNext()) {
                attribute = dropIterator.next();
                builder.append(" DROP ATTRIBUTE ");
                if (attribute.isIfExists()) {
                    builder.append("IF EXISTS ");
                }
                builder.append(database.escapeObjectName(attribute.getName(), DataTypeAttribute.class));
                if (StringUtils.isNotEmpty((CharSequence)attribute.getOnDelete())) {
                    builder.append(" ").append(attribute.getOnDelete());
                }
                if (!dropIterator.hasNext()) continue;
                builder.append(",");
            }
        }
        return new Sql[]{new UnparsedSql(builder.toString(), new DatabaseObject[0])};
    }
}

